/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.security;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.common.ExceptionHelper;

public class SensitiveDataStore
implements Serializable {
    public static final String SENSITIVE_FAILURE_SLOGAN = "Sensitive data storage failure";
    private String smrsUserName = "";
    private String smrsPassword = "";
    private String rbsIntegrationCode = "";

    public String getSmrsUserName() {
        return this.smrsUserName;
    }

    public void setSmrsUserName(String inputSmrsUserName) {
        this.smrsUserName = inputSmrsUserName;
    }

    public String getSmrsPassword() {
        return this.smrsPassword;
    }

    public void setSmrsPassword(String inputSmrsPassword) {
        this.smrsPassword = inputSmrsPassword;
    }

    public String getRbsIntegrationCode() {
        return this.rbsIntegrationCode;
    }

    public void setRbsIntegrationCode(String inputRbsIntegrationCode) {
        this.rbsIntegrationCode = inputRbsIntegrationCode;
    }

    public void storeToDisc(String filePath) throws RbsConfigurationFailedException {
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(filePath);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(this.smrsUserName);
            oos.writeObject(this.smrsPassword);
            oos.writeObject(this.rbsIntegrationCode);
            oos.close();
            fos.close();
        }
        catch (Exception e) {
            throw new RbsConfigurationFailedException(SENSITIVE_FAILURE_SLOGAN, ExceptionHelper.appendReason((String)"Failed to store sensitive data to disc", (Throwable)e), e);
        }
        finally {
            try {
                oos.close();
                fos.close();
            }
            catch (Exception ignore) {}
        }
    }

    public static SensitiveDataStore restoreFromDisc(String filePath) throws RbsConfigurationFailedException {
        SensitiveDataStore sensitiveDataStore = null;
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            fis = new FileInputStream(filePath);
            ois = new ObjectInputStream(fis);
            Object readObject = ois.readObject();
            if (readObject instanceof String) {
                sensitiveDataStore = new SensitiveDataStore();
                sensitiveDataStore.setSmrsUserName((String)readObject);
                sensitiveDataStore.setSmrsPassword((String)ois.readObject());
                sensitiveDataStore.setRbsIntegrationCode((String)ois.readObject());
            } else {
                sensitiveDataStore = (SensitiveDataStore)readObject;
            }
        }
        catch (Exception e) {
            throw new RbsConfigurationFailedException(SENSITIVE_FAILURE_SLOGAN, ExceptionHelper.appendReason((String)"Failed to restore sensitive data from disc", (Throwable)e), e);
        }
        finally {
            try {
                ois.close();
                fis.close();
            }
            catch (Exception ignore) {}
        }
        return sensitiveDataStore;
    }
}

