/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.security;

import java.util.Random;
import se.ericsson.crbs.cat.mao.rbsconfiguration.security.CryptionHolder;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class StringEncryptor {
    private static final long FILE_ENCRYPTION_CONSTANT = 123L;
    private static final long DATABASE_ENCRYPTION_CONSTANT = 456L;
    private static final Class THIS_CLASS = StringEncryptor.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public CryptionHolder encrypt(String stringToBeEncrypted) {
        logger.traceEnter(THIS_CLASS, "encrypt()");
        Random random = new Random(System.currentTimeMillis());
        byte[] strBytes = stringToBeEncrypted.getBytes();
        long[] fileCryption = new long[strBytes.length];
        long[] databaseCryption = new long[strBytes.length];
        int randomInt = random.nextInt();
        for (int i = 0; i < strBytes.length; ++i) {
            fileCryption[i] = (long)strBytes[i] + (long)randomInt * 123L;
            databaseCryption[i] = (long)strBytes[i] + (long)randomInt * 456L;
        }
        logger.traceReturn(THIS_CLASS, "encrypt()");
        return new CryptionHolder(fileCryption, databaseCryption);
    }

    public String decrypt(CryptionHolder cryptionHolder) {
        logger.traceEnter(THIS_CLASS, "decrypt()");
        long[] fileCryption = cryptionHolder.getFileCryption();
        long[] databaseCryption = cryptionHolder.getDatabaseCryption();
        byte[] cryptionBytes = new byte[fileCryption.length];
        for (int i = 0; i < fileCryption.length; ++i) {
            cryptionBytes[i] = (byte)((fileCryption[i] * 456L - databaseCryption[i] * 123L) / 333L);
        }
        logger.traceReturn(THIS_CLASS, "decrypt()");
        return new String(cryptionBytes);
    }
}

