/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic;

import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.transactions.TransactionServicesFactoryImpl;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class CreateIpSecMo {
    private static final Class THIS_CLASS = CreateIpSecMo.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected final MoRepositoryWrapper moRepositoryWrapper;
    protected final MoFactoryMgrWrapper moFactoryMgrWrapper;

    public CreateIpSecMo(MoRepositoryWrapper inMoRepositoryWrapper, MoFactoryMgrWrapper inMoFactoryMgrWrapper) {
        this.moRepositoryWrapper = inMoRepositoryWrapper;
        this.moFactoryMgrWrapper = inMoFactoryMgrWrapper;
    }

    public void create() {
        logger.traceEnter(THIS_CLASS, "create()");
        while (true) {
            String errorMsg;
            try {
                TransactionFactory transFact = TransactionServicesFactoryImpl.getInstance().getCppTransactionFactory();
                Control control = transFact.create(1000);
                Coordinator coordinator = control.getCoordinator();
                try {
                    this.createDefaultIpSecMO(coordinator);
                    control.getTerminator().commit();
                }
                catch (MoAccessException mae) {
                    control.getTerminator().rollback();
                    String errorMsg2 = ExceptionHelper.appendReason((String)"Failed to create ipSec MO", (Throwable)mae);
                    logger.traceAbnormal(THIS_CLASS, errorMsg2);
                }
            }
            catch (TransactionRolledBackException exception) {
                errorMsg = ExceptionHelper.appendReason((String)"Failed to create ipSec MO. Retrying", (Throwable)exception);
                logger.traceDebug(THIS_CLASS, errorMsg);
                continue;
            }
            catch (InactiveTransactionException exception) {
                errorMsg = ExceptionHelper.appendReason((String)"Failed to create ipSec MO. Retrying", (Throwable)exception);
                logger.traceDebug(THIS_CLASS, errorMsg);
                continue;
            }
            break;
        }
        logger.traceReturn(THIS_CLASS, "create()");
    }

    private void createDefaultIpSecMO(Coordinator coordinator) throws MoAccessException {
        ManagedObject ipSecMo = this.moRepositoryWrapper.lookup("ManagedElement=1,IpSystem=1,IpSec=1");
        if (ipSecMo == null) {
            ManagedObject ipSystemMo = this.moRepositoryWrapper.lookup("ManagedElement=1,IpSystem=1");
            AttrListImpl attrList = new AttrListImpl();
            MoFactory moFactory = this.moFactoryMgrWrapper.lookup("IpSec");
            moFactory.createMo(ipSystemMo, (AttrList)attrList, "1", null, coordinator);
            RbsConfigurationReportLoggerFactory.getLogger().logAction("IpSec", "create", new String[0], new Object[0]);
        }
    }
}

