/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xml.sax.helpers.AttributesImpl;
import se.ericsson.cello.iptransport.IpInterfaceMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.crbs.cat.common.StringHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.ParserHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.ENodeBFunctionData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpInterfaceData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.RbsConfigurationData;
import se.ericsson.crbs.common.LdnHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;
import se.ericsson.crbs.omf.mao.xml.XMLElement;

public class DtdAttributesHandler {
    private static final String IP = "IP";
    private static final String IP_1_ = "IP-1-";
    private static final Class THIS_CLASS = DtdAttributesHandler.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    private DtdAttributesHandler() {
    }

    public static ENodeBFunctionData handleOssCorbaNameServer(String ossCorbaNameServer) throws IOException {
        logger.traceEnter(THIS_CLASS, "handleOssCorbaNameServer()");
        ENodeBFunctionData eNodeBFunctionData = new ENodeBFunctionData(null, new RbsConfigurationData(ossCorbaNameServer), null, null, null);
        logger.traceReturn(THIS_CLASS, "handleOssCorbaNameServer()");
        return eNodeBFunctionData;
    }

    public static XMLElement[] getIpSyncRefElements(XMLElement ipOverGigabitEthernetElement) {
        logger.traceEnter(THIS_CLASS, "getIpSyncRefElements()");
        List ipOverGigabitEthernetElementChildren = ipOverGigabitEthernetElement.getChildren();
        Iterator ipOverGigabitEthernetElementChildrenIter = ipOverGigabitEthernetElementChildren.iterator();
        XMLElement[] ipSyncRef = new XMLElement[7];
        int ipSyncRefCounter = 0;
        while (ipOverGigabitEthernetElementChildrenIter.hasNext()) {
            XMLElement xmlChild = (XMLElement)ipOverGigabitEthernetElementChildrenIter.next();
            if (!"IpSyncRef".equalsIgnoreCase(xmlChild.getType())) continue;
            ipSyncRef[ipSyncRefCounter] = xmlChild;
            ++ipSyncRefCounter;
        }
        logger.traceReturn(THIS_CLASS, "getIpSyncRefElements()");
        return ipSyncRef;
    }

    public static String handleIpInterFaceMoRef(IpInterfaceData ipInterfaceData) {
        logger.traceEnter(THIS_CLASS, "handleIpInterFaceMoRef()");
        String ipInterFaceMoRef = null;
        if (ipInterfaceData.getIpInterfaceId() != null) {
            ipInterFaceMoRef = ipInterfaceData.getIpInterFaceSlot() + "-" + IP + "-" + ipInterfaceData.getIpInterfaceId();
        }
        logger.traceReturn(THIS_CLASS, "handleIpInterFaceMoRef()");
        return ipInterFaceMoRef;
    }

    public static Map createHashMapFromNetworkSync(XMLElement[] networkSyncElements, XMLElement ipOverGigabitEthernetElement) throws IOException {
        logger.traceEnter(THIS_CLASS, "createHashMapFromNetworkSync()");
        HashMap<Integer, String> networkSyncMap = new HashMap<Integer, String>();
        XMLElement[] ipSyncRef = DtdAttributesHandler.getIpSyncRefElements(ipOverGigabitEthernetElement);
        int ipSyncRefPrio = 5;
        int maxSyncPrio = 8;
        String ipSyncRefId = null;
        DtdAttributesHandler.addSyncValuesToMap(networkSyncElements, networkSyncMap);
        for (int ipSyncRefIndex = 0; ipSyncRefIndex < ipSyncRef.length; ++ipSyncRefIndex) {
            if (ipSyncRef[ipSyncRefIndex] == null) continue;
            ipSyncRefId = DtdAttributesHandler.getIpSyncRefId(ipSyncRef[ipSyncRefIndex]);
            while (networkSyncMap.containsKey(new Integer(ipSyncRefPrio))) {
                ++ipSyncRefPrio;
            }
            if (ipSyncRefId != null) {
                networkSyncMap.put(new Integer(ipSyncRefPrio), IP_1_ + ipSyncRefId);
                ++ipSyncRefPrio;
            }
            if (ipSyncRefPrio > 8) break;
        }
        logger.traceReturn(THIS_CLASS, "createHashMapFromNetworkSync()");
        return networkSyncMap;
    }

    private static String getIpSyncRefId(XMLElement ipSyncRef) {
        String ipSyncRefId = null;
        AttributesImpl ipSyncRefAttributes = ipSyncRef.getAttributes();
        for (int attrIndex = 0; attrIndex < ipSyncRefAttributes.getLength(); ++attrIndex) {
            if (!"IpSyncRefId".equalsIgnoreCase(ipSyncRefAttributes.getQName(attrIndex))) continue;
            ipSyncRefId = StringHelper.emptyStringToNull((String)ipSyncRefAttributes.getValue(attrIndex));
        }
        return ipSyncRefId;
    }

    private static void addSyncValuesToMap(XMLElement[] networkSyncElements, Map networkSyncMap) throws IOException {
        if (networkSyncElements != null) {
            for (int nwSyncIndex = 0; nwSyncIndex < networkSyncElements.length; ++nwSyncIndex) {
                if (networkSyncElements[nwSyncIndex] == null) continue;
                AttributesImpl attributes = networkSyncElements[nwSyncIndex].getAttributes();
                DtdAttributesHandler.addTuSyncRefToMap(networkSyncMap, attributes);
            }
        }
    }

    private static void addTuSyncRefToMap(Map networkSyncMap, AttributesImpl attributes) throws IOException {
        logger.traceEnter(THIS_CLASS, "addTuSyncRefToMap()");
        String syncSlot = null;
        String syncPriority = null;
        int syncSlotCounter = 1;
        for (int attrIndex = 0; attrIndex < attributes.getLength(); ++attrIndex) {
            if ("syncSlot".equalsIgnoreCase(attributes.getQName(attrIndex))) {
                syncSlot = StringHelper.emptyStringToNull((String)attributes.getValue(attrIndex));
            } else if ("syncPriority".equalsIgnoreCase(attributes.getQName(attrIndex))) {
                syncPriority = StringHelper.emptyStringToNull((String)attributes.getValue(attrIndex));
            }
            if (syncPriority == null || syncSlot == null) continue;
            syncSlot = syncSlot + "-" + syncSlotCounter;
            ++syncSlotCounter;
            networkSyncMap.put(new Integer(syncPriority), syncSlot);
        }
        ParserHelper.checkMandatoryAttribute((String)"syncSlot", syncSlot);
        ParserHelper.checkMandatoryAttribute((String)"syncPriority", syncPriority);
        logger.traceReturn(THIS_CLASS, "addTuSyncRefToMap()");
    }

    public static String handleIpInterfaceId(MoRepositoryWrapper aMoRepository, XMLElement ipOverGigabitEthernetElement) throws NoSuchAttributeException, MoAccessException, IOException {
        String IpInterfaceId;
        block5: {
            logger.traceEnter(THIS_CLASS, "handleIpInterfaceId()");
            IpInterfaceMo ipInterfaceMo = null;
            IpInterfaceId = null;
            Integer vid = DtdAttributesHandler.getSyncVidValue(ipOverGigabitEthernetElement);
            try {
                MoIterator ipInterfaces = aMoRepository.lookupType("IpInterface");
                if (ipInterfaces == null) {
                    RbsConfigurationReportLoggerFactory.getLogger().logInformation("IP configuration", "WARNING: No IpInterface present for OaM (ID=1) when parsing SiteBasic.xml");
                    IpInterfaceId = "1";
                } else {
                    IpInterfaceId = String.valueOf(ipInterfaces.size() + 1);
                }
                if (ipInterfaces == null || vid == null) break block5;
                while (ipInterfaces.hasMoreElements()) {
                    IpInterfaceMo currentIpInterface = (IpInterfaceMo)ipInterfaces.nextMo();
                    if (vid.intValue() != currentIpInterface.getVid(null)) continue;
                    ipInterfaceMo = currentIpInterface;
                    IpInterfaceId = LdnHelper.getRdnAttributeValue((String)ipInterfaceMo.getLocalDistinguishedName());
                    break;
                }
            }
            catch (MoAccessException mae) {
                throw new RbsConfigurationFailedException("IpInterface", "Could not read attribute vid.", (Exception)((Object)mae));
            }
        }
        logger.traceReturn(THIS_CLASS, "handleIpInterfaceId()");
        return IpInterfaceId;
    }

    private static Integer getSyncVidValue(XMLElement ipOverGigabitEthernetElement) throws IOException {
        AttributesImpl attributes = ipOverGigabitEthernetElement.getAttributes();
        Integer vid = null;
        for (int index = 0; index < attributes.getLength(); ++index) {
            if (!"syncVid".equalsIgnoreCase(attributes.getQName(index))) continue;
            vid = ParserHelper.convertIntegerAttribute((String)attributes.getValue(index));
            break;
        }
        return vid;
    }
}

