/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic;

import java.io.IOException;
import java.util.List;
import se.ericsson.cello.ipsec.IpSecMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.crbs.cat.mao.nodeaddresschange.NodeAddressChangeParams;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.ParserHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationIpHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationIpHelperImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationSmrsHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.FileParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.SiteBasicParserHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.RbsConfigurationData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.SiteBasicData;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;
import se.ericsson.crbs.omf.mao.xml.Parser;

public class NodeAddressChangeParamsHandler {
    private static final Class THIS_CLASS = NodeAddressChangeParamsHandler.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    protected NodeAddressChangeParamsHandler() {
    }

    public static void storeNodeAddressChangeParams(RbsConfigurationMao rbsConfigurationMao) throws MoAccessException, IOException {
        logger.traceEnter(THIS_CLASS, "storeNodeAddressChangeParams()");
        rbsConfigurationMao.storePersistently("nodeIdType", "FDN");
        rbsConfigurationMao.storePersistently("nodeIdValue", "");
        String siteBasicFilePath = FileParameters.instance(rbsConfigurationMao).getSiteBasicFilePath();
        Boolean validateXml = Boolean.FALSE;
        String schemaPath = "rbsManagerMetaData/rbsConfiguration/";
        Parser parser = ParserHelper.createParser(siteBasicFilePath, validateXml, schemaPath);
        List xmlList = parser.getXMLelements();
        SiteBasicData siteBasicData = SiteBasicParserHelper.createSiteBasicDataStructure(xmlList);
        RbsConfigurationData rbsConfigurationData = siteBasicData.geteNodeBFunctionData().getRbsConfigurationData();
        if (rbsConfigurationData.getNodeIdType() != null) {
            rbsConfigurationMao.storePersistently("nodeIdType", rbsConfigurationData.getNodeIdType());
        }
        if (rbsConfigurationData.getNodeIdValue() != null) {
            rbsConfigurationMao.storePersistently("nodeIdValue", rbsConfigurationData.getNodeIdValue());
        }
        RbsConfigurationReportLoggerFactory.getLogger().logAction("Node Identity for Address Change", "Stored", new String[]{"nodeIdType", "nodeIdValue"}, new String[]{(String)rbsConfigurationMao.retrievePersistently("nodeIdType"), (String)rbsConfigurationMao.retrievePersistently("nodeIdValue")});
        logger.traceReturn(THIS_CLASS, "storeNodeAddressChangeParams()");
    }

    public static NodeAddressChangeParams getNodeAddressChangeParams(RbsConfigurationMao rbsConfigurationMao) {
        logger.traceEnter(THIS_CLASS, "getNodeAddressChangeParams()");
        try {
            NodeAddressChangeParamsHandler.retrieveIpSecCertFromMo(rbsConfigurationMao);
        }
        catch (MoAccessException e) {
            logger.traceError(THIS_CLASS, "Could not retrieve IpSec Cert From IpSec Mo");
        }
        String siteBasicNodeId = (String)rbsConfigurationMao.retrievePersistently("nodeIdValue");
        String nodeId = siteBasicNodeId != null && siteBasicNodeId.length() > 0 ? siteBasicNodeId : rbsConfigurationMao.getNamePrefix();
        String ipAddress = null;
        RbsConfigurationIpHelper ipHelper = (RbsConfigurationIpHelper)((Object)rbsConfigurationMao.getRbsConfigurationContext().getHelper(RbsConfigurationIpHelperImpl.class));
        try {
            ipAddress = ipHelper.getOamIpAddress(null);
        }
        catch (MoAccessException e) {
            logger.traceError(THIS_CLASS, "Could not get current OAM ip address.");
        }
        String sshKey = (String)rbsConfigurationMao.retrievePersistently("sshKey");
        RbsConfigurationSmrsHelper smrsHelper = (RbsConfigurationSmrsHelper)rbsConfigurationMao.getRbsConfigurationContext().getHelper(RbsConfigurationSmrsHelper.class);
        String installerName = smrsHelper.getSmrsInfo().getSmrsUserName();
        if (installerName == null) {
            installerName = "user";
        }
        int wantedSecLevel = (Integer)rbsConfigurationMao.retrievePersistently("wantedSecurityLevel");
        int minimumSecLevel = (Integer)rbsConfigurationMao.retrievePersistently("minimumSecurityLevel");
        int reachedSecLevel = (Integer)rbsConfigurationMao.retrievePersistently("reachedSecurityLevel");
        String securityChecksums = (String)rbsConfigurationMao.retrievePersistently("securityChecksums");
        String securityChecksumVersion = (String)rbsConfigurationMao.retrievePersistently("securityChecksumVersion");
        String oamCertSerNo = (String)rbsConfigurationMao.retrievePersistently("oamCertSerialNumber");
        String oamCertFingerPrint = (String)rbsConfigurationMao.retrievePersistently("oamCertFingerPrint");
        int wantedIpSecLevel = (Integer)rbsConfigurationMao.retrievePersistently("wantedIpSecLevel");
        int reachedIpSecLevel = (Integer)rbsConfigurationMao.retrievePersistently("reachedIpSecLevel");
        String iPSecCUSCertSerNo = (String)rbsConfigurationMao.retrievePersistently("IpSecSerialNumber");
        String iPSecCUSCertFingerPrint = (String)rbsConfigurationMao.retrievePersistently("IpSecFingerPrint");
        NodeAddressChangeParams result2 = new NodeAddressChangeParams(nodeId, ipAddress, sshKey, installerName, wantedSecLevel, minimumSecLevel, reachedSecLevel, securityChecksums, securityChecksumVersion, oamCertSerNo, oamCertFingerPrint, wantedIpSecLevel, reachedIpSecLevel, iPSecCUSCertSerNo, iPSecCUSCertFingerPrint);
        logger.traceDebug(THIS_CLASS, " nodeId: " + nodeId + " ipAddress: " + ipAddress + " sshKey: " + sshKey + " installerName: " + installerName + " wantedSecLevel: " + wantedSecLevel + " minimumSecLevel: " + minimumSecLevel + " reachedSecLevel: " + reachedSecLevel + " securityChecksums: " + securityChecksums + " securityChecksumVersion: " + securityChecksumVersion + " oamCertSerNo: " + oamCertSerNo + " oamCertFingerPrint: " + oamCertFingerPrint + " wantedIpSecLevel: " + wantedIpSecLevel + " reachedIpSecLevel: " + reachedIpSecLevel + " iPSecCUSCertSerNo: " + iPSecCUSCertSerNo + " iPSecCUSCertFingerPrint: " + iPSecCUSCertFingerPrint);
        logger.traceReturn(THIS_CLASS, "getNodeAddressChangeParams()");
        return result2;
    }

    private static void retrieveIpSecCertFromMo(RbsConfigurationMao aRbsConfigurationMao) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "retrieveIpSecCertFromMo()");
        RbsConfigurationMao rbsConfigurationMao = aRbsConfigurationMao;
        MoRepositoryWrapper aMoRepository = rbsConfigurationMao.getRbsConfigurationContext().getGenericMaoContext().getMoRepositoryWrapper();
        IpSecMo ipSecMo = (IpSecMo)aMoRepository.lookup("ManagedElement=1,IpSystem=1,IpSec=1");
        boolean isIpsecActivated = false;
        if (ipSecMo != null) {
            isIpsecActivated = ipSecMo.getFeatureState(null) == RbsConfigurationDefinitions.ACTIVATED.intValue();
        }
        Struct ipSecCertInfo = null;
        if (isIpsecActivated && ipSecMo != null && ipSecMo.getCertificate(null).size() > 0) {
            ipSecCertInfo = ipSecMo.getCertificate(null);
        }
        String serialNumber = "";
        String fingerPrint = "";
        if (ipSecCertInfo != null) {
            serialNumber = (String)ipSecCertInfo.getValue("serialNumber");
            fingerPrint = (String)ipSecCertInfo.getValue("fingerprint");
        }
        if (serialNumber != null && serialNumber.length() > 0 && fingerPrint != null && fingerPrint.length() > 0) {
            rbsConfigurationMao.storePersistently("IpSecSerialNumber", serialNumber);
            logger.traceDebug(THIS_CLASS, "IpSecSerialNumber = " + serialNumber);
            rbsConfigurationMao.storePersistently("IpSecFingerPrint", fingerPrint);
            logger.traceDebug(THIS_CLASS, "IpSecFingerPrint = " + fingerPrint);
        }
        logger.traceReturn(THIS_CLASS, "retrieveIpSecCertFromMo()");
    }
}

