/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.cello.managedelement.NtpServerMo;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.RbsConfigurationSiteBasicHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.ManagedElementDataData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class NtpServerConfigHandler
implements TransactionPackage {
    private static final Class THIS_CLASS = NtpServerConfigHandler.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final MoRepositoryWrapper aMoRepository;
    private final MoFactoryMgrWrapper aFactoryMgr;
    private final RbsConfigurationSiteBasicHelper siteBasicHelper;
    private final ManagedElementDataData managedElementDataData;
    private final List ntpServerInput;
    private final List ntpServerStatusInput;
    private final List ntpServerOutput;

    public NtpServerConfigHandler(GenericMaoContext aGenericMaoContextIn, RbsConfigurationSiteBasicHelper inSiteBasicHelper, ManagedElementDataData inManagedElementDataData) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "Constructor()");
        this.aMoRepository = aGenericMaoContextIn.getMoRepositoryWrapper();
        this.aFactoryMgr = aGenericMaoContextIn.getMoFactoryMgrWrapper();
        this.siteBasicHelper = inSiteBasicHelper;
        this.managedElementDataData = inManagedElementDataData;
        this.ntpServerInput = new ArrayList();
        this.ntpServerStatusInput = new ArrayList();
        this.ntpServerOutput = new ArrayList();
        this.setNtpServerInput();
        this.setNtpServerOutput();
        logger.traceReturn(THIS_CLASS, "Constructor()");
    }

    public void execute(Coordinator coordinator) throws MoAccessException, InactiveTransactionException {
        logger.traceEnter(THIS_CLASS, "execute()");
        this.updateExistingNtpServerMo(coordinator);
        for (int i = this.ntpServerOutput.size(); i < this.ntpServerInput.size(); ++i) {
            this.createNtpServerMo(this.siteBasicHelper, this.aFactoryMgr, this.aMoRepository, coordinator, i + 1, (String)this.ntpServerInput.get(i), (Boolean)this.ntpServerStatusInput.get(i));
            logger.traceGeneral(THIS_CLASS, "Created MO NtpServer=" + (i + 1) + " with: IP address " + (String)this.ntpServerInput.get(i) + " and ServiceActive = " + this.ntpServerStatusInput.get(i).toString());
        }
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    public void updateExistingNtpServerMo(Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "updateExistingNtpServerMo()");
        if (this.ntpServerInput.size() >= this.ntpServerOutput.size()) {
            for (int i = 0; i < this.ntpServerOutput.size(); ++i) {
                try {
                    NtpServerMo ntpServerMo = (NtpServerMo)this.ntpServerOutput.get(i);
                    this.siteBasicHelper.setAttributeWithLogging((ManagedObject)ntpServerMo, "serverAddress", (String)this.ntpServerInput.get(i), coordinator);
                    this.siteBasicHelper.setAttributeWithLogging((ManagedObject)ntpServerMo, "serviceActive", (Boolean)this.ntpServerStatusInput.get(i), coordinator);
                    this.siteBasicHelper.setAttributeWithLogging((ManagedObject)ntpServerMo, "userLabel", "", coordinator);
                    logger.traceGeneral(THIS_CLASS, "Changed attributes of NtpServer=" + (i + 1) + " with: new IP address " + (String)this.ntpServerInput.get(i) + " and ServiceActive = " + this.ntpServerStatusInput.get(i).toString());
                    continue;
                }
                catch (MoAccessException mae) {
                    String msg = "Unable to set values for NtpServer MO";
                    logger.traceDebug(THIS_CLASS, "Unable to set values for NtpServer MO due to exception: " + ExceptionHelper.convertToString((Throwable)mae));
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "updateExistingNtpServerMo()");
    }

    public void createNtpServerMo(RbsConfigurationSiteBasicHelper rbsConfigurationLoggerHelper, MoFactoryMgrWrapper aFactoryMgr1, MoRepositoryWrapper inMoRepository, Coordinator coordinator, int inIdOfNewMo, String inIpAddress, Boolean inService) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createNtpServerMo()");
        ManagedObject timeSettingMo = inMoRepository.lookup("ManagedElement=1,SystemFunctions=1,TimeSetting=1");
        if (timeSettingMo == null) {
            logger.traceAbnormal(THIS_CLASS, "Unable to find parent TimeSetting MO - cannot create new child NtpServer MO.");
        } else {
            AttrListImpl attrList = new AttrListImpl();
            attrList.addElement("serverAddress", (Object)inIpAddress);
            attrList.addElement("serviceActive", (Object)inService);
            String moId = "" + inIdOfNewMo;
            String moType = "NtpServer";
            NtpServerMo newNtpServerMo = (NtpServerMo)rbsConfigurationLoggerHelper.createMoWithLogging(timeSettingMo, attrList, moId, moType, aFactoryMgr1, coordinator);
            if (newNtpServerMo == null) {
                throw new RbsConfigurationFailedException("Cannot create NtpServer with ID = " + moId + ". ");
            }
        }
        logger.traceReturn(THIS_CLASS, "createNtpServerMo()");
    }

    private boolean isValidIpAddress(String ipAdd) {
        String IP_ADDRESS_DENIED = "0.0.0.0";
        boolean result2 = true;
        if (ipAdd == null || "".equals(ipAdd) || "0.0.0.0".equals(ipAdd)) {
            result2 = false;
        }
        return result2;
    }

    private void addNtpInput(String ipAddress, boolean serviceActive) {
        if (this.isValidIpAddress(ipAddress)) {
            this.ntpServerInput.add(ipAddress);
            if (serviceActive) {
                this.ntpServerStatusInput.add(Boolean.TRUE);
            } else {
                this.ntpServerStatusInput.add(Boolean.FALSE);
            }
            int idx = this.ntpServerInput.size() - 1;
            logger.traceDebug(THIS_CLASS, " Successfully passing NTP input: ntpServer #" + (idx + 1) + " has serverAddress=" + this.ntpServerInput.get(idx).toString() + " and serviceActive=" + this.ntpServerStatusInput.get(idx).toString() + ". ");
        }
    }

    private void setNtpServerInput() {
        logger.traceEnter(THIS_CLASS, "setNtpServerInput()");
        if (this.ntpServerInput.size() > 0) {
            this.ntpServerInput.clear();
        }
        if (this.managedElementDataData != null) {
            this.addNtpInput(this.managedElementDataData.getNtpServerAddressPrimary(), this.managedElementDataData.getNtpServiceActivePrimary());
            this.addNtpInput(this.managedElementDataData.getNtpServerAddressSecondary(), this.managedElementDataData.getNtpServiceActiveSecondary());
            this.addNtpInput(this.managedElementDataData.getNtpServerAddressThird(), this.managedElementDataData.getNtpServiceActiveThird());
        }
        boolean isActive = false;
        for (int j = 0; j < this.ntpServerStatusInput.size(); ++j) {
            isActive = isActive || (Boolean)this.ntpServerStatusInput.get(j) != false;
        }
        if (!isActive) {
            logger.traceAbnormal(THIS_CLASS, " Failed NtpServers input from ManagedElementData tag: none of the NtpServers is active. ");
        }
        logger.traceReturn(THIS_CLASS, "setNtpServerInput()");
    }

    private void setNtpServerOutput() {
        MoIterator moIter;
        logger.traceEnter(THIS_CLASS, "setNtpServerOutput()");
        if (this.ntpServerOutput.size() > 0) {
            this.ntpServerOutput.clear();
        }
        if ((moIter = this.aMoRepository.lookupType("NtpServer")) != null) {
            while (moIter.hasMoreElements()) {
                this.ntpServerOutput.add(moIter.nextMo());
                logger.traceDebug(THIS_CLASS, " Found NtpServer MO: " + this.ntpServerOutput.get(this.ntpServerOutput.size() - 1).toString());
            }
            if (this.ntpServerOutput.size() > 1) {
                logger.traceAbnormal(THIS_CLASS, " Unexpected: There are more than one NtpServer MOs exist. ");
            }
        } else {
            logger.traceAbnormal(THIS_CLASS, " Unexpected: Default NtpServer=1 MO does not exist. ");
        }
        logger.traceReturn(THIS_CLASS, "setNtpServerOutput()");
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("SiteBasic Fault", "Failed to set attributes or create new NtpServer MO.", exception);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("SiteBasic fault", "Transactional fault while configuring NtpServer MO. ", exception);
    }
}

