/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic;

import java.io.IOException;
import se.ericsson.cello.ipsec.IkePeerMo;
import se.ericsson.cello.ipsec.VpnInterfaceMo;
import se.ericsson.cello.managedelement.ManagedElementDataMo;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoHasChildrenException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.RbsConfigurationSiteBasicHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.AccessControlListData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.GpsOutSyncLinkData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.GpsSyncRefData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.HptsiSyncRefData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IkePeerData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpAccessHostEtData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpInterfaceData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpSecTunnelData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpSyncRefData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.TuSyncRefData;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class SiteBasicConfigurationHelper {
    private static final Class THIS_CLASS = SiteBasicConfigurationHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String SITE_BASIC_FAULT = "Fault when activating Site Basic";
    private static final String DU_1 = "du-1";
    private static final String DU_2 = "du-2";

    private SiteBasicConfigurationHelper() {
    }

    private static void unlockCreatedMo(RbsConfigurationSiteBasicHelper rbsConfigurationLoggerHelper, ManagedObject managedObject, Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "unlockCreatedMo() LDN: " + managedObject.getLocalDistinguishedName());
        rbsConfigurationLoggerHelper.setAttributeWithLogging(managedObject, "administrativeState", RbsConfigurationDefinitions.ADMINISTRATIVE_STATE_UNLOCKED, coordinator);
        logger.traceReturn(THIS_CLASS, "unlockCreatedMo() LDN: " + managedObject.getLocalDistinguishedName());
    }

    protected static String decodeIpSyncRefFromMap(String stringOutPut) {
        logger.traceEnter(THIS_CLASS, "decodeIpSyncRef()");
        int indexOfMinus = stringOutPut.indexOf(45);
        String cutStringOutPut = stringOutPut.substring(indexOfMinus + 1, stringOutPut.length());
        indexOfMinus = stringOutPut.indexOf(45);
        String ipAccessHostEtId = cutStringOutPut.substring(0, indexOfMinus - 1);
        String ipSyncRefId = cutStringOutPut.substring(indexOfMinus, cutStringOutPut.length());
        String ipSyncRefLdn = "ManagedElement=1,IpSystem=1,IpAccessHostEt=" + ipAccessHostEtId + "," + "IpSyncRef" + "=" + ipSyncRefId;
        logger.traceReturn(THIS_CLASS, "decodeIpSyncRef()");
        return ipSyncRefLdn;
    }

    private static ManagedObject getGigabitEthernetMo(MoRepositoryWrapper aMoRepository) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "getGigabitEthernetMo()");
        ManagedObject gigabitEthernet = aMoRepository.lookup("ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,ExchangeTerminalIp=1,GigaBitEthernet=1");
        if (gigabitEthernet == null) {
            String msg = "Could not find the system created MO ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,ExchangeTerminalIp=1,GigaBitEthernet=1";
            throw new RbsConfigurationFailedException(SITE_BASIC_FAULT, "Could not find the system created MO ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,ExchangeTerminalIp=1,GigaBitEthernet=1");
        }
        return gigabitEthernet;
    }

    protected static void createTuSyncRef(RbsConfigurationSiteBasicHelper rbsConfigurationLoggerHelper, TuSyncRefData tuSyncRefData, Coordinator coordinator, MoFactoryMgrWrapper aFactoryMgr, MoRepositoryWrapper aMoRepository) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createTuSyncRef()");
        String timingUnitLdn = null;
        if (tuSyncRefData != null) {
            if (tuSyncRefData.getTuSyncRefSlot().equalsIgnoreCase(DU_1)) {
                timingUnitLdn = "ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,TimingUnit=1";
            } else if (tuSyncRefData.getTuSyncRefSlot().equalsIgnoreCase(DU_2)) {
                timingUnitLdn = "ManagedElement=1,Equipment=1,Subrack=1,Slot=2,PlugInUnit=2,TimingUnit=1";
            }
            ManagedObject timingUnit = aMoRepository.lookup(timingUnitLdn);
            if (timingUnit == null) {
                throw new RbsConfigurationFailedException("TimingUnit MO missing for create of TuSyncRef!");
            }
            AttrListImpl attrList = new AttrListImpl();
            ManagedObject tuSyncRef = rbsConfigurationLoggerHelper.createMoWithLogging(timingUnit, attrList, tuSyncRefData.getTuSyncRefId(), "TuSyncRef", aFactoryMgr, coordinator);
            rbsConfigurationLoggerHelper.setAttributeWithLogging(tuSyncRef, "administrativeState", RbsConfigurationDefinitions.ADMINISTRATIVE_STATE_UNLOCKED, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "createTuSyncRef()");
    }

    protected static void createGpsSyncRef(RbsConfigurationSiteBasicHelper rbsConfigurationLoggerHelper, GpsSyncRefData gpsSyncRefData, Coordinator coordinator, MoFactoryMgrWrapper aFactoryMgr, MoRepositoryWrapper aMoRepository) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createGpsSyncRef()");
        String timingUnitLdn = null;
        if (gpsSyncRefData != null) {
            if (gpsSyncRefData.getGpsSyncRefSlot().equalsIgnoreCase(DU_1)) {
                timingUnitLdn = "ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,TimingUnit=1";
                ManagedObject timingUnit = aMoRepository.lookup(timingUnitLdn);
                if (timingUnit == null) {
                    throw new RbsConfigurationFailedException("TimingUnit MO missing for create of GpsSyncRef!");
                }
                AttrListImpl attrList = new AttrListImpl();
                ManagedObject gpsSyncRef = rbsConfigurationLoggerHelper.createMoWithLogging(timingUnit, attrList, gpsSyncRefData.getGpsSyncRefId(), "GpsSyncRef", aFactoryMgr, coordinator);
                rbsConfigurationLoggerHelper.setAttributeWithLogging(gpsSyncRef, "administrativeState", RbsConfigurationDefinitions.ADMINISTRATIVE_STATE_UNLOCKED, coordinator);
            } else {
                logger.traceError(THIS_CLASS, "createGpsSyncRef() illegal gpsSyncRefSlot:" + gpsSyncRefData.getGpsSyncRefSlot());
            }
        }
        logger.traceReturn(THIS_CLASS, "createGpsSyncRef()");
    }

    protected static void createGpsOutSyncLink(RbsConfigurationSiteBasicHelper rbsConfigurationLoggerHelper, GpsOutSyncLinkData gpsOutSyncLinkData, Coordinator coordinator, MoFactoryMgrWrapper aFactoryMgr, MoRepositoryWrapper aMoRepository) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createGpsOutSyncLink()");
        String timingUnitLdn = null;
        if (gpsOutSyncLinkData != null) {
            timingUnitLdn = "ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,TimingUnit=1";
            ManagedObject timingUnit = aMoRepository.lookup(timingUnitLdn);
            if (timingUnit == null) {
                throw new RbsConfigurationFailedException("TimingUnit MO missing for create of GpsOutSyncLink!");
            }
            AttrListImpl attrList = new AttrListImpl();
            attrList.addElement("administrativeState", (Object)RbsConfigurationDefinitions.ADMINISTRATIVE_STATE_UNLOCKED);
            rbsConfigurationLoggerHelper.createMoWithLogging(timingUnit, attrList, gpsOutSyncLinkData.getGpsOutSyncLinkId(), "GpsOutSyncLink", aFactoryMgr, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "createGpsOutSyncLink()");
    }

    protected static void createHptsiSyncRef(RbsConfigurationSiteBasicHelper rbsConfigurationLoggerHelper, HptsiSyncRefData hptsiSyncRefData, Coordinator coordinator, MoFactoryMgrWrapper aFactoryMgr, MoRepositoryWrapper aMoRepository) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createHptsiSyncRef()");
        String timingUnitLdn = null;
        if (hptsiSyncRefData != null) {
            if (hptsiSyncRefData.getHptsiRefSlot().equalsIgnoreCase(DU_1)) {
                timingUnitLdn = "ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,TimingUnit=1";
                ManagedObject timingUnit = aMoRepository.lookup(timingUnitLdn);
                if (timingUnit == null) {
                    throw new RbsConfigurationFailedException("TimingUnit MO missing for create of HptsiSyncRef!");
                }
                AttrListImpl attrList = new AttrListImpl();
                ManagedObject htpsiSyncRef = rbsConfigurationLoggerHelper.createMoWithLogging(timingUnit, attrList, hptsiSyncRefData.getHptsiSyncRefId(), "HptsiSyncRef", aFactoryMgr, coordinator);
                if (htpsiSyncRef == null) {
                    throw new RbsConfigurationFailedException("Hptsi could not be created");
                }
            } else {
                logger.traceError(THIS_CLASS, "createHptsiSyncRef() illegal hpsiSyncRefSlot:" + hptsiSyncRefData.getHptsiRefSlot());
            }
        }
        logger.traceReturn(THIS_CLASS, "createHptsiSyncRef()");
    }

    protected static void handleIpInterfaceCreation(RbsConfigurationSiteBasicHelper rbsConfigurationLoggerHelper, IpInterfaceData ipInterfaceData, Coordinator coordinator, MoFactoryMgrWrapper aFactoryMgr, MoRepositoryWrapper aMoRepository) throws MoHasChildrenException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "createIpInterface()");
        String ipInterfaceId = ipInterfaceData.getIpInterfaceId();
        String oamIpInterfaceId = "1";
        ManagedObject ipInterfaceMo = SiteBasicConfigurationHelper.getIpInterfaceMo(ipInterfaceData, aMoRepository, "1");
        if (ipInterfaceMo != null && "1".equals(ipInterfaceId)) {
            SiteBasicConfigurationHelper.handleIpInterfaceId1(rbsConfigurationLoggerHelper, ipInterfaceMo, ipInterfaceData, coordinator);
        } else {
            if (ipInterfaceMo != null) {
                throw new RbsConfigurationFailedException("IpInterface with ID = " + ipInterfaceId + " already exists.");
            }
            if (ipInterfaceData != null) {
                SiteBasicConfigurationHelper.createIpInterface(rbsConfigurationLoggerHelper, ipInterfaceData, coordinator, aFactoryMgr, aMoRepository);
            }
        }
        logger.traceReturn(THIS_CLASS, "createIpInterface()");
    }

    private static ManagedObject getIpInterfaceMo(IpInterfaceData ipInterfaceData, MoRepositoryWrapper aMoRepository, String oamIpInterfaceId) {
        String ipInterFaceLdn = null;
        if (oamIpInterfaceId.equals(ipInterfaceData.getIpInterfaceId())) {
            ipInterFaceLdn = "ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,ExchangeTerminalIp=1,GigaBitEthernet=1,IpInterface=1";
        } else if (ipInterfaceData.getIpInterFaceSlot() != null && ipInterfaceData.getIpInterFaceSlot().equalsIgnoreCase(DU_1)) {
            ipInterFaceLdn = "ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,ExchangeTerminalIp=1,GigaBitEthernet=1,IpInterface=" + ipInterfaceData.getIpInterfaceId();
        } else if (ipInterfaceData.getIpInterFaceSlot() != null && ipInterfaceData.getIpInterFaceSlot().equalsIgnoreCase(DU_2)) {
            ipInterFaceLdn = "ManagedElement=1,Equipment=1,Subrack=1,Slot=2,PlugInUnit=2,ExchangeTerminalIp=1,GigaBitEthernet=1,IpInterface=" + ipInterfaceData.getIpInterfaceId();
        }
        return aMoRepository.lookup(ipInterFaceLdn);
    }

    private static void createIpInterface(RbsConfigurationSiteBasicHelper rbsConfigurationLoggerHelper, IpInterfaceData ipInterfaceData, Coordinator coordinator, MoFactoryMgrWrapper aFactoryMgr, MoRepositoryWrapper aMoRepository) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createIpInterface()");
        ManagedObject gigabitEthernetMo = SiteBasicConfigurationHelper.getGigabitEthernetMo(aMoRepository);
        rbsConfigurationLoggerHelper.createMoWithLogging(gigabitEthernetMo, ipInterfaceData.createIpInterFaceAttrList(), ipInterfaceData.getIpInterfaceId(), "IpInterface", aFactoryMgr, coordinator);
        logger.traceReturn(THIS_CLASS, "createIpInterface()");
    }

    private static void handleIpInterfaceId1(RbsConfigurationSiteBasicHelper rbsConfigurationLoggerHelper, ManagedObject ipInterfaceMo, IpInterfaceData ipInterfaceData, Coordinator coordinator) throws MoHasChildrenException, MoAccessException {
        String errorMsg;
        logger.traceEnter(THIS_CLASS, "handleIpInterfaceId1()");
        if (ipInterfaceData.getDefaultRouter0() != null) {
            errorMsg = "Avoiding to set defaultRouter0 on IpInterface vid ID = 1 to: " + ipInterfaceData.getDefaultRouter0() + ". Reason: Risk of losing OaM connection.";
            logger.traceError(THIS_CLASS, errorMsg);
        }
        if (ipInterfaceData.getNetworkPrefixLength() != null) {
            errorMsg = "Avoiding to set networkPrefixLength on IpInterface vid ID = 1 to: " + ipInterfaceData.getNetworkPrefixLength() + ". Reason: Risk of losing OaM connection.";
            logger.traceError(THIS_CLASS, errorMsg);
        }
        if (ipInterfaceData.getVid() != null) {
            errorMsg = "Avoiding to set vid on IpInterface vid ID = 1 to: " + ipInterfaceData.getVid() + ". Reason: Risk of losing OaM connection.";
            logger.traceError(THIS_CLASS, errorMsg);
        }
        if (ipInterfaceData.getIpInterFaceSlot() != null) {
            errorMsg = "Avoiding to set ipInterfaceSlot on IpInterface vid ID=1 to: " + ipInterfaceData.getIpInterFaceSlot() + ". Reason: Risk of losing OaM connection.";
            logger.traceError(THIS_CLASS, errorMsg);
        }
        if (ipInterfaceData.getUserLabel() != null) {
            rbsConfigurationLoggerHelper.setAttributeWithLogging(ipInterfaceMo, "userLabel", ipInterfaceData.getUserLabel(), coordinator);
        }
        logger.traceReturn(THIS_CLASS, "handleIpInterfaceId1()");
    }

    protected static void createIpAccessHostEtAndChildren(RbsConfigurationSiteBasicHelper rbsConfigurationLoggerHelper, IpAccessHostEtData ipAccessHostEtData, Coordinator coordinator, MoFactoryMgrWrapper aFactoryMgr, MoRepositoryWrapper aMoRepository, RbsConfigurationMao rbsConfigurationMao) throws MoHasChildrenException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "createIpAccessHostEtAndChildren()");
        ManagedObject ipSystem = aMoRepository.lookup("ManagedElement=1,IpSystem=1");
        if (ipSystem == null) {
            String msg = "Could not find the system created MO ManagedElement=1,IpSystem=1.";
            throw new RbsConfigurationFailedException("SiteBasic configuration failure", "Could not find the system created MO ManagedElement=1,IpSystem=1.");
        }
        ManagedObject referencedIpInterface = aMoRepository.lookup(ipAccessHostEtData.getIpInterfaceMoRefLdn());
        if (referencedIpInterface == null) {
            String msg = "Incorrect reference for MO:  attribute: ipInterfaceMoRef\nCould not find referenced MO!";
            throw new RbsConfigurationFailedException(SITE_BASIC_FAULT, "Incorrect reference for MO:  attribute: ipInterfaceMoRef\nCould not find referenced MO!");
        }
        ManagedObject ipAccessHostEtMo = rbsConfigurationLoggerHelper.createMoWithLogging(ipSystem, ipAccessHostEtData.createIpAccessHostEtAttrList(referencedIpInterface), ipAccessHostEtData.getIpAccessHostEtId(), "IpAccessHostEt", aFactoryMgr, coordinator);
        SiteBasicConfigurationHelper.unlockCreatedMo(rbsConfigurationLoggerHelper, ipAccessHostEtMo, coordinator);
        IpSyncRefData[] ipSyncRefDataArray = ipAccessHostEtData.getIpSyncRefData();
        for (int i = 0; i < ipSyncRefDataArray.length; ++i) {
            if (ipSyncRefDataArray[i] == null) continue;
            SiteBasicConfigurationHelper.createIpSyncRefMo(rbsConfigurationLoggerHelper, ipSyncRefDataArray[i], ipAccessHostEtMo, coordinator, aFactoryMgr);
        }
        logger.traceReturn(THIS_CLASS, "createIpAccessHostEtAndChildren()");
    }

    private static void createIpSyncRefMo(RbsConfigurationSiteBasicHelper rbsConfigurationLoggerHelper, IpSyncRefData ipSyncRefData, ManagedObject ipAccessHostEtMo, Coordinator coordinator, MoFactoryMgrWrapper aFactoryMgr) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createIpSyncRefMo()");
        ManagedObject ipSyncRefMo = rbsConfigurationLoggerHelper.createMoWithLogging(ipAccessHostEtMo, ipSyncRefData.createIpSyncRefAttrList(), ipSyncRefData.getIpSyncRefId(), "IpSyncRef", aFactoryMgr, coordinator);
        SiteBasicConfigurationHelper.unlockCreatedMo(rbsConfigurationLoggerHelper, ipSyncRefMo, coordinator);
        logger.traceReturn(THIS_CLASS, "createIpSyncRefMo()");
    }

    protected static ManagedElementDataMo findManagedElementDataMo(MoRepositoryWrapper aMoRepository) throws RbsConfigurationFailedException {
        ManagedElementDataMo managedElementData = (ManagedElementDataMo)aMoRepository.lookup("ManagedElement=1,ManagedElementData=1");
        if (managedElementData == null) {
            String slogan = "MO not found";
            String faultMsg = "Could not find the system created MO ManagedElementData.";
            throw new RbsConfigurationFailedException("MO not found", "Could not find the system created MO ManagedElementData.");
        }
        return managedElementData;
    }

    protected static void createAccessControlList(RbsConfigurationSiteBasicHelper rbsConfigurationLoggerHelper, AccessControlListData accessControlListData, Coordinator coordinator, MoRepositoryWrapper aMoRepository, MoFactoryMgrWrapper aFactoryMgr) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "createAccessControlList()");
        ManagedObject ipSystemMo = aMoRepository.lookup("ManagedElement=1,IpSystem=1");
        rbsConfigurationLoggerHelper.createMoWithLogging(ipSystemMo, accessControlListData.createAccessControlListAttrList(), accessControlListData.getAccessControlListId(), "AccessControlList", aFactoryMgr, coordinator);
        logger.traceReturn(THIS_CLASS, "createAccessControlList()");
    }

    protected static void createIkePeer(RbsConfigurationSiteBasicHelper rbsConfigurationLoggerHelper, IkePeerData ikePeerData, MoFactoryMgrWrapper aFactoryMgr, ManagedObject inIpSecMo, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "createIkePeer()");
        IkePeerMo ikePeerMo = (IkePeerMo)rbsConfigurationLoggerHelper.createMoWithLogging(inIpSecMo, ikePeerData.createIkePeerAttrList(), ikePeerData.getIkePeerId(), "IkePeer", aFactoryMgr, coordinator);
        try {
            if (ikePeerData.getPreSharedKeyStruct() != null && ikePeerData.getPreSharedKeyStruct().getValue("encoding") != null && ikePeerData.getPreSharedKeyStruct().getValue("preSharedKey") != null) {
                ikePeerMo.actionInstallPreSharedKey((Struct)ikePeerData.getPreSharedKeyStruct(), coordinator);
                String[] preSharedKeysAttributes = ikePeerData.getPreSharedKeyStruct().getNames();
                Object[] preSharedKeyValues = ikePeerData.getPreSharedKeyStruct().getValues();
                RbsConfigurationReportLoggerFactory.getLogger().logAction("IkePeer", "Install preshared key", preSharedKeysAttributes, preSharedKeyValues);
            }
        }
        catch (MoAccessException mae) {
            String faultMsg = ExceptionHelper.appendReason((String)"Incorrect value for Presharedkey", (Throwable)mae);
            throw new RbsConfigurationFailedException(faultMsg);
        }
        logger.traceReturn(THIS_CLASS, "createIkePeer()");
    }

    protected static void createIpSecTunnel(RbsConfigurationSiteBasicHelper rbsConfigurationLoggerHelper, IpSecTunnelData ipSecTunnelData, MoFactoryMgrWrapper aFactoryMgr, ManagedObject ipSecMo, Coordinator coordinator, MoRepositoryWrapper aMoRepository) throws MoAccessException, IOException {
        logger.traceEnter(THIS_CLASS, "createIpSecTunnel()");
        VpnInterfaceMo referencedVpnInterface = (VpnInterfaceMo)aMoRepository.lookup(ipSecTunnelData.getVpnInterfaceRefLdn());
        ManagedObject referencedIkePeerMo = aMoRepository.lookup(ipSecTunnelData.getIkePeerRefLdn());
        rbsConfigurationLoggerHelper.createMoWithLogging(ipSecMo, ipSecTunnelData.createIpSecTunnelAttrList(referencedIkePeerMo, (ManagedObject)referencedVpnInterface), ipSecTunnelData.getIpSecTunnelId(), "IpSecTunnel", aFactoryMgr, coordinator);
        logger.traceReturn(THIS_CLASS, "createIpSecTunnel()");
    }
}

