/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure;

import java.util.ArrayList;
import java.util.Arrays;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.AclEntriesData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.AttrListHelpers;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class AccessControlListData {
    private static final Class THIS_CLASS = AccessControlListData.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final transient String accessControlListId;
    private transient String userLabel = "";
    private final transient AclEntriesData[] aclEntriesData;

    public AccessControlListData(String inAccessControlListId, String inUserLabel, AclEntriesData[] inAclEntriesData) {
        this.accessControlListId = inAccessControlListId;
        this.userLabel = inUserLabel;
        this.aclEntriesData = inAclEntriesData;
    }

    public AttrListImpl createAccessControlListAttrList() {
        logger.traceEnter(THIS_CLASS, "createAccessControlListAttrList()");
        AttrListImpl attrList = new AttrListImpl();
        ArrayList<AclEntriesData> tmpEntryList = new ArrayList<AclEntriesData>();
        Object[] aclEntriesDataTempArray = this.aclEntriesData;
        tmpEntryList.addAll(Arrays.asList(aclEntriesDataTempArray));
        Arrays.sort(aclEntriesDataTempArray);
        Struct[] aclEntryMoData = new Struct[aclEntriesDataTempArray.length];
        if (aclEntriesDataTempArray != null) {
            for (int i = 0; i < aclEntriesDataTempArray.length; ++i) {
                if (aclEntriesDataTempArray[i] == null) continue;
                StructImpl aclEntry = ((AclEntriesData)aclEntriesDataTempArray[i]).getAclEntry();
                aclEntryMoData[i] = aclEntry;
            }
        }
        if (aclEntriesDataTempArray.length > 0) {
            attrList.addElement("aclEntries", (Object)aclEntryMoData);
        }
        AttrListHelpers.addElementCheckNull("userLabel", this.userLabel, attrList);
        logger.traceReturn(THIS_CLASS, "createAccessControlListAttrList()");
        return attrList;
    }

    public String getAccessControlListId() {
        return this.accessControlListId;
    }

    public String getUserLabel() {
        return this.userLabel;
    }

    public AclEntriesData[] getAclEntriesData() {
        return this.aclEntriesData;
    }
}

