/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.xml.sax.helpers.AttributesImpl;
import se.ericsson.crbs.cat.common.StringHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.ParserHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.xml.XMLElement;

public class FormatData {
    private static final Class THIS_CLASS = FormatData.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private String revision;

    public FormatData(String inRevision) {
        this.setRevision(inRevision);
    }

    public void createRevision(Map typeElementMap) throws IOException {
        logger.traceEnter(THIS_CLASS, "createRevision()");
        String xmlTag = "Format".toLowerCase(Locale.getDefault());
        if (typeElementMap.containsKey(xmlTag)) {
            List elements = (List)typeElementMap.get(xmlTag);
            if (elements.size() > 1) {
                throw new IOException("Invalid XML file: There are more than one element of type Format.");
            }
            if (!elements.isEmpty()) {
                this.setRevision(this.parseFormatData((XMLElement)elements.get(0)));
                ParserHelper.checkMandatoryAttribute((String)"Format.revision", (String)this.getRevision());
            }
        }
        logger.traceReturn(THIS_CLASS, "createRevision()");
    }

    private String parseFormatData(XMLElement xmlElement) {
        logger.traceEnter(THIS_CLASS, "parseFormatData()");
        String localRevision = null;
        AttributesImpl attributes = xmlElement.getAttributes();
        Map attrNameValueMap = ParserHelper.createAttrNameValueMap(attributes);
        localRevision = this.getStringValueEmptyStringToNull(attrNameValueMap, "revision");
        logger.traceReturn(THIS_CLASS, "parseFormatData()");
        return localRevision;
    }

    private String getStringValueEmptyStringToNull(Map attrNameValueMap, String key) {
        String value = StringHelper.emptyStringToNull((String)((String)attrNameValueMap.get(key.toLowerCase(Locale.getDefault()))));
        return value;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String inRevision) {
        this.revision = inRevision;
    }
}

