/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure;

import java.io.IOException;
import java.util.ArrayList;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.ParserHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.AllowedTransformsDataIkePeer;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.AttrListHelpers;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class IkePeerData {
    protected static final String ENABLED = "ENABLED";
    protected static final String DISABLED = "DISABLED";
    protected static final Integer ENABLED_VALUE = new Integer(0);
    protected static final Integer DISABLED_VALUE = new Integer(1);
    private static final Class THIS_CLASS = IkePeerData.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String FQDN = "FQDN";
    private static final String IP_V4_ADDRESS = "IP_V4_ADDRESS";
    private static final String CERTIFICATE = "CERTIFICATE";
    private static final String ANY = "ANY";
    private static final String AUTOMATIC = "AUTOMATIC";
    private transient String authenticationMethod = "CERTIFICATE";
    private transient Integer childSaLifeTimeDataLimit = new Integer(50000);
    private transient Integer childSaLifeTimeInteger = new Integer(1440);
    private transient StructImpl childSaLifeTimeStruct;
    private final transient String ikePeerId;
    private transient Integer ikeSaLifeTime = new Integer(1440);
    private transient Integer logging = DISABLED_VALUE;
    private final transient String peerIdentityIdFqdn;
    private final transient String peerIdentityIdType;
    private final transient String peerIdentityIpv4Address;
    private final transient String ownIdentityIdFqdn;
    private final transient String ownIdentityIdType;
    private final transient String ownIdentityIpv4Address;
    private final transient String peerIpAddress;
    private final transient StructImpl preSharedKeyStruct;
    private transient String userLabel = "";
    private transient StructImpl[] allowedTransforms = null;
    protected static final String GROUP_2 = "GROUP_2";
    protected static final String GROUP_14 = "GROUP_14";
    private final Integer group2 = new Integer(0);
    private final Integer group14 = new Integer(1);
    protected static final String AES_CBC_128 = "AES_CBC_128";
    protected static final String AES_CBC_256 = "AES_CBC_256";
    protected static final String ALG_3DES_CBC = "ALG_3DES_CBC";
    private final Integer aesCbc128 = new Integer(1);
    private final Integer aesCbc256 = new Integer(2);
    private final Integer alg3DesCbc = new Integer(3);
    protected static final String AES_XCBC_MAC_96 = "AES_XCBC_MAC_96";
    protected static final String HMAC_MD5_96 = "HMAC_MD5_96";
    protected static final String HMAC_SHA_1_96 = "HMAC_SHA_1_96";
    private final Integer aesXcbcMac96 = new Integer(0);
    private final Integer hmacMd596 = new Integer(1);
    private final Integer hmacSha196 = new Integer(2);
    protected static final String AES_XCBC_PRF128 = "AES_XCBC_PRF128";
    protected static final String HMAC_SHA1 = "HMAC_SHA1";
    protected static final String HMAC_MD5 = "HMAC_MD5";
    private final Integer aesXcbcPrf128 = new Integer(0);
    private final Integer hmacSha1 = new Integer(1);
    private final Integer hmacMd5 = new Integer(2);
    private final String[] attributes = new String[]{"diffieHellmanGroup", "encryptionAlgorithm", "integrityAlgorithm", "pseudoRandomFunction"};

    public IkePeerData(String inAuthenticationMethod, String inChildSaLifeTimeDataLimit, String inChildSaLifeTime, String inIkePeerId, String inIkeSaLifeTime, String inLogging, String inPeerIdentityIdFqdn, String inPeerIdentityIdType, String inPeerIdentityIpv4Address, String inPeerIpAddress, String inEncoding, String inPreSharedKey, String inUserLabel, AllowedTransformsDataIkePeer[] inAllowedTransformsData, String inOwnIdentityIdFqdn, String inOwnIdentityIdType, String inOwnIdentityIpv4Address) throws IOException, RbsConfigurationFailedException {
        this(inAuthenticationMethod, inChildSaLifeTimeDataLimit, inChildSaLifeTime, inIkePeerId, inIkeSaLifeTime, inLogging, inPeerIdentityIdFqdn, inPeerIdentityIdType, inPeerIdentityIpv4Address, inPeerIpAddress, inEncoding, inPreSharedKey, inUserLabel, inAllowedTransformsData, inOwnIdentityIdFqdn, inOwnIdentityIdType, inOwnIdentityIpv4Address, Boolean.FALSE);
    }

    public IkePeerData(String inAuthenticationMethod, String inChildSaLifeTimeDataLimit, String inChildSaLifeTime, String inIkePeerId, String inIkeSaLifeTime, String inLogging, String inPeerIdentityIdFqdn, String inPeerIdentityIdType, String inPeerIdentityIpv4Address, String inPeerIpAddress, String inEncoding, String inPreSharedKey, String inUserLabel, AllowedTransformsDataIkePeer[] inAllowedTransformsData, String inOwnIdentityIdFqdn, String inOwnIdentityIdType, String inOwnIdentityIpv4Address, boolean inIsTempTunnel) throws IOException, RbsConfigurationFailedException {
        this(inAuthenticationMethod, inChildSaLifeTimeDataLimit, inChildSaLifeTime, inIkePeerId, inIkeSaLifeTime, inLogging, inPeerIdentityIdFqdn, inPeerIdentityIdType, inPeerIdentityIpv4Address, inPeerIpAddress, inEncoding, inPreSharedKey, inUserLabel, inAllowedTransformsData, inOwnIdentityIdFqdn, inOwnIdentityIdType, inOwnIdentityIpv4Address, inIsTempTunnel ? Boolean.TRUE : Boolean.FALSE);
    }

    private IkePeerData(String inAuthenticationMethod, String inChildSaLifeTimeDataLimit, String inChildSaLifeTime, String inIkePeerId, String inIkeSaLifeTime, String inLogging, String inPeerIdentityIdFqdn, String inPeerIdentityIdType, String inPeerIdentityIpv4Address, String inPeerIpAddress, String inEncoding, String inPreSharedKey, String inUserLabel, AllowedTransformsDataIkePeer[] inAllowedTransformsData, String inOwnIdentityIdFqdn, String inOwnIdentityIdType, String inOwnIdentityIpv4Address, Boolean isTempTunnel) throws IOException, RbsConfigurationFailedException {
        if (inAuthenticationMethod != null) {
            this.authenticationMethod = inAuthenticationMethod;
        }
        if (inChildSaLifeTimeDataLimit != null) {
            this.setChildSaLifeTimeDataLimit(ParserHelper.convertIntegerAttribute((String)"childSaLifeTimeDataLimit", (String)inChildSaLifeTimeDataLimit));
        }
        if (inChildSaLifeTime != null) {
            this.setChildSaLifeTimeInteger(ParserHelper.convertIntegerAttribute((String)"childSaLifeTime", (String)inChildSaLifeTime));
        }
        this.setChildSaLifeTimeStruct(this.handleChildSaLifeTime(this.getChildSaLifeTimeDataLimit(), this.getChildSaLifeTimeInteger()));
        this.ikePeerId = inIkePeerId;
        if (inIkeSaLifeTime != null) {
            this.setIkeSaLifeTime(ParserHelper.convertIntegerAttribute((String)"ikeSaLifeTime", (String)inIkeSaLifeTime));
        }
        if (inLogging != null && DISABLED.equalsIgnoreCase(inLogging)) {
            this.setLogging(DISABLED_VALUE);
        } else if (inLogging != null && ENABLED.equalsIgnoreCase(inLogging)) {
            this.setLogging(ENABLED_VALUE);
        }
        this.peerIdentityIdFqdn = inPeerIdentityIdFqdn;
        this.peerIdentityIdType = inPeerIdentityIdType;
        this.peerIdentityIpv4Address = inPeerIdentityIpv4Address;
        this.peerIpAddress = inPeerIpAddress;
        this.ownIdentityIdType = inOwnIdentityIdType;
        this.ownIdentityIdFqdn = inOwnIdentityIdFqdn;
        this.ownIdentityIpv4Address = inOwnIdentityIpv4Address;
        this.preSharedKeyStruct = inPreSharedKey == null || inEncoding == null ? null : this.handlePreSharedKey(inPreSharedKey, inEncoding);
        this.setUserLabel(inUserLabel);
        if (inAllowedTransformsData == null && !isTempTunnel.booleanValue()) {
            this.setAllowedTransforms(this.createDefaultAllowedTransformsData());
        } else if (inAllowedTransformsData == null && isTempTunnel.booleanValue()) {
            this.setAllowedTransforms(this.createDefaultAllowedTransformsDataTempTunnel());
        } else {
            this.setAllowedTransforms(this.createAllowedTransformsData(inAllowedTransformsData));
        }
    }

    private StructImpl handlePreSharedKey(String inPreSharedKey, String inEncoding) {
        logger.traceEnter(THIS_CLASS, "handlePreSharedKey()");
        Integer hex = new Integer(0);
        Integer ascii = new Integer(1);
        Integer encoding = null;
        if (inEncoding == null) {
            encoding = null;
        } else if (inEncoding.equalsIgnoreCase("hex")) {
            encoding = hex;
        } else if (inEncoding.equalsIgnoreCase("ascii")) {
            encoding = ascii;
        }
        String[] preSharedKeysAttributes = new String[]{"encoding", "preSharedKey"};
        Object[] values = new Object[]{encoding, inPreSharedKey};
        StructImpl retStruct = new StructImpl(preSharedKeysAttributes, values);
        logger.traceReturn(THIS_CLASS, "handlePreSharedKey()");
        return retStruct;
    }

    private StructImpl handleChildSaLifeTime(Integer dataLimit, Integer time) {
        logger.traceEnter(THIS_CLASS, "handleChildSaLifeTime()");
        String[] childSaLifeTimeAttributes = new String[2];
        Object[] childSaLifeTimeValues = new Object[2];
        childSaLifeTimeAttributes[0] = "dataLimit";
        childSaLifeTimeAttributes[1] = "time";
        childSaLifeTimeValues[0] = dataLimit;
        childSaLifeTimeValues[1] = time;
        StructImpl returnStruct = new StructImpl(childSaLifeTimeAttributes, childSaLifeTimeValues);
        logger.traceReturn(THIS_CLASS, "handleChildSaLifeTime()");
        return returnStruct;
    }

    private StructImpl[] createAllowedTransformsData(AllowedTransformsDataIkePeer[] inAllowedTransformsData) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createAllowedTransformsData()");
        StructImpl[] allowedTransformsStructArray = new StructImpl[inAllowedTransformsData.length];
        for (int i = 0; i < inAllowedTransformsData.length; ++i) {
            Object[] allowedTransformsValues = new Object[]{this.getDiffieHellmanGroup(inAllowedTransformsData[i]), this.getEncryptionAlgorithm(inAllowedTransformsData[i]), this.getIntegrityAlgorithm(inAllowedTransformsData[i]), this.getPseudoRandomFunction(inAllowedTransformsData[i])};
            allowedTransformsStructArray[i] = new StructImpl(this.attributes, allowedTransformsValues);
        }
        logger.traceReturn(THIS_CLASS, "createAllowedTransformsData()");
        return allowedTransformsStructArray;
    }

    private Object getDiffieHellmanGroup(AllowedTransformsDataIkePeer inAllowedTransformsData) throws RbsConfigurationFailedException {
        Integer diffieHellmanGroup;
        if (GROUP_2.equalsIgnoreCase(inAllowedTransformsData.getDiffieHellmanGroup())) {
            diffieHellmanGroup = this.group2;
        } else if (GROUP_14.equalsIgnoreCase(inAllowedTransformsData.getDiffieHellmanGroup())) {
            diffieHellmanGroup = this.group14;
        } else {
            throw new RbsConfigurationFailedException("Incorrect value for: diffieHellmanGroup should be either GROUP_2 or GROUP_14");
        }
        return diffieHellmanGroup;
    }

    private Object getEncryptionAlgorithm(AllowedTransformsDataIkePeer inAllowedTransformsData) throws RbsConfigurationFailedException {
        Integer encryptionAlgorithm;
        if (AES_CBC_128.equalsIgnoreCase(inAllowedTransformsData.getEncryptionAlgorithm())) {
            encryptionAlgorithm = this.aesCbc128;
        } else if (AES_CBC_256.equalsIgnoreCase(inAllowedTransformsData.getEncryptionAlgorithm())) {
            encryptionAlgorithm = this.aesCbc256;
        } else if (ALG_3DES_CBC.equalsIgnoreCase(inAllowedTransformsData.getEncryptionAlgorithm())) {
            encryptionAlgorithm = this.alg3DesCbc;
        } else {
            throw new RbsConfigurationFailedException("Incorrect value for: encryptionAlgorithm should be either AES_CBC_128, AES_CBC_256 or ALG_3DES_CBC");
        }
        return encryptionAlgorithm;
    }

    private Object getIntegrityAlgorithm(AllowedTransformsDataIkePeer inAllowedTransformsData) throws RbsConfigurationFailedException {
        Integer integrityAlgorithm;
        if (AES_XCBC_MAC_96.equalsIgnoreCase(inAllowedTransformsData.getIntegrityAlgorithm())) {
            integrityAlgorithm = this.aesXcbcMac96;
        } else if (HMAC_MD5_96.equalsIgnoreCase(inAllowedTransformsData.getIntegrityAlgorithm())) {
            integrityAlgorithm = this.hmacMd596;
        } else if (HMAC_SHA_1_96.equalsIgnoreCase(inAllowedTransformsData.getIntegrityAlgorithm())) {
            integrityAlgorithm = this.hmacSha196;
        } else {
            throw new RbsConfigurationFailedException("Incorrect value for: integrityAlgorithm should be either AES_XCBC_MAC_96, HMAC_MD5_96 or HMAC_SHA_1_96");
        }
        return integrityAlgorithm;
    }

    private Object getPseudoRandomFunction(AllowedTransformsDataIkePeer inAllowedTransformsData) throws RbsConfigurationFailedException {
        Integer pseudoRandomFunction;
        if (AES_XCBC_PRF128.equalsIgnoreCase(inAllowedTransformsData.getPseudoRandomFunction())) {
            pseudoRandomFunction = this.aesXcbcPrf128;
        } else if (HMAC_SHA1.equalsIgnoreCase(inAllowedTransformsData.getPseudoRandomFunction())) {
            pseudoRandomFunction = this.hmacSha1;
        } else if (HMAC_MD5.equalsIgnoreCase(inAllowedTransformsData.getPseudoRandomFunction())) {
            pseudoRandomFunction = this.hmacMd5;
        } else {
            throw new RbsConfigurationFailedException("Incorrect value for: pseudoRandomFunction should be either AES_XCBC_PRF128, HMAC_SHA1 or HMAC_MD5");
        }
        return pseudoRandomFunction;
    }

    private StructImpl[] createDefaultAllowedTransformsData() {
        logger.traceEnter(THIS_CLASS, "createDefaultAllowedTransformsData()");
        Object[] values0 = new Object[]{this.group14, this.aesCbc128, this.hmacSha196, this.aesXcbcPrf128};
        Object[] values1 = new Object[]{this.group14, this.aesCbc128, this.hmacMd596, this.aesXcbcPrf128};
        Object[] values2 = new Object[]{this.group14, this.aesCbc256, this.hmacSha196, this.aesXcbcPrf128};
        Object[] values3 = new Object[]{this.group14, this.aesCbc256, this.hmacMd596, this.aesXcbcPrf128};
        Object[] values4 = new Object[]{this.group2, this.aesCbc128, this.hmacSha196, this.aesXcbcPrf128};
        StructImpl[] retAllowedTransforms = new StructImpl[]{new StructImpl(this.attributes, values0), new StructImpl(this.attributes, values1), new StructImpl(this.attributes, values2), new StructImpl(this.attributes, values3), new StructImpl(this.attributes, values4)};
        logger.traceReturn(THIS_CLASS, "createDefaultAllowedTransformsData()");
        return retAllowedTransforms;
    }

    private StructImpl[] createDefaultAllowedTransformsDataTempTunnel() {
        logger.traceEnter(THIS_CLASS, "createDefaultAllowedTransformsDataTempTunnel()");
        Object[] values0 = new Object[]{this.group14, this.aesCbc128, this.hmacSha196, this.aesXcbcPrf128};
        Object[] values1 = new Object[]{this.group14, this.aesCbc128, this.hmacSha196, this.hmacSha1};
        Object[] values2 = new Object[]{this.group14, this.aesCbc256, this.hmacSha196, this.aesXcbcPrf128};
        Object[] values3 = new Object[]{this.group14, this.aesCbc256, this.hmacSha196, this.hmacSha1};
        Object[] values4 = new Object[]{this.group2, this.aesCbc128, this.hmacSha196, this.hmacSha1};
        StructImpl[] retAllowedTransforms = new StructImpl[]{new StructImpl(this.attributes, values0), new StructImpl(this.attributes, values1), new StructImpl(this.attributes, values2), new StructImpl(this.attributes, values3), new StructImpl(this.attributes, values4)};
        logger.traceReturn(THIS_CLASS, "createDefaultAllowedTransformsDataTempTunnel()");
        return retAllowedTransforms;
    }

    private StructImpl createPeerIdentity() {
        String myPeerIdentityIdFqdn;
        logger.traceEnter(THIS_CLASS, "createPeerIdentity()");
        ArrayList<String> structAttributes = new ArrayList<String>();
        ArrayList<Object> structValues = new ArrayList<Object>();
        Integer any = new Integer(0);
        Integer IpV4Address = new Integer(1);
        Integer fqdn = new Integer(2);
        Integer automatic = new Integer(3);
        Integer idType = null;
        if (this.getPeerIdentityIdType().equalsIgnoreCase(ANY)) {
            idType = any;
        } else if (this.getPeerIdentityIdType().equalsIgnoreCase(IP_V4_ADDRESS)) {
            idType = IpV4Address;
        } else if (this.getPeerIdentityIdType().equalsIgnoreCase(FQDN)) {
            idType = fqdn;
        } else if (this.getPeerIdentityIdType().equalsIgnoreCase(AUTOMATIC)) {
            idType = automatic;
        }
        String ipv4Address = "";
        if (this.getPeerIdentityIpv4Address() == null) {
            if (idType == IpV4Address) {
                ipv4Address = this.getPeerIpAddress();
            }
        } else {
            ipv4Address = this.getPeerIdentityIpv4Address();
        }
        if ((myPeerIdentityIdFqdn = this.getPeerIdentityIdFqdn()) == null) {
            myPeerIdentityIdFqdn = "";
        }
        structAttributes.add("idFqdn");
        structAttributes.add("idType");
        structAttributes.add("ipv4Address");
        structValues.add(myPeerIdentityIdFqdn);
        structValues.add(idType);
        structValues.add(ipv4Address);
        String[] structAttributesArray = new String[structAttributes.size()];
        structAttributes.toArray(structAttributesArray);
        Object[] structValuesArray = new Object[structAttributes.size()];
        structValues.toArray(structValuesArray);
        StructImpl peerIdentity = new StructImpl(structAttributesArray, structValuesArray);
        logger.traceReturn(THIS_CLASS, "createPeerIdentity()");
        return peerIdentity;
    }

    private StructImpl createOwnIdentity() {
        logger.traceEnter(THIS_CLASS, "createOwnIdentity()");
        ArrayList<String> structAttributes = new ArrayList<String>();
        ArrayList<Object> structValues = new ArrayList<Object>();
        Integer automatic = new Integer(0);
        Integer IpV4Address = new Integer(1);
        Integer fqdn = new Integer(2);
        Integer automatic_dn = new Integer(3);
        Integer idType = null;
        idType = this.getOwnIdentityIdType() == null ? automatic : (this.getOwnIdentityIdType().equalsIgnoreCase(IP_V4_ADDRESS) ? IpV4Address : (this.getOwnIdentityIdType().equalsIgnoreCase(FQDN) ? fqdn : (this.getOwnIdentityIdType().equalsIgnoreCase("AUTOMATIC_DN") ? automatic_dn : automatic)));
        structAttributes.add("idFqdn");
        structAttributes.add("ownIdType");
        structAttributes.add("ipv4Address");
        String myOwnIdentityIdFqdn = this.getOwnIdentityIdFqdn();
        if (this.getOwnIdentityIdFqdn() == null) {
            myOwnIdentityIdFqdn = "";
        }
        String myOwnIdentityIpv4Address = this.getOwnIdentityIpv4Address();
        if (this.getOwnIdentityIpv4Address() == null) {
            myOwnIdentityIpv4Address = "";
        }
        structValues.add(myOwnIdentityIdFqdn);
        structValues.add(idType);
        structValues.add(myOwnIdentityIpv4Address);
        String[] structAttributesArray = new String[structAttributes.size()];
        structAttributes.toArray(structAttributesArray);
        Object[] structValuesArray = new Object[structAttributes.size()];
        structValues.toArray(structValuesArray);
        StructImpl ownIdentity = new StructImpl(structAttributesArray, structValuesArray);
        logger.traceReturn(THIS_CLASS, "createOwndentity()");
        return ownIdentity;
    }

    public AttrListImpl createIkePeerAttrList() {
        logger.traceEnter(THIS_CLASS, "createIkePeerAttrList()");
        Integer presharedKey = new Integer(0);
        Integer certificate = new Integer(1);
        Integer authenticationMethodIntVal = null;
        if (this.authenticationMethod != null && this.authenticationMethod.equalsIgnoreCase("preSharedKey")) {
            authenticationMethodIntVal = presharedKey;
        } else if (this.authenticationMethod != null && this.authenticationMethod.equalsIgnoreCase(CERTIFICATE)) {
            authenticationMethodIntVal = certificate;
        }
        StructImpl peerIdentity = this.createPeerIdentity();
        StructImpl ownIdentity = this.createOwnIdentity();
        AttrListImpl attrList = new AttrListImpl();
        AttrListHelpers.addElementCheckNull("authenticationMethod", authenticationMethodIntVal, attrList);
        AttrListHelpers.addElementCheckNull("childSaLifeTime", this.getChildSaLifeTimeStruct(), attrList);
        AttrListHelpers.addElementCheckNull("ikeSaLifeTime", this.getIkeSaLifeTime(), attrList);
        AttrListHelpers.addElementCheckNull("logging", this.getLogging(), attrList);
        AttrListHelpers.addElementCheckNull("ownIdentity", ownIdentity, attrList);
        AttrListHelpers.addElementCheckNull("peerIdentity", peerIdentity, attrList);
        AttrListHelpers.addElementCheckNull("peerIpAddress", this.getPeerIpAddress(), attrList);
        AttrListHelpers.addElementCheckNull("userLabel", this.getUserLabel(), attrList);
        AttrListHelpers.addElementCheckNull("allowedTransforms", this.getAllowedTransforms(), attrList);
        logger.traceReturn(THIS_CLASS, "createIkePeerAttrList()");
        return attrList;
    }

    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(String authenticationMethodIn) {
        this.authenticationMethod = authenticationMethodIn;
    }

    public Integer getChildSaLifeTimeDataLimit() {
        return this.childSaLifeTimeDataLimit;
    }

    public void setChildSaLifeTimeDataLimit(Integer childSaLifeTimeDataLimitIn) {
        this.childSaLifeTimeDataLimit = childSaLifeTimeDataLimitIn;
    }

    public Integer getChildSaLifeTimeInteger() {
        return this.childSaLifeTimeInteger;
    }

    public void setChildSaLifeTimeInteger(Integer childSaLifeTimeIntegerIn) {
        this.childSaLifeTimeInteger = childSaLifeTimeIntegerIn;
    }

    public StructImpl getChildSaLifeTimeStruct() {
        return this.childSaLifeTimeStruct;
    }

    public void setChildSaLifeTimeStruct(StructImpl childSaLifeTimeStructIn) {
        this.childSaLifeTimeStruct = childSaLifeTimeStructIn;
    }

    public String getIkePeerId() {
        return this.ikePeerId;
    }

    public Integer getIkeSaLifeTime() {
        return this.ikeSaLifeTime;
    }

    public void setIkeSaLifeTime(Integer ikeSaLifeTimeIn) {
        this.ikeSaLifeTime = ikeSaLifeTimeIn;
    }

    public Integer getLogging() {
        return this.logging;
    }

    public void setLogging(Integer loggingIn) {
        this.logging = loggingIn;
    }

    public String getPeerIdentityIdFqdn() {
        return this.peerIdentityIdFqdn;
    }

    public String getPeerIdentityIdType() {
        return this.peerIdentityIdType;
    }

    public String getPeerIdentityIpv4Address() {
        return this.peerIdentityIpv4Address;
    }

    public String getOwnIdentityIdFqdn() {
        return this.ownIdentityIdFqdn;
    }

    public String getOwnIdentityIdType() {
        return this.ownIdentityIdType;
    }

    public String getOwnIdentityIpv4Address() {
        return this.ownIdentityIpv4Address;
    }

    public String getPeerIpAddress() {
        return this.peerIpAddress;
    }

    public StructImpl getPreSharedKeyStruct() {
        return this.preSharedKeyStruct;
    }

    public String getUserLabel() {
        return this.userLabel;
    }

    public void setUserLabel(String userLabelIn) {
        this.userLabel = userLabelIn;
    }

    public StructImpl[] getAllowedTransforms() {
        return this.allowedTransforms;
    }

    public void setAllowedTransforms(StructImpl[] allowedTransformsIn) {
        this.allowedTransforms = allowedTransformsIn;
    }
}

