/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure;

import java.io.IOException;
import java.util.Locale;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.AttrListHelpers;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpSyncRefData;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class IpAccessHostEtData {
    private static final Class THIS_CLASS = IpAccessHostEtData.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected static final String DU_1 = "du-1";
    protected static final String DU_2 = "du-2";
    protected static final String VPN = "vpn";
    protected static final String IPV6 = "ipv6";
    private final transient String ipAccessHostEtId;
    private final transient String ipAddress;
    private final transient String ipInterfaceMoRefLdn;
    private final transient String userLabel;
    private final transient IpSyncRefData[] ipSyncRefData;

    public IpAccessHostEtData(String inIpAccessHostEtId, String inIpAddress, String inIpInterfaceMoRef, String inUserLabel, IpSyncRefData[] inIpSyncRefData) throws IOException {
        this.ipAccessHostEtId = inIpAccessHostEtId;
        this.ipAddress = inIpAddress;
        this.ipInterfaceMoRefLdn = IpAccessHostEtData.convertIpInterfaceRefToLdn(inIpInterfaceMoRef);
        this.userLabel = inUserLabel;
        this.ipSyncRefData = inIpSyncRefData;
    }

    protected static String convertIpInterfaceRefToLdn(String inIpInterfaceMoRef) throws IOException {
        String convertedRef;
        block7: {
            logger.traceEnter(THIS_CLASS, "convertIpInterfaceRefToLdn()");
            convertedRef = null;
            String ipInterfaceId = null;
            String vpnInterFaceId = null;
            String ipv6InterfaceId = null;
            if (inIpInterfaceMoRef != null) {
                try {
                    String refInLowerCase = inIpInterfaceMoRef.toLowerCase(Locale.getDefault());
                    if (refInLowerCase.startsWith(DU_1)) {
                        ipInterfaceId = inIpInterfaceMoRef.substring(8, inIpInterfaceMoRef.length());
                        convertedRef = "ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,ExchangeTerminalIp=1,GigaBitEthernet=1,IpInterface=" + ipInterfaceId;
                        break block7;
                    }
                    if (refInLowerCase.startsWith(DU_2)) {
                        ipInterfaceId = inIpInterfaceMoRef.substring(8, inIpInterfaceMoRef.length());
                        convertedRef = "ManagedElement=1,Equipment=1,Subrack=1,Slot=2,PlugInUnit=2,ExchangeTerminalIp=1,GigaBitEthernet=1,IpInterface=" + ipInterfaceId;
                        break block7;
                    }
                    if (refInLowerCase.startsWith(VPN)) {
                        vpnInterFaceId = inIpInterfaceMoRef.substring(4, inIpInterfaceMoRef.length());
                        convertedRef = "ManagedElement=1,IpSystem=1,VpnInterface=" + vpnInterFaceId;
                        break block7;
                    }
                    if (refInLowerCase.startsWith(IPV6)) {
                        ipv6InterfaceId = inIpInterfaceMoRef.substring(5, inIpInterfaceMoRef.length());
                        convertedRef = "ManagedElement=1,IpSystem=1,Ipv6Interface=" + ipv6InterfaceId;
                        break block7;
                    }
                    throw new IOException("Input for ipInterfaceMoRef must start with either DU-1, DU-2, VPN or IPv6");
                }
                catch (StringIndexOutOfBoundsException siobe) {
                    throw new IOException("Invalid input for ipInterfaceMoRef. Make sure input is in one of these formats: DU-1-IP-1, IPv6-1 or VPN-1. Error caught: " + siobe.getMessage());
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "convertIpInterfaceRefToLdn()");
        return convertedRef;
    }

    public AttrListImpl createIpAccessHostEtAttrList(ManagedObject referencedIpInterface) {
        logger.traceEnter(THIS_CLASS, "createIpAccessHostEtAttrList()");
        AttrListImpl attrList = new AttrListImpl();
        AttrListHelpers.addElementCheckNull("ipAddress", this.getIpAddress(), attrList);
        AttrListHelpers.addElementCheckNull("userLabel", this.getUserLabel(), attrList);
        AttrListHelpers.addElementCheckNull("ipInterfaceMoRef", referencedIpInterface, attrList);
        logger.traceReturn(THIS_CLASS, "createIpAccessHostEtAttrList()");
        return attrList;
    }

    public String getIpAccessHostEtId() {
        return this.ipAccessHostEtId;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getIpInterfaceMoRefLdn() {
        return this.ipInterfaceMoRefLdn;
    }

    public String getUserLabel() {
        return this.userLabel;
    }

    public IpSyncRefData[] getIpSyncRefData() {
        return this.ipSyncRefData;
    }
}

