/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure;

import java.io.IOException;
import se.ericsson.cello.ipsec.VpnInterfaceMo;
import se.ericsson.cello.iptransport.IpInterfaceMo;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.common.StringHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpAccessHostEtData;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class IpHostLinkData {
    private final transient String ipAddress;
    private final transient String ipHostLinkId;
    private final transient String ipInterfaceLdn;
    private final transient String ipInterfaceMoRef;
    private final transient String userLabel;
    private static final Class THIS_CLASS = IpHostLinkData.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public IpHostLinkData(String inIpHostLinkId, String inIpAddress, String inIpInterfaceMoRef, String inUserLabel) throws IOException {
        this.ipHostLinkId = inIpHostLinkId;
        this.ipAddress = inIpAddress;
        this.ipInterfaceMoRef = inIpInterfaceMoRef;
        this.ipInterfaceLdn = IpAccessHostEtData.convertIpInterfaceRefToLdn(this.getIpInterfaceMoRef());
        this.userLabel = StringHelper.emptyStringToDefault((String)inUserLabel, (String)"");
    }

    public AttrList getAttrList(MoRepositoryWrapper moRepositoryWrapper, Coordinator coordinator) throws RbsConfigurationFailedException {
        AttrListImpl attrList = new AttrListImpl();
        ManagedObject ipInterface = moRepositoryWrapper.lookup(this.getIpInterfaceLdn());
        if (ipInterface == null) {
            logger.traceDebug(THIS_CLASS, "Unable to find " + this.getIpInterfaceLdn() + " needed for creation of IpHostLink=" + this.getIpHostLinkId());
            throw new RbsConfigurationFailedException("Incorrect SiteBasic XML, unable to find IpInterface " + this.getIpInterfaceMoRef() + " for IpHostLink=" + this.getIpHostLinkId());
        }
        attrList.addElement("ipInterfaceMoRef", (Object)ipInterface);
        boolean autoConf = false;
        if (ipInterface instanceof VpnInterfaceMo || ipInterface instanceof IpInterfaceMo) {
            Integer confMode;
            String interfaceType = null;
            try {
                if (ipInterface instanceof VpnInterfaceMo) {
                    interfaceType = "VpnInterface";
                    confMode = new Integer(((VpnInterfaceMo)ipInterface).getConfigurationMode(coordinator));
                } else {
                    interfaceType = "IpInterface";
                    confMode = new Integer(((IpInterfaceMo)ipInterface).getConfigurationMode(coordinator));
                }
            }
            catch (MoAccessException e) {
                throw new RbsConfigurationFailedException("Unable to get configuration mode from " + interfaceType + " " + e.getMessage());
            }
            boolean bl = autoConf = confMode != null && (confMode.equals(RbsConfigurationDefinitions.VPN_INTERFACE_CONF_MODE_IKE) || confMode.equals(RbsConfigurationDefinitions.IP_INTERFACE_CONFIGURATION_MODE_DHCP));
        }
        if (!autoConf && this.ipAddress.indexOf(":") != -1) {
            String[] ipAddressAttributes = new String[]{"ipAddress", "prefixLength"};
            Object[] ipAddressValues = new Object[]{this.ipAddress, RbsConfigurationDefinitions.IPV6_INTERFACE_DEFAULT_PREFIX_LENGTH};
            StructImpl ipAddressStruct = new StructImpl(ipAddressAttributes, ipAddressValues);
            Struct[] ipv6Addresses = new Struct[]{ipAddressStruct};
            attrList.addElement("ipv6Addresses", (Object)ipv6Addresses);
        } else if (!autoConf) {
            String[] ipv4Addresses = new String[]{this.ipAddress};
            attrList.addElement("ipv4Addresses", (Object)ipv4Addresses);
        }
        attrList.addElement("userLabel", (Object)this.getUserLabel());
        return attrList;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getIpHostLinkId() {
        return this.ipHostLinkId;
    }

    public String getIpInterfaceLdn() {
        return this.ipInterfaceLdn;
    }

    public String getIpInterfaceMoRef() {
        return this.ipInterfaceMoRef;
    }

    public String getUserLabel() {
        return this.userLabel;
    }
}

