/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure;

import java.io.IOException;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.AttrListHelpers;
import se.ericsson.crbs.common.ParserHelper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class Ipv6InterfaceData {
    private final String ethernetRef;
    private final String ipv6InterfaceId;
    private final Integer mtu;
    private Integer vid = new Integer(1);
    private Boolean vLan = Boolean.FALSE;
    private String userLabel = "";

    public Ipv6InterfaceData(String inEthernetRef, String inIpv6InterfaceId, String inMtu, String inVid, String inVLan, String inUserLabel) throws IOException {
        this.ethernetRef = inEthernetRef;
        this.ipv6InterfaceId = inIpv6InterfaceId;
        this.mtu = ParserHelper.convertIntegerAttribute((String)inMtu);
        this.vid = ParserHelper.convertIntegerAttribute((String)inVid);
        this.vLan = ParserHelper.convertOptionBoolean((String)"vLan", (String)inVLan);
        this.userLabel = inUserLabel;
    }

    public AttrListImpl createIpv6InterfaceAttrList(MoRepositoryWrapper aMoRepository) {
        AttrListImpl attrList = new AttrListImpl();
        AttrListHelpers.addElementCheckNull("mtu", this.mtu, attrList);
        AttrListHelpers.addElementCheckNull("vid", this.vid, attrList);
        AttrListHelpers.addElementCheckNull("vLan", this.vLan, attrList);
        AttrListHelpers.addElementCheckNull("userLabel", this.userLabel, attrList);
        if (this.ethernetRef != null && this.ethernetRef.equals("DU-2")) {
            ManagedObject gigabitEthernet = aMoRepository.lookup("ManagedElement=1,Equipment=1,Subrack=1,Slot=2,PlugInUnit=2,ExchangeTerminalIp=1,GigaBitEthernet=1");
            AttrListHelpers.addElementCheckNull("ethernetRef", gigabitEthernet, attrList);
        } else {
            ManagedObject gigabitEthernet = aMoRepository.lookup("ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,ExchangeTerminalIp=1,GigaBitEthernet=1");
            AttrListHelpers.addElementCheckNull("ethernetRef", gigabitEthernet, attrList);
        }
        return attrList;
    }

    public String getEthernetRef() {
        return this.ethernetRef;
    }

    public String getIpv6InterfaceId() {
        return this.ipv6InterfaceId;
    }

    public Integer getMtu() {
        return this.mtu;
    }

    public Integer getVid() {
        return this.vid;
    }

    public void setVid(Integer vidIn) {
        this.vid = vidIn;
    }

    public Boolean getvLan() {
        return this.vLan;
    }

    public void setvLan(Boolean vLanIn) {
        this.vLan = vLanIn;
    }

    public String getUserLabel() {
        return this.userLabel;
    }

    public void setUserLabel(String userLabelIn) {
        this.userLabel = userLabelIn;
    }
}

