/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import se.ericsson.cello.equipment.intma.PiuTypeAccess;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoHasChildrenException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.swmanagement.SwAllocationMo;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.AbstractRbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationContext;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationUnlockHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.PiuTypeFinder;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.PlugInUnitFinder;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class AuxHelper
extends AbstractRbsConfigurationHelper {
    private static final Class THIS_CLASS = AuxHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private SwAllocationMo ruSwa;
    protected PiuTypeAccess ruPiuType;
    protected PiuTypeAccess rruPiuType;
    protected PiuTypeAccess iruPiuType;
    protected PiuTypeAccess rdPiuType;
    protected PiuTypeAccess xmuPiuType;
    protected PiuTypeAccess xmu03PiuType;
    private MoRepositoryWrapper aMoRepository;
    private MoFactoryMgrWrapper aFactoryMgr;
    protected ManagedObject equipmentMo = null;
    private int swAllocAndRepsConfigured = -1;

    protected void init(GenericMaoContext aGenericMaoContext, RbsConfigurationMao aRbsConfiguration, RbsConfigurationContext aRbsConfigurationContext) {
        super.init(aGenericMaoContext, aRbsConfiguration, aRbsConfigurationContext);
        this.aMoRepository = this.genericMaoContext.getMoRepositoryWrapper();
        this.aFactoryMgr = this.genericMaoContext.getMoFactoryMgrWrapper();
    }

    public void createAuxPlugInUnit(String identity, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "createAuxPlugInUnit()");
        this.configureSwAllocationAndRepertoires(coordinator);
        if (identity.startsWith("RRU")) {
            this.createRru(identity, coordinator);
        } else if (identity.startsWith("IRU")) {
            this.createIru(identity, coordinator);
        } else if (identity.startsWith("RD")) {
            this.createRd(identity, coordinator);
        } else if (identity.startsWith("RU")) {
            this.createRu(identity, coordinator);
        } else if (identity.startsWith("XMU03")) {
            this.createXmu03(identity, coordinator);
        } else if (identity.startsWith("XMU")) {
            this.createXmu(identity, coordinator);
        } else {
            String errorMessage = "Can not create AuxPlugInUnit with id " + identity + ". Unknown type.";
            ((RbsConfigurationHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationHelper.class)).setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, "Site Equipment failure", errorMessage);
            throw new RbsConfigurationFailedException(errorMessage);
        }
        logger.traceReturn(THIS_CLASS, "createAuxPlugInUnit()");
    }

    private void createRu(String identity, Coordinator coordinator) throws RbsConfigurationFailedException, MoAccessException, MoHasChildrenException {
        ManagedObject rbsSlot = this.getRbsSlot(identity, coordinator);
        ManagedObject auxpiu = this.createAuxPlugInUnit(rbsSlot, this.ruPiuType, identity, coordinator);
        this.ruSwa.actionAddSlot(auxpiu, coordinator);
    }

    private void createXmu(String identity, Coordinator coordinator) throws RbsConfigurationFailedException, MoAccessException, MoHasChildrenException {
        ManagedObject rbsSlot = this.getRbsSlot(identity, coordinator);
        ManagedObject auxpiu = this.createAuxPlugInUnit(rbsSlot, this.xmuPiuType, identity, coordinator);
        this.ruSwa.actionAddSlot(auxpiu, coordinator);
    }

    private void createXmu03(String identity, Coordinator coordinator) throws RbsConfigurationFailedException, MoAccessException, MoHasChildrenException {
        ManagedObject auxpiu = null;
        StringTokenizer stringTokenizer = new StringTokenizer(identity, "-");
        int noOfTokens = stringTokenizer.countTokens();
        if (noOfTokens == 3) {
            ManagedObject rbsSlot = this.getRbsSlot(identity, coordinator);
            auxpiu = this.createAuxPlugInUnit(rbsSlot, this.xmu03PiuType, identity, coordinator);
        } else if (noOfTokens == 2) {
            if (this.equipmentMo == null) {
                this.findEquipment();
            }
            auxpiu = this.createAuxPlugInUnit(this.equipmentMo, this.xmu03PiuType, identity, coordinator);
        } else {
            String errorMessage = "Cannot create AuxPlugInUnit with id " + identity + ". Incorrect id for XMU03.";
            ((RbsConfigurationHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationHelper.class)).setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, "Site Equipment failure", errorMessage);
            throw new RbsConfigurationFailedException(errorMessage);
        }
        this.ruSwa.actionAddSlot(auxpiu, coordinator);
    }

    private ManagedObject getRbsSlot(String identity, Coordinator coordinator) throws RbsConfigurationFailedException, MoAccessException, MoHasChildrenException {
        int firstSeparator = identity.indexOf(45);
        int secondSeparator = identity.indexOf(45, firstSeparator + 1);
        int thirdSeparator = identity.indexOf(45, secondSeparator + 1);
        String rbsSubrackId = null;
        String rbsSlotId = null;
        try {
            rbsSubrackId = identity.substring(firstSeparator + 1, secondSeparator);
            rbsSlotId = thirdSeparator == -1 ? identity.substring(secondSeparator + 1) : identity.substring(secondSeparator + 1, thirdSeparator);
        }
        catch (IndexOutOfBoundsException iobe) {
            throw new RbsConfigurationFailedException("MO create failed", "Incorrect unitId: " + identity);
        }
        this.findOrCreateRbsSubrack(rbsSubrackId, coordinator);
        ManagedObject rbsSlot = this.findRbsSlot(rbsSubrackId, rbsSlotId);
        MoIterator rbsSlotChildren = rbsSlot.getChildren();
        if (rbsSlotChildren != null && rbsSlotChildren.size() > 0) {
            this.deleteMoChildren(rbsSlot, coordinator);
        }
        return rbsSlot;
    }

    private void createRru(String identity, Coordinator coordinator) throws RbsConfigurationFailedException, MoAccessException {
        ManagedObject auxpiu = this.aMoRepository.lookup("ManagedElement=1,Equipment=1,AuxPlugInUnit=" + identity);
        if (auxpiu == null) {
            if (this.equipmentMo == null) {
                this.findEquipment();
            }
            auxpiu = this.createAuxPlugInUnit(this.equipmentMo, this.rruPiuType, identity, coordinator);
            this.ruSwa.actionAddSlot(auxpiu, coordinator);
        }
    }

    private void createIru(String identity, Coordinator coordinator) throws RbsConfigurationFailedException, MoAccessException {
        ManagedObject rbsSlot = this.getRbsSlot(identity, coordinator);
        ManagedObject auxpiu = this.createAuxPlugInUnit(rbsSlot, this.iruPiuType, identity, coordinator);
        this.ruSwa.actionAddSlot(auxpiu, coordinator);
    }

    private void createRd(String identity, Coordinator coordinator) throws RbsConfigurationFailedException, MoAccessException {
        ManagedObject auxpiu = this.aMoRepository.lookup("ManagedElement=1,Equipment=1,AuxPlugInUnit=" + identity);
        if (auxpiu == null) {
            if (this.equipmentMo == null) {
                this.findEquipment();
            }
            auxpiu = this.createAuxPlugInUnit(this.equipmentMo, this.rdPiuType, identity, coordinator);
        }
    }

    private void configureSwAllocationAndRepertoires(Coordinator coordinator) throws MoAccessException {
        if (this.swAllocAndRepsConfigured != coordinator.getTransactionID()) {
            this.ruSwa = this.findOrCreateSwAllocationMo(coordinator);
            this.ruPiuType = PiuTypeFinder.findPiuType("RU", this.aMoRepository, coordinator);
            if (this.ruPiuType == null) {
                throw new MoNotFoundException("No PiuType for RadioUnits found!");
            }
            this.rruPiuType = PiuTypeFinder.findPiuType("RRU", this.aMoRepository, coordinator);
            if (this.rruPiuType == null) {
                throw new MoNotFoundException("No PiuType for RemoteRadioUnits found!");
            }
            this.iruPiuType = PiuTypeFinder.findPiuType("IRU", this.aMoRepository, coordinator);
            if (this.iruPiuType == null) {
                throw new MoNotFoundException("No PiuType for IndoorRadioUnits found!");
            }
            this.rdPiuType = PiuTypeFinder.findPiuType("RD", this.aMoRepository, coordinator);
            if (this.rdPiuType == null) {
                throw new MoNotFoundException("No PiuType for RadioDotUnits found!");
            }
            this.xmuPiuType = PiuTypeFinder.findPiuType("XMU", this.aMoRepository, coordinator);
            if (this.xmuPiuType == null) {
                throw new MoNotFoundException("No PiuType for XMU found!");
            }
            this.xmu03PiuType = PiuTypeFinder.findPiuType("XMU03", this.aMoRepository, coordinator);
            if (this.xmu03PiuType == null) {
                throw new MoNotFoundException("No PiuType for XMU03 found!");
            }
            this.addRepertoires(coordinator);
            this.swAllocAndRepsConfigured = coordinator.getTransactionID();
        }
    }

    public void setPluginUnitRef(String positionRef, boolean isMultiCabConf, String plugInUnitId, Coordinator coordinator) throws MoAccessException {
        ManagedObject cabinetMo;
        MoIterator cabinetIter;
        logger.traceEnter(THIS_CLASS, "setPluginUnitRef()");
        ManagedObject auxPlugInUnit = PlugInUnitFinder.findPlugInUnit(plugInUnitId, this.aMoRepository);
        if (auxPlugInUnit != null && isMultiCabConf) {
            if (positionRef == null) {
                throw new IllegalArgumentException("positionRef for multicabinet configuration cannot be empty");
            }
            cabinetIter = this.aMoRepository.lookupType("Cabinet");
            while (cabinetIter != null & cabinetIter.hasMoreElements()) {
                cabinetMo = cabinetIter.nextMo();
                if (cabinetMo == null) continue;
                String cabinetId = this.getMoId(cabinetMo.getFullDistinguishedName(), "Cabinet");
                String positionRefCabId = this.getMoId(positionRef, "Cabinet");
                if (!positionRefCabId.equals(cabinetId)) continue;
                auxPlugInUnit.setAttribute("positionRef", (Object)cabinetMo, coordinator);
            }
        }
        if (!isMultiCabConf) {
            cabinetIter = this.aMoRepository.lookupType("Cabinet");
            while (cabinetIter != null & cabinetIter.hasMoreElements()) {
                cabinetMo = cabinetIter.nextMo();
                if (cabinetMo == null) continue;
                auxPlugInUnit.setAttribute("positionRef", (Object)cabinetMo, coordinator);
                break;
            }
        }
        logger.traceReturn(THIS_CLASS, "setPluginUnitRef()");
    }

    public void setRdPositionInformation(String positionInformation, String auxPlugInUnitId, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setRdPositionInformation()");
        ManagedObject auxPlugInUnit = PlugInUnitFinder.findPlugInUnit(auxPlugInUnitId, this.aMoRepository);
        auxPlugInUnit.setAttribute("positionInformation", (Object)positionInformation, coordinator);
        logger.traceReturn(THIS_CLASS, "setRdPositionInformation()");
    }

    public void setRdPositionCoordinates(Struct positionCoordinatesStruct, String auxPlugInUnitId, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setRdPositionCoordinates()");
        ManagedObject auxPlugInUnit = PlugInUnitFinder.findPlugInUnit(auxPlugInUnitId, this.aMoRepository);
        auxPlugInUnit.setAttribute("positionCoordinates", (Object)positionCoordinatesStruct, coordinator);
        logger.traceReturn(THIS_CLASS, "setRdPositionCoordinates()");
    }

    private String getMoId(String ldn, String attrib) {
        int idPosition = ldn.indexOf(attrib) + attrib.length() + 1;
        String temp = ldn.substring(idPosition);
        if (temp.indexOf(",") < 0) {
            return ldn.substring(idPosition, ldn.length());
        }
        return ldn.substring(idPosition, temp.indexOf(","));
    }

    private void deleteMoChildren(ManagedObject currentMo, Coordinator coordinator) throws MoHasChildrenException, MoAccessException {
        while (currentMo.getChildren() != null && currentMo.getChildren().hasMoreElements()) {
            ManagedObject child = currentMo.getChildren().nextMo();
            this.deleteMoChildren(child, coordinator);
            try {
                ManagedObject[] reservedBy = (ManagedObject[])child.getAttribute("reservedBy", coordinator);
                this.deleteBasedOnReservedBy(coordinator, child, reservedBy);
            }
            catch (NoSuchAttributeException nsae) {
                logger.traceDebug(THIS_CLASS, "MO, " + child.toString() + ", does not have the reservedBy attribute. Message: " + nsae.toString());
            }
            child.delete(coordinator);
        }
    }

    private void deleteBasedOnReservedBy(Coordinator coordinator, ManagedObject child, ManagedObject[] reservedBy) throws MoAccessException {
        if (reservedBy != null && reservedBy.length > 0) {
            for (int i = 0; i < reservedBy.length; ++i) {
                if (child.getType().equals("RiPort")) {
                    reservedBy[i].setAttribute("remoteRiPortRef", null, coordinator);
                    continue;
                }
                if (child.getType().equals("RdiPort")) {
                    reservedBy[i].setAttribute("rdiPortRef", null, coordinator);
                    continue;
                }
                if (child.getType().equals("RfPort")) {
                    reservedBy[i].setAttribute("rfPortRef", null, coordinator);
                    continue;
                }
                if (!child.getType().equals("AuxPlugInUnit")) continue;
                ((SwAllocationMo)reservedBy[i]).actionDeleteSlot(child, coordinator);
            }
        }
    }

    private ManagedObject createAuxPlugInUnit(ManagedObject parent, PiuTypeAccess piuType, String identity, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "createAuxPlugInUnit(); parent MO: " + parent.toString() + " , piuType: " + piuType.toString() + " , identity: " + identity);
        MoFactory auxFactory = this.aFactoryMgr.lookup("AuxPlugInUnit");
        if (auxFactory == null) {
            throw new RbsConfigurationFailedException("Could not find the MoFactory for AuxPlugInUnit!");
        }
        AttrListImpl attrList = new AttrListImpl(this.aMoRepository);
        attrList.addElement("piuType", (Object)piuType);
        attrList.addElement("administrativeState", (Object)RbsConfigurationDefinitions.ADMINISTRATIVE_STATE_LOCKED);
        ManagedObject aux = null;
        try {
            aux = auxFactory.createMo(parent, (AttrList)attrList, identity, null, coordinator);
            RbsConfigurationReportLoggerFactory.getLogger().logAction("AuxPlugInUnit", "create", new String[]{"LDN", "piuType"}, new Object[]{aux.getLocalDistinguishedName(), piuType.getRelativeDistinguishedName()});
            try {
                RbsConfigurationUnlockHelper.getInstance().registerCreatedMo(aux, coordinator);
            }
            catch (InactiveTransactionException ite) {
                String msg = "Failed to register created MO for clean up\"" + aux + "\".";
                throw new RbsConfigurationFailedException("Unexpected Inactive transaction.", msg, (Exception)((Object)ite));
            }
        }
        catch (MoNameAlreadyTakenException mnate) {
            logger.traceDebug(THIS_CLASS, "AuxPlugInUnit=" + identity + " does already exist.");
        }
        logger.traceReturn(THIS_CLASS, "createAuxPlugInUnit(); returned MO: " + aux.toString());
        return aux;
    }

    protected void findEquipment() throws RbsConfigurationFailedException {
        this.equipmentMo = this.aMoRepository.lookup("ManagedElement=1,Equipment=1");
        if (this.equipmentMo == null) {
            throw new RbsConfigurationFailedException("The system created MO ManagedElement=1,Equipment=1 can not be found!");
        }
    }

    protected ManagedObject findRbsSlot(String subrackId, String slotId) throws MoAccessException {
        ManagedObject rbsSlot = this.aMoRepository.lookup("ManagedElement=1,Equipment=1,RbsSubrack=" + subrackId + "," + "RbsSlot" + "=" + slotId);
        if (rbsSlot == null) {
            throw new MoNotFoundException("The requested slot " + slotId + " could not be found under the subrack!");
        }
        return rbsSlot;
    }

    protected void findOrCreateRbsSubrack(String identity, Coordinator coordinator) throws MoAccessException {
        ManagedObject rbsSubrack = this.aMoRepository.lookup("ManagedElement=1,Equipment=1,RbsSubrack=" + identity);
        if (rbsSubrack == null) {
            if (this.equipmentMo == null) {
                this.findEquipment();
            }
            AttrListImpl attrList = new AttrListImpl(this.aMoRepository);
            attrList.addElement("subrackPosition", (Object)"");
            attrList.addElement("noOfSlots", (Object)RbsConfigurationDefinitions.RBSSUBRACK_NOOFSLOTS_VALUE);
            MoFactory rbsSubrackFactory = this.aFactoryMgr.lookup("RbsSubrack");
            rbsSubrack = rbsSubrackFactory.createMo(this.equipmentMo, (AttrList)attrList, identity, null, coordinator);
            RbsConfigurationReportLoggerFactory.getLogger().logAction("RbsSubrack=" + identity, "create", "subrackPosition", "");
        }
    }

    protected final SwAllocationMo findOrCreateSwAllocationMo(Coordinator coordinator) throws RbsConfigurationFailedException {
        SwAllocationMo swa = (SwAllocationMo)this.aMoRepository.lookup("ManagedElement=1,SwManagement=1,SwAllocation=RBS_RU");
        if (swa == null) {
            ManagedObject swManagement = this.aMoRepository.lookup("ManagedElement=1,SwManagement=1");
            if (swManagement == null) {
                String msg = "Could not find the system created MO ManagedElement=1,SwManagement=1";
                throw new RbsConfigurationFailedException("Could not find the system created MO ManagedElement=1,SwManagement=1");
            }
            try {
                MoFactory swAllocationMoFactory = this.aFactoryMgr.lookup("SwAllocation");
                if (swAllocationMoFactory == null) {
                    throw new RbsConfigurationFailedException("Unable to lookup MO Factory for SwAllocation");
                }
                AttrListImpl attrList = new AttrListImpl(this.aMoRepository);
                attrList.addElement("role", (Object)"RBS_RU");
                swa = (SwAllocationMo)swAllocationMoFactory.createMo(swManagement, (AttrList)attrList, "RBS_RU", null, coordinator);
                RbsConfigurationReportLoggerFactory.getLogger().logAction("SwAllocation=RBS_RU", "create", "role", "RBS_RU");
            }
            catch (MoAccessException mae) {
                String msg = "Failed to create the MO \"ManagedElement=1,SwManagement=1,SwAllocation=RBS_RU";
                throw new RbsConfigurationFailedException("Failed to create the MO \"ManagedElement=1,SwManagement=1,SwAllocation=RBS_RU Original message: " + mae.getVariablesAsString());
            }
        }
        return swa;
    }

    protected final void addRepertoires(Coordinator coordinator) throws MoAccessException {
        ManagedObject xmuRepertoire;
        ManagedObject iruRepertoire;
        ManagedObject rruRepertoire;
        logger.traceEnter(THIS_CLASS, "addRepertoires()");
        ArrayList<ManagedObject> addedRepertoires = new ArrayList<ManagedObject>();
        ManagedObject ruRepertoire = this.addRepertoire(this.ruPiuType, addedRepertoires, coordinator);
        if (ruRepertoire != null) {
            addedRepertoires.add(ruRepertoire);
        }
        if ((rruRepertoire = this.addRepertoire(this.rruPiuType, addedRepertoires, coordinator)) != null) {
            addedRepertoires.add(rruRepertoire);
        }
        if ((iruRepertoire = this.addRepertoire(this.iruPiuType, addedRepertoires, coordinator)) != null) {
            addedRepertoires.add(iruRepertoire);
        }
        if ((xmuRepertoire = this.addRepertoire(this.xmuPiuType, addedRepertoires, coordinator)) != null) {
            addedRepertoires.add(xmuRepertoire);
        }
        this.addRepertoire(this.xmu03PiuType, addedRepertoires, coordinator);
        logger.traceReturn(THIS_CLASS, "addRepertoires()");
    }

    private ManagedObject addRepertoire(PiuTypeAccess piuType, List addedRepertoires, Coordinator coordinator) throws MoAccessException {
        ManagedObject repertoire = null;
        ManagedObject[] piuTypeReservedBy = this.getReservedBy(piuType, coordinator);
        if (piuTypeReservedBy == null) {
            logger.traceDebug(THIS_CLASS, "Repertoire for " + piuType.toString() + " not found!");
        } else {
            repertoire = this.getRepertoire(piuTypeReservedBy);
            if (repertoire == null) {
                logger.traceDebug(THIS_CLASS, "Repertoire for " + piuType.toString() + " not found!");
            } else if (!addedRepertoires.contains(repertoire)) {
                this.addRepertoireToSwa(this.ruSwa, coordinator, repertoire, piuType);
            }
        }
        return repertoire;
    }

    private ManagedObject[] getReservedBy(PiuTypeAccess piuType, Coordinator coordinator) throws MoAccessException {
        ManagedObject[] reservedBy = (ManagedObject[])piuType.getAttribute("reservedBy", coordinator);
        if (reservedBy == null) {
            String errorMessage = "The PiuType with role " + piuType.getType() + " has not been reserved";
            ((RbsConfigurationHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationHelper.class)).setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, "Site Equipment failure", errorMessage);
        }
        return reservedBy;
    }

    private ManagedObject getRepertoire(ManagedObject[] reservedBy) {
        ManagedObject repertoire = null;
        for (int i = 0; i < reservedBy.length; ++i) {
            if (!"Repertoire".equalsIgnoreCase(reservedBy[i].getType())) continue;
            repertoire = reservedBy[i];
            break;
        }
        return repertoire;
    }

    private void addRepertoireToSwa(SwAllocationMo swa, Coordinator coordinator, ManagedObject repertoire, PiuTypeAccess piuType) throws MoAccessException {
        swa.actionAddRepertoire(repertoire, coordinator);
        RbsConfigurationReportLoggerFactory.getLogger().logAction("SwAllocation", "Add repertoire", new String[]{"SwAllocation", "PiuType", "Repertoire"}, new String[]{swa.getLocalDistinguishedName(), piuType.getLocalDistinguishedName(), repertoire.getLocalDistinguishedName()});
    }

    public String getHelperName() {
        return this.getClass().getName();
    }
}

