/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment;

import se.ericsson.cello.equipment.intma.PiuTypeAccess;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationContext;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ProgressReportHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.ExtendedPlugInUnitHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.PiuTypeFinder;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.PlugInUnitFinder;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.datastructure.DigitalEquipmentData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class CreateExtensionDUs
implements TransactionPackage {
    private static final Class THIS_CLASS = CreateExtensionDUs.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private MoRepositoryWrapper aMoRepository;
    private MoFactoryMgrWrapper aFactoryMgr;
    private final RbsConfigurationContext rbsConfigurationContext;
    private DigitalEquipmentData digitalEquipmentData;

    public CreateExtensionDUs(RbsConfigurationContext inRbsConfigurationContext, DigitalEquipmentData inDigitalEquipmentData) {
        this.rbsConfigurationContext = inRbsConfigurationContext;
        this.aFactoryMgr = this.rbsConfigurationContext.getMoFactoryMgrWrapper();
        this.aMoRepository = this.rbsConfigurationContext.getMoRepositoryWrapper();
        this.digitalEquipmentData = inDigitalEquipmentData;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void createExtendedPlugInUnitForIDL2(String identity, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "createExtendedPlugInUnitForIDL2() identity=" + identity);
        if (identity != null && identity.startsWith("DU")) {
            ManagedObject slot = this.getSlot(identity);
            if (!this.digitalEquipmentData.checkInterPiuLinkToDU1(identity) && !identity.equals("DU-2")) {
                PiuTypeAccess slavePiuType = PiuTypeFinder.findPiuType("SLAVE_DU", this.aMoRepository, coordinator);
                if (slavePiuType == null) {
                    String errMsg = "Cannot get PiuType for extended PlugInUnit, the PiuType is null.";
                    throw new RbsConfigurationFailedException("Cannot get PiuType for extended PlugInUnit, the PiuType is null.");
                }
                this.createExtendedPlugInUnitMo(slot, slavePiuType, identity, coordinator);
            }
        } else {
            String errorMessage = "Can not configure extended plugInUnit with id " + identity + ". Unknown type.";
            throw new RbsConfigurationFailedException(errorMessage);
        }
        logger.traceReturn(THIS_CLASS, "createExtendedPlugInUnitForIDL2()");
    }

    private void createDu3andBiggerPiuForIDL2(Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createDu3andBiggerPiuForIDL2()");
        if (ExtendedPlugInUnitHelper.hasInterPiuLink) {
            try {
                for (int digitalUnitIndex = 0; digitalUnitIndex < this.digitalEquipmentData.getDigitalUnit().length; ++digitalUnitIndex) {
                    if (this.digitalEquipmentData.getDigitalUnit()[digitalUnitIndex].unitId.equals("DU-1") || this.digitalEquipmentData.getDigitalUnit()[digitalUnitIndex].unitId.equals("DU-2")) continue;
                    this.createExtendedPlugInUnitForIDL2(this.digitalEquipmentData.getDigitalUnit()[digitalUnitIndex].unitId, coordinator);
                }
            }
            catch (MoAccessException mae) {
                String slogan = "MO create failed";
                String faultMsg = "Could not create all ExtendedPlugInUnits for IDL2.";
                ProgressReportHandler.getInstance().updateProgressReportInformation(1050, 4, ExceptionHelper.appendReason((String)"Could not create all ExtendedPlugInUnits for IDL2.", (Throwable)mae), true);
                throw new RbsConfigurationFailedException("MO create failed", "Could not create all ExtendedPlugInUnits for IDL2.", (Exception)((Object)mae));
            }
        }
        logger.traceReturn(THIS_CLASS, "createDu3andBiggerPiuForIDL2()");
    }

    public void execute(Coordinator coordinator) throws MoAccessException, InactiveTransactionException {
        this.createDu3andBiggerPiuForIDL2(coordinator);
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "handleExecutionException()");
        logger.traceReturn(THIS_CLASS, "handleExecutionException()");
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "handleTransactionException()");
        logger.traceReturn(THIS_CLASS, "handleTransactionException()");
    }

    private ManagedObject getSlot(String identity) throws RbsConfigurationFailedException, MoAccessException {
        int firstSeparator = identity.indexOf(45);
        String subrackId = "1";
        String slotId = null;
        try {
            slotId = identity.substring(firstSeparator + 1);
        }
        catch (IndexOutOfBoundsException iobe) {
            throw new RbsConfigurationFailedException("MO create failed", "Incorrect unitId: " + identity);
        }
        ManagedObject slot = this.findSlot("1", slotId);
        return slot;
    }

    private ManagedObject findSlot(String subrackId, String slotId) throws MoAccessException {
        ManagedObject slot = this.aMoRepository.lookup("ManagedElement=1,Equipment=1,Subrack=" + subrackId + "," + "Slot" + "=" + slotId);
        if (slot == null) {
            throw new MoNotFoundException("The requested slot " + slotId + " could not be found under the subrack!");
        }
        return slot;
    }

    private void createExtendedPlugInUnitMo(ManagedObject parent, PiuTypeAccess piuType, String identity, Coordinator coordinator) throws MoAccessException {
        ManagedObject piu = null;
        try {
            piu = PlugInUnitFinder.findPlugInUnit(identity, this.aMoRepository);
            String msg = "PlugInUnit MO " + piu.getLocalDistinguishedName() + " already exists, no need to create it agian";
            logger.info(THIS_CLASS, msg);
            return;
        }
        catch (RbsConfigurationFailedException e) {
            String msg = "PlugInUnit MO for " + identity + " does not exist, need to create it.";
            logger.info(THIS_CLASS, msg);
            MoFactory piuFactory = this.aFactoryMgr.lookup("PlugInUnit");
            if (piuFactory == null) {
                throw new RbsConfigurationFailedException("Could not find the MoFactory for PlugInUnit!");
            }
            AttrListImpl attrList = new AttrListImpl(this.aMoRepository);
            attrList.addElement("piuType", (Object)piuType);
            try {
                piu = piuFactory.createMo(parent, (AttrList)attrList, "1", null, coordinator);
                RbsConfigurationReportLoggerFactory.getLogger().logAction("PlugInUnit", "create", new String[]{"LDN", "piuType"}, new Object[]{piu.getLocalDistinguishedName(), piuType.getRelativeDistinguishedName()});
                piu.setAttribute("administrativeState", (Object)RbsConfigurationDefinitions.ADMINISTRATIVE_STATE_UNLOCKED, coordinator);
            }
            catch (MoAccessException moAccessExc) {
                String msg2 = "Failed to create PlugInUnit MO under " + parent;
                throw new RbsConfigurationFailedException("Cannot create MO.", msg2, (Exception)((Object)moAccessExc));
            }
            return;
        }
    }
}

