/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment;

import se.ericsson.cello.equipment.intma.PiuTypeAccess;
import se.ericsson.cello.managedelement.ManagedElementDataMo;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.swmanagement.ConfigurationVersionMo;
import se.ericsson.cello.swmanagement.PiuTypeMo;
import se.ericsson.cello.swmanagement.SwAllocationMo;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.upgradepackage.main.interfaces.InstallRejectReason;
import se.ericsson.cello.upgradepackage.main.interfaces.PiuTypeInstallListener;
import se.ericsson.cello.upgradepackage.main.interfaces.PiuTypeInstallSupport;
import se.ericsson.cello.upgradepackage.main.interfaces.PiuTypeInstallSupportAdaptor;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMo;
import se.ericsson.crbs.cat.mao.rbsconfiguration.AbstractRbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationContext;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationUnlockHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ProgressReportHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.PiuTypeFinder;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.PlugInUnitFinder;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.datastructure.DigitalEquipmentData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.commonmo.transactions.TransactionServicesFactoryImpl;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class ExtendedPlugInUnitHelper
extends AbstractRbsConfigurationHelper
implements TransactionPackage,
PiuTypeInstallListener {
    private static final Class THIS_CLASS = ExtendedPlugInUnitHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private SwAllocationMo duSwa;
    private MoRepositoryWrapper aMoRepository;
    private MoFactoryMgrWrapper aFactoryMgr;
    protected ManagedObject equipmentMo = null;
    private int swAllocAndRepsConfigured = -1;
    private DigitalEquipmentData digitalEquipmentData;
    private RbsConfigurationHelper helper;
    private volatile boolean installPiuTypeConfirmed;
    private static final String MANAGED_ELEMENT_LDN = "ManagedElement=1";
    private static final String CONFIGURATION_VERSION_LDN = "ManagedElement=1,SwManagement=1,ConfigurationVersion=1";
    private PiuTypeInstallSupport installAdaptor;
    private static final int INSTALLED = 2;
    private int MAX_INSTALLPIUTYPE_TRYING = 30;
    private int SLEEP_TIME = 10000;
    public static boolean hasInterPiuLink = false;

    public void setInstallAdaptor(PiuTypeInstallSupport adaptor) {
        this.installAdaptor = adaptor;
    }

    public void setSleepTime(int i) {
        this.SLEEP_TIME = i;
    }

    public void setMaxInstallPIUTypeTrying(int i) {
        this.MAX_INSTALLPIUTYPE_TRYING = i;
    }

    public void setDigitalEquipmentData(DigitalEquipmentData inDigitalEquipmentData) {
        this.digitalEquipmentData = inDigitalEquipmentData;
    }

    protected void init(GenericMaoContext aGenericMaoContext, RbsConfigurationMao aRbsConfiguration, RbsConfigurationContext aRbsConfigurationContext) {
        super.init(aGenericMaoContext, aRbsConfiguration, aRbsConfigurationContext);
        this.aMoRepository = this.genericMaoContext.getMoRepositoryWrapper();
        this.aFactoryMgr = this.genericMaoContext.getMoFactoryMgrWrapper();
        this.helper = (RbsConfigurationHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationHelper.class);
        this.installAdaptor = PiuTypeInstallSupportAdaptor.instance();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createExtendedPlugInUnit(String identity, Coordinator coordinator) throws MoAccessException {
        block26: {
            block25: {
                Coordinator coordinator_forExt;
                Control control;
                if (identity != null) {
                    logger.traceEnter(THIS_CLASS, "createExtendedPlugInUnit() identity=" + identity);
                } else {
                    logger.traceEnter(THIS_CLASS, "createExtendedPlugInUnit() identity=null");
                }
                if (!identity.startsWith("DU")) break block25;
                ManagedObject slot = this.getSlot(identity);
                try {
                    TransactionFactory transFact = TransactionServicesFactoryImpl.getInstance().getCppTransactionFactory();
                    control = transFact.create(0);
                    coordinator_forExt = control.getCoordinator();
                    if (identity.equals("DU-2")) {
                        this.configureSwAllocationAndRepertoires(coordinator_forExt);
                    }
                    this.duSwa.actionAddSlot(slot, coordinator_forExt);
                }
                catch (TransactionRolledBackException e) {
                    throw new RbsConfigurationFailedException("Cannot Add Slot, TransactionRolledBackException", e.getMessage());
                }
                if (this.digitalEquipmentData.checkInterPiuLinkToDU1(identity)) {
                    this.createAntSetInterPiuLink(identity, slot, coordinator_forExt);
                    hasInterPiuLink = true;
                    try {
                        control.getTerminator().commit();
                    }
                    catch (TransactionRolledBackException e) {
                        throw new RbsConfigurationFailedException("Cannot commit transaction, TransactionRolledBackException", e.getMessage());
                    }
                    catch (InactiveTransactionException e1) {
                        try {
                            control.getTerminator().rollback();
                            throw new RbsConfigurationFailedException("Cannot commit add slot", e1.getMessage());
                        }
                        catch (InactiveTransactionException e2) {
                            throw new RbsConfigurationFailedException("Cannot Add Slot, TransactionRolledBackException", e2.getMessage());
                        }
                    }
                }
                if (!hasInterPiuLink) {
                    try {
                        control.getTerminator().commit();
                    }
                    catch (TransactionRolledBackException e) {
                        throw new RbsConfigurationFailedException("Cannot commit transaction, TransactionRolledBackException", e.getMessage());
                    }
                    catch (InactiveTransactionException e1) {
                        try {
                            control.getTerminator().rollback();
                            throw new RbsConfigurationFailedException("Cannot commit add slot", e1.getMessage());
                        }
                        catch (InactiveTransactionException e2) {
                            throw new RbsConfigurationFailedException("Cannot Add Slot, TransactionRolledBackException", e2.getMessage());
                        }
                    }
                    PiuTypeAccess slavePiuType = PiuTypeFinder.findPiuType("SLAVE_DU", this.aMoRepository, coordinator);
                    if (slavePiuType == null) {
                        String errMsg = "Cannot get PiuType for extended PlugInUnit, the PiuType is null.";
                        throw new RbsConfigurationFailedException("Cannot get PiuType for extended PlugInUnit, the PiuType is null.");
                    }
                    int lmFilesInstalledState = slavePiuType.getLmFilesInstallState(null);
                    if (lmFilesInstalledState != 2 && !this.isUpgradeOngoing()) {
                        this.installPiuType((PiuTypeMo)slavePiuType);
                    }
                    this.createExtendedPlugInUnitMo(slot, slavePiuType, identity, coordinator);
                    break block26;
                } else {
                    logger.traceDebug(THIS_CLASS, "createExtendedPlugInUnit(): hasInterPiuLink = true");
                    try {
                        control.getTerminator().commit();
                    }
                    catch (TransactionRolledBackException e) {
                        throw new RbsConfigurationFailedException("Cannot commit transaction, TransactionRolledBackException", e.getMessage());
                    }
                    catch (InactiveTransactionException e1) {
                        try {
                            control.getTerminator().rollback();
                            throw new RbsConfigurationFailedException("Cannot commit add slot", e1.getMessage());
                        }
                        catch (InactiveTransactionException e2) {
                            throw new RbsConfigurationFailedException("Cannot Add Slot, TransactionRolledBackException", e2.getMessage());
                        }
                    }
                }
            }
            String errorMessage = "Can not configure extended plugInUnit with id " + identity + ". Unknown type.";
            ((RbsConfigurationHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationHelper.class)).setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, "Site Equipment failure", errorMessage);
            throw new RbsConfigurationFailedException(errorMessage);
        }
        logger.traceReturn(THIS_CLASS, "createExtendedPlugInUnit()");
    }

    public void installPiuType(PiuTypeMo piuTypeMo) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "installPiuType()");
        if (piuTypeMo == null) {
            logger.traceDebug(THIS_CLASS, "piuTypeMo is null -> installPiuType() return");
            return;
        }
        int lmFilesInstalledState = piuTypeMo.getLmFilesInstallState(null);
        logger.traceDebug(THIS_CLASS, "SW download (lmFilesInstalledState=" + lmFilesInstalledState + ")");
        if (this.installAdaptor != null) {
            int i;
            logger.traceDebug(THIS_CLASS, "Found PiuTypeMo instance: " + piuTypeMo.getLocalDistinguishedName());
            int id1 = this.installAdaptor.installPiuType(piuTypeMo, (PiuTypeInstallListener)this);
            logger.traceDebug(THIS_CLASS, "installPiuType triggered. actionId=" + id1);
            int installedState = piuTypeMo.getLmFilesInstallState(null);
            logger.traceDebug(THIS_CLASS, "piuType installedState=" + installedState);
            try {
                for (i = 0; !this.installPiuTypeConfirmed && i <= this.MAX_INSTALLPIUTYPE_TRYING; ++i) {
                    logger.traceDebug(THIS_CLASS, i + ". installPiuTypeConfirmed=" + this.installPiuTypeConfirmed);
                    Thread.sleep(this.SLEEP_TIME);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            logger.traceDebug(THIS_CLASS, "InstallPiuType(): *** installPiuTypeConfirmed=" + this.installPiuTypeConfirmed);
            if (i >= this.MAX_INSTALLPIUTYPE_TRYING) {
                logger.traceDebug(THIS_CLASS, "InstallPiuType(): *** Exceed max time" + this.MAX_INSTALLPIUTYPE_TRYING + "for waiting installPiuTypeConfirmed");
            }
        }
        logger.traceReturn(THIS_CLASS, "installPiuType()");
    }

    private boolean isUpgradeOngoing() throws MoAccessException {
        ConfigurationVersionMo cvMo = (ConfigurationVersionMo)this.genericMaoContext.getMoRepositoryWrapper().lookup(CONFIGURATION_VERSION_LDN);
        logger.traceDebug(THIS_CLASS, "Check that ConfigurationVersionMo is not null: " + (cvMo != null));
        int upgradeState = -1;
        if (cvMo != null) {
            UpgradePackageMo upgradePackageMo = (UpgradePackageMo)cvMo.getCurrentUpgradePackage(null);
            logger.traceDebug(THIS_CLASS, "Check that UpgradePackageMo is not null: " + (upgradePackageMo != null));
            if (upgradePackageMo != null) {
                upgradeState = upgradePackageMo.getState(null);
            }
        }
        logger.traceDebug(THIS_CLASS, "Value of upgradeState: " + upgradeState);
        return upgradeState == 2 || upgradeState == 3;
    }

    public void installPiuTypeConfirmed(int id) {
        try {
            logger.traceEnter(THIS_CLASS, "installPiuTypeConfirmed(): id=" + id);
            this.installPiuTypeConfirmed = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.traceReturn(THIS_CLASS, "installPiuTypeConfirmed(): id=" + id);
    }

    public void installPiuTypeRejected(int id, InstallRejectReason reason) {
        logger.traceError(THIS_CLASS, "installPiuTypeRejected(): " + id + ". " + reason);
    }

    public void installPiuTypeRejected(int id, InstallRejectReason reason, String discription) {
        logger.traceError(THIS_CLASS, "installPiuTypeRejected(): " + id + ". " + reason + ". " + discription);
    }

    private void createAntSetInterPiuLink(String identity, ManagedObject slot, Coordinator coordinator) throws RbsConfigurationFailedException, MoAccessException {
        String subrackId = "1";
        String slotId = "1";
        ManagedObject slot1 = this.findSlot("1", "1");
        int firstSeparator = identity.indexOf(45);
        String curSlotId = identity.substring(firstSeparator + 1);
        this.createInterPiuLink(slot1, slot, curSlotId, coordinator);
    }

    protected ManagedObject getSlot(String identity) throws RbsConfigurationFailedException, MoAccessException {
        int firstSeparator = identity.indexOf(45);
        String subrackId = "1";
        String slotId = null;
        try {
            slotId = identity.substring(firstSeparator + 1);
        }
        catch (IndexOutOfBoundsException iobe) {
            throw new RbsConfigurationFailedException("MO create failed", "Incorrect unitId: " + identity);
        }
        ManagedObject slot = this.findSlot("1", slotId);
        return slot;
    }

    private void configureSwAllocationAndRepertoires(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "configureSwAllocationAndRepertoires()");
        if (coordinator == null) {
            logger.traceError(THIS_CLASS, "configureSwAllocationAndRepertoires() coordinator=null");
        } else {
            logger.info(THIS_CLASS, "configureSwAllocationAndRepertoires() " + coordinator.getTransactionID());
        }
        try {
            if (this.swAllocAndRepsConfigured != coordinator.getTransactionID()) {
                this.duSwa = this.findOrCreateSwAllocationMo(coordinator);
                this.addRepertoires(coordinator);
                this.swAllocAndRepsConfigured = coordinator.getTransactionID();
            }
        }
        catch (Exception e) {
            logger.traceError(THIS_CLASS, "123", (Throwable)e);
        }
        logger.traceReturn(THIS_CLASS, "configureSwAllocationAndRepertoires()");
    }

    private ManagedObject createInterPiuLink(ManagedObject primaryPiuSlot, ManagedObject secondaryPiuSlot, String identity, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "createInterPiuLink() identity=" + identity);
        MoFactory interPiuLinkFactory = this.aFactoryMgr.lookup("InterPiuLink");
        if (interPiuLinkFactory == null) {
            throw new RbsConfigurationFailedException("Could not find the MoFactory for InterPiuLink!");
        }
        AttrListImpl attrList = new AttrListImpl(this.aMoRepository);
        attrList.addElement("primaryPiuSlot", (Object)primaryPiuSlot);
        attrList.addElement("secondaryPiuSlot", (Object)secondaryPiuSlot);
        attrList.addElement("administrativeState", (Object)RbsConfigurationDefinitions.ADMINISTRATIVE_STATE_LOCKED);
        ManagedObject interPiuLinkMo = null;
        if (this.equipmentMo == null) {
            this.findEquipment();
        }
        try {
            interPiuLinkMo = interPiuLinkFactory.createMo(this.equipmentMo, (AttrList)attrList, identity, null, coordinator);
            RbsConfigurationReportLoggerFactory.getLogger().logAction("InterPiuLink=" + identity, "create", "primaryPiuSlot", "secondaryPiuSlot");
            RbsConfigurationReportLoggerFactory.getLogger().logAction("InterPiuLink=" + identity, "create", new String[]{"LDN", "primaryPiuSlot", "secondaryPiuSlot"}, new Object[]{interPiuLinkMo.getLocalDistinguishedName(), primaryPiuSlot.getLocalDistinguishedName(), secondaryPiuSlot.getLocalDistinguishedName()});
            try {
                RbsConfigurationUnlockHelper.getInstance().registerCreatedMo(interPiuLinkMo, coordinator);
            }
            catch (InactiveTransactionException e) {
                throw new RbsConfigurationFailedException("InactiveTransactionException: Could not register MO interPiuLinkMo");
            }
        }
        catch (MoNameAlreadyTakenException mnate) {
            logger.traceDebug(THIS_CLASS, "InterPiuLink=" + identity + " does already exist.");
        }
        logger.traceReturn(THIS_CLASS, "createInterPiuLink() ldn=" + interPiuLinkMo.getLocalDistinguishedName());
        return interPiuLinkMo;
    }

    protected void findEquipment() throws RbsConfigurationFailedException {
        this.equipmentMo = this.aMoRepository.lookup("ManagedElement=1,Equipment=1");
        if (this.equipmentMo == null) {
            throw new RbsConfigurationFailedException("The system created MO ManagedElement=1,Equipment=1 can not be found!");
        }
    }

    protected ManagedObject findSlot(String subrackId, String slotId) throws MoAccessException {
        ManagedObject slot = this.aMoRepository.lookup("ManagedElement=1,Equipment=1,Subrack=" + subrackId + "," + "Slot" + "=" + slotId);
        if (slot == null) {
            throw new MoNotFoundException("The requested slot " + slotId + " could not be found under the subrack!");
        }
        return slot;
    }

    protected final SwAllocationMo findOrCreateSwAllocationMo(Coordinator coordinator) throws RbsConfigurationFailedException {
        SwAllocationMo swa = (SwAllocationMo)this.aMoRepository.lookup("ManagedElement=1,SwManagement=1,SwAllocation=DU_Extension");
        if (swa == null) {
            ManagedObject swManagement = this.aMoRepository.lookup("ManagedElement=1,SwManagement=1");
            if (swManagement == null) {
                String msg = "Could not find the system created MO ManagedElement=1,SwManagement=1";
                throw new RbsConfigurationFailedException("Could not find the system created MO ManagedElement=1,SwManagement=1");
            }
            try {
                MoFactory swAllocationMoFactory = this.aFactoryMgr.lookup("SwAllocation");
                if (swAllocationMoFactory == null) {
                    throw new RbsConfigurationFailedException("Unable to lookup MO Factory for SwAllocation");
                }
                AttrListImpl attrList = new AttrListImpl(this.aMoRepository);
                attrList.addElement("role", (Object)"DU_Extension");
                swa = (SwAllocationMo)swAllocationMoFactory.createMo(swManagement, (AttrList)attrList, "DU_Extension", null, coordinator);
                RbsConfigurationReportLoggerFactory.getLogger().logAction("SwAllocation=DU_Extension", "create", "role", "DU_Extension");
            }
            catch (MoAccessException mae) {
                String msg = "Failed to create the MO \"ManagedElement=1,SwManagement=1,SwAllocation=DU_Extension";
                throw new RbsConfigurationFailedException("Failed to create the MO \"ManagedElement=1,SwManagement=1,SwAllocation=DU_Extension Original message: " + mae.getVariablesAsString());
            }
        }
        return swa;
    }

    protected final void addRepertoires(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "addRepertoires()");
        ManagedObject duRepertoire = null;
        logger.info(THIS_CLASS, "addRepertoires() rev2");
        for (int i = 0; i < RbsConfigurationDefinitions.REPERTOIRE_EXTENDSION_DU_LDN.length; ++i) {
            String repertoireLdn = RbsConfigurationDefinitions.REPERTOIRE_EXTENDSION_DU_LDN[i];
            duRepertoire = this.aMoRepository.lookup(repertoireLdn);
            if (duRepertoire == null) {
                logger.traceDebug(THIS_CLASS, "Repertoire with ldn=\"" + repertoireLdn + "\" not found");
                continue;
            }
            this.duSwa.actionAddRepertoire(duRepertoire, coordinator);
            RbsConfigurationReportLoggerFactory.getLogger().logAction("SwAllocation", "Add repertoire", new String[]{"SwAllocation", "Repertoire"}, new String[]{this.duSwa.getLocalDistinguishedName(), duRepertoire.getLocalDistinguishedName()});
        }
        logger.traceReturn(THIS_CLASS, "addRepertoires()");
    }

    public String getHelperName() {
        return this.getClass().getName();
    }

    private void configureExtendedPlugInUnitsWithProgress(Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "configureExtendedPlugInUnitsWithProgress()");
        this.createExtendedPiu(coordinator);
        this.setAutoConfigurationAllowed(coordinator);
        logger.traceReturn(THIS_CLASS, "configureExtendedPlugInUnitsWithProgress()");
    }

    public void execute(Coordinator coordinator) throws MoAccessException, InactiveTransactionException {
        this.configureExtendedPlugInUnitsWithProgress(coordinator);
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
    }

    private void createExtendedPiu(Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createExtendedPiu()");
        try {
            hasInterPiuLink = false;
            for (int digitalUnitIndex = 0; digitalUnitIndex < this.digitalEquipmentData.getDigitalUnit().length; ++digitalUnitIndex) {
                if (this.digitalEquipmentData.getDigitalUnit()[digitalUnitIndex].unitId.equals("DU-1")) continue;
                this.createExtendedPlugInUnit(this.digitalEquipmentData.getDigitalUnit()[digitalUnitIndex].unitId, coordinator);
            }
        }
        catch (MoAccessException mae) {
            String slogan = "MO create failed";
            String faultMsg = "Could not create all ExtendedPlugInUnits.";
            ProgressReportHandler.getInstance().updateProgressReportInformation(1050, 4, ExceptionHelper.appendReason((String)"Could not create all ExtendedPlugInUnits.", (Throwable)mae), true);
            throw new RbsConfigurationFailedException("MO create failed", "Could not create all ExtendedPlugInUnits.", (Exception)((Object)mae));
        }
        logger.traceReturn(THIS_CLASS, "createExtendedPiu()");
    }

    private void setAutoConfigurationAllowed(Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "setAutoConfigurationAllowed()");
        ManagedElementDataMo managedElementData = (ManagedElementDataMo)this.aMoRepository.lookup("ManagedElement=1,ManagedElementData=1");
        try {
            managedElementData.setAutoConfigurationAllowed(true, coordinator);
        }
        catch (MoAccessException mae) {
            String msg = "Could not activate autoConfiguration on Mo ManagedElementData.";
            this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, "Environment fault", "Could not activate autoConfiguration on Mo ManagedElementData.");
            logger.traceError(THIS_CLASS, "setAutoConfigurationAllowed():Could not activate autoConfiguration on Mo ManagedElementData. Original exception: " + mae.getVariablesAsString());
            throw new RbsConfigurationFailedException("Configuration fault", "Could not activate autoConfiguration on Mo ManagedElementData.", (Exception)((Object)mae));
        }
        logger.traceReturn(THIS_CLASS, "setAutoConfigurationAllowed()");
    }

    private void createExtendedPlugInUnitMo(ManagedObject parent, PiuTypeAccess piuType, String identity, Coordinator coordinator) throws MoAccessException {
        ManagedObject piu = null;
        try {
            piu = PlugInUnitFinder.findPlugInUnit(identity, this.aMoRepository);
            String msg = "PlugInUnit MO " + piu.getLocalDistinguishedName() + " already exists, no need to create it agian";
            logger.info(THIS_CLASS, msg);
            return;
        }
        catch (RbsConfigurationFailedException e) {
            String msg = "PlugInUnit MO for " + identity + " does not exist, need to create it.";
            logger.info(THIS_CLASS, msg);
            MoFactory piuFactory = this.aFactoryMgr.lookup("PlugInUnit");
            if (piuFactory == null) {
                throw new RbsConfigurationFailedException("Could not find the MoFactory for PlugInUnit!");
            }
            AttrListImpl attrList = new AttrListImpl(this.aMoRepository);
            attrList.addElement("piuType", (Object)piuType);
            try {
                piu = piuFactory.createMo(parent, (AttrList)attrList, "1", null, coordinator);
                RbsConfigurationReportLoggerFactory.getLogger().logAction("PlugInUnit", "create", new String[]{"LDN", "piuType"}, new Object[]{piu.getLocalDistinguishedName(), piuType.getRelativeDistinguishedName()});
                piu.setAttribute("administrativeState", (Object)RbsConfigurationDefinitions.ADMINISTRATIVE_STATE_UNLOCKED, coordinator);
            }
            catch (MoAccessException moAccessExc) {
                String msg2 = "Failed to create PlugInUnit MO under " + parent;
                throw new RbsConfigurationFailedException("Cannot create MO.", msg2, (Exception)((Object)moAccessExc));
            }
            return;
        }
    }
}

