/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.managedelement.ManagedElementDataMo;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoHasChildrenException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.crbs.cat.common.StringHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationContext;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.ParserHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationSmrsHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationUnlockHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.FileParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ProgressReportHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.FormatData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.CreateExtensionDUs;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.CreateSectorEquipments;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.ExtendedPlugInUnitHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.IWaiter;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.RbsConfigurationSiteEquipment;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.SiteEquipmentConfigurator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.datastructure.DigitalEquipmentData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.datastructure.DigitalUnitData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.datastructure.NodeData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.datastructure.SectorEquipmentData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.datastructure.SiteEquipmentData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionHandler;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.transactions.TransactionServicesFactoryImpl;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;
import se.ericsson.crbs.omf.mao.xml.Parser;
import se.ericsson.crbs.omf.mao.xml.XMLElement;

public class RbsConfigurationSiteEquipmentImpl
implements RbsConfigurationSiteEquipment {
    private static final Class THIS_CLASS = RbsConfigurationSiteEquipmentImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final transient MoRepositoryWrapper moRepositoryWrapper;
    private boolean getNewFile;
    private final RbsConfigurationHelper helper;
    private final RbsConfigurationMao rbsConfiguration;
    private final RbsConfigurationContext rbsConfigurationContext;
    private final String remoteFilePath;
    private final boolean validateXml;
    volatile int statusAvc = 0;
    private final Object lock = new Object();
    public boolean subscriptionProblemReported = false;
    private final FileParameters fileParameters;
    private String schemaPath = null;
    private final FormatData formatData;
    private final NodeData nodeData;
    private final DigitalEquipmentData digitalEquipmentData;
    private final CreateSectorEquipments createSectorEquipments;
    private final SiteEquipmentConfigurator siteEquipmentConfigurator;
    private boolean isFileParsed = false;

    public RbsConfigurationSiteEquipmentImpl(RbsConfigurationMao inRbsConfiguration, boolean inValidateXml) {
        this.rbsConfiguration = inRbsConfiguration;
        this.rbsConfigurationContext = inRbsConfiguration.getRbsConfigurationContext();
        this.moRepositoryWrapper = this.rbsConfigurationContext.getGenericMaoContext().getMoRepositoryWrapper();
        this.helper = (RbsConfigurationHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationHelper.class);
        this.fileParameters = FileParameters.instance(this.rbsConfiguration);
        this.remoteFilePath = this.fileParameters.getSiteEquipmentRemotePath();
        this.validateXml = inValidateXml;
        this.formatData = new FormatData(null);
        this.nodeData = new NodeData(null, false, false, false);
        this.digitalEquipmentData = new DigitalEquipmentData(new DigitalUnitData[0]);
        this.createSectorEquipments = new CreateSectorEquipments();
        this.siteEquipmentConfigurator = new SiteEquipmentConfigurator(this.moRepositoryWrapper, this.rbsConfiguration);
    }

    public void execute(Coordinator coordinator) throws MoAccessException, InactiveTransactionException {
        this.helper.setRbsProgressInformation(RbsConfigurationDefinitions.RBS_PI_ACTIVATING_SITE_EQUIPMENT_DATA);
        this.setSchemaPath(this.schemaPath, false);
        SiteEquipmentData siteEquipmentData = this.parseSiteEquipmentFile();
        if (siteEquipmentData.digitalEquipmentData != null && siteEquipmentData.digitalEquipmentData.checkMultiDu()) {
            ProgressReportHandler.getInstance().updateProgressReportInformation(1050, 3, "Configuring Extended Du Plug In Units", true);
            ExtendedPlugInUnitHelper extDuTp = (ExtendedPlugInUnitHelper)this.rbsConfigurationContext.getHelper(ExtendedPlugInUnitHelper.class);
            extDuTp.setDigitalEquipmentData(siteEquipmentData.digitalEquipmentData);
            TransactionHandler.run(extDuTp);
            this.waitForAutoConfig();
            CreateExtensionDUs idl2ExtDuTp = new CreateExtensionDUs(this.rbsConfigurationContext, siteEquipmentData.digitalEquipmentData);
            TransactionHandler.run(idl2ExtDuTp);
            ProgressReportHandler.getInstance().updateProgressReportInformation(1050, 5, "Configuring Extended Du Plug In Units", true);
        } else {
            ProgressReportHandler.getInstance().updateProgressReportInformation(1050, 2, "Configuring Extended Du Plug In Units", true);
        }
        this.siteEquipmentConfigurator.configureSiteEquipmentMos(siteEquipmentData, coordinator);
        this.unlockAllPluginUnits(coordinator);
        this.helper.setRbsConfigLevel(RbsConfigurationDefinitions.RBS_CL_SITE_EQUIPMENT);
    }

    private void unlockAllPluginUnits(Coordinator coordinator) {
        RbsConfigurationUnlockHelper.getInstance().unlockAllCreatedMos(coordinator);
        MoIterator piuMos = this.moRepositoryWrapper.lookupType("PlugInUnit");
        if (piuMos != null) {
            while (piuMos.hasMoreElements()) {
                ManagedObject piuMo = piuMos.nextMo();
                try {
                    piuMo.setAttribute("administrativeState", (Object)RbsConfigurationDefinitions.ADMINISTRATIVE_STATE_UNLOCKED, coordinator);
                    RbsConfigurationReportLoggerFactory.getLogger().logAttribute(piuMo.getRelativeDistinguishedName(), "administrativeState", "UNLOCKED");
                }
                catch (MoAccessException mae) {
                    RbsConfigurationReportLoggerFactory.getLogger().logFailure("Failed to unlock", "Could not unlock the MO : " + piuMo.getLocalDistinguishedName() + " Please unlock this manually later! Reason: " + (Object)((Object)mae) + " " + RbsConfigurationFailedException.convertVariablesMessage(mae.getVariablesAsString()));
                }
            }
        }
    }

    protected SiteEquipmentData parseSiteEquipmentFile() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "parseSiteEquipmentFile()");
        boolean isMultiCabConf = false;
        SiteEquipmentData siteEquipmentData = null;
        try {
            ProgressReportHandler.getInstance().updateProgressReportInformation(1000, 3, "Parsing Site Equipment file: " + StringHelper.doubleQuote((String)this.fileParameters.getSiteEquipmentFilePath()), true);
            Parser parser = ParserHelper.createParser(this.fileParameters.getSiteEquipmentFilePath(), this.validateXml, this.getSchemaPath());
            List xmlList = parser.getXMLelements();
            if (xmlList == null) {
                throw new IOException("Could not parse Site Equipment File, invalid XML.");
            }
            isMultiCabConf = this.checkMulticabConf(xmlList);
            Map typeElementMap = ParserHelper.createXmlTypeElementMap(xmlList);
            this.formatData.createRevision(typeElementMap);
            this.nodeData.createNodeData(typeElementMap);
            this.digitalEquipmentData.createDigitalEquipment(typeElementMap);
            SectorEquipmentData[] sectorEquipments = this.createSectorEquipments.createSectorEquipments(typeElementMap);
            siteEquipmentData = new SiteEquipmentData(this.nodeData, this.digitalEquipmentData, sectorEquipments, this.formatData.getRevision());
            ProgressReportHandler.getInstance().updateProgressReportInformation(1000, 5, "Successfully parsed Site Equipment file: " + StringHelper.doubleQuote((String)this.fileParameters.getSiteEquipmentFilePath()), true);
            this.isFileParsed = true;
        }
        catch (IOException ioe) {
            String slogan = "IO Fault";
            String faultMsg = "Could not parse file needed for Site Equipment.";
            ProgressReportHandler.getInstance().updateProgressReportInformation(1000, 4, "Could not parse file needed for Site Equipment.", true);
            throw new RbsConfigurationFailedException("IO Fault", "Could not parse file needed for Site Equipment.", ioe);
        }
        catch (NoClassDefFoundError exc) {
            String errorMsg = "Faulty SiteEquipment File";
            logger.traceGeneral(THIS_CLASS, "NoClassDefFoundError " + exc.getMessage());
            if (exc.getMessage().equalsIgnoreCase("java.sql.SQLException")) {
                logger.traceGeneral(THIS_CLASS, "Error parsing SiteEquipment XML file");
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_OAM_CONFIG_FILE_FAULT, "ErroneousInput", "Faulty SiteEquipment File");
            }
            throw exc;
        }
        SiteEquipmentData siteEquipmentDataWithVersion = new SiteEquipmentData(siteEquipmentData, isMultiCabConf);
        logger.traceReturn(THIS_CLASS, "parseSiteEquipmentFile()");
        return siteEquipmentDataWithVersion;
    }

    private boolean checkMulticabConf(List xmlList) {
        Iterator xmlIter = xmlList.iterator();
        while (xmlIter.hasNext()) {
            XMLElement xmlChild = (XMLElement)xmlIter.next();
            if (!"CommonSupportSystem".equalsIgnoreCase(xmlChild.getType())) continue;
            List xmlChildren = xmlChild.getChildren();
            Iterator xmlChildIter = xmlChildren.iterator();
            while (xmlChildIter.hasNext()) {
                XMLElement xmlChildin = (XMLElement)xmlChildIter.next();
                String xmlChildType = xmlChildin.getType();
                if (!"ClimateSystem".equalsIgnoreCase(xmlChildType) && !"Cabinet".equalsIgnoreCase(xmlChildType) && !"EcBus".equalsIgnoreCase(xmlChildType)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean loop(int noOfLoops) throws RbsConfigurationFailedException {
        this.helper.waitForRetry("Site Equipment");
        if (this.getNewFile) {
            this.helper.setRbsProgressInformation(RbsConfigurationDefinitions.RBS_PI_FETCHING_SITE_EQUIPMENT_FILE);
            RbsConfigurationSmrsHelper smrsHelper = (RbsConfigurationSmrsHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationSmrsHelper.class);
            smrsHelper.getFileFromFtp(1000, this.remoteFilePath, this.helper.getLocalPath() + "SiteEquipment.xml");
        }
        return true;
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        if (RbsConfigurationHelper.existsAndNotEmpty(this.remoteFilePath)) {
            this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_OAM_CONFIG_FILE_FAULT, "Site Equipment failure!", "Existing Site Equipment xml file is not correct. Getting new file. Original trace: " + (exception instanceof RbsConfigurationFailedException ? ((RbsConfigurationFailedException)((Object)exception)).getFormattedMessages() : exception.toString()));
            this.getNewFile = true;
        } else {
            this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_OAM_CONFIG_FILE_FAULT, "Site Equipment failure!", "Existing Site Equipment xml file is not correct. Replace the file on node with a correct version. Original trace: " + (exception instanceof RbsConfigurationFailedException ? ((RbsConfigurationFailedException)((Object)exception)).getFormattedMessages() : exception.toString()));
        }
        this.deleteMos(RbsConfigurationUnlockHelper.getInstance().getCreatedMos());
        RbsConfigurationUnlockHelper.getInstance().clearAllCreatedMos();
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UNDEFINED, "Configuration failed!", "Transaction failure. Retrying.");
        this.deleteMos(RbsConfigurationUnlockHelper.getInstance().getCreatedMos());
        RbsConfigurationUnlockHelper.getInstance().clearAllCreatedMos();
    }

    private void deleteMos(List createdMos) {
        logger.traceEnter(THIS_CLASS, "deleteMos()");
        Iterator it = createdMos.iterator();
        Control control = null;
        try {
            control = TransactionServicesFactoryImpl.getInstance().getCppTransactionFactory().create(0);
            Coordinator coordinator = control.getCoordinator();
            while (it.hasNext()) {
                ManagedObject mo = (ManagedObject)it.next();
                logger.traceDebug(THIS_CLASS, "Deleting: " + mo.getLocalDistinguishedName());
                try {
                    if (mo.getChildren().hasMoreElements()) {
                        this.deleteAllChildrenIteratively(mo.getChildren(), coordinator);
                    } else {
                        mo.delete(coordinator);
                    }
                    control.getTerminator().commit();
                }
                catch (MoHasChildrenException e) {
                    logger.traceError(THIS_CLASS, "Unexpected exception: " + e.getLocalizedMessage());
                }
                catch (MoAccessException e) {
                    control.getTerminator().rollback();
                    logger.traceError(THIS_CLASS, "Failed to delete: " + mo.getLocalDistinguishedName() + " because: " + e.getLocalizedMessage());
                    this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UNDEFINED, "Configuration failed!", "Failed to delete: " + mo.getLocalDistinguishedName() + " because: " + e.getLocalizedMessage());
                }
            }
        }
        catch (TransactionRolledBackException e) {
            logger.traceError(THIS_CLASS, "Transaction exception: Could not get Control Object!");
            this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UNDEFINED, "Rollback failed!", "Transaction failure. Retrying.");
        }
        catch (InactiveTransactionException e) {
            logger.traceError(THIS_CLASS, "Transaction exception: Could not commit deleted MOs!");
            this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UNDEFINED, "Rollback failed!", "Transaction failure. Retrying.");
        }
        logger.traceReturn(THIS_CLASS, "deleteMos()");
    }

    private void deleteAllChildrenIteratively(MoIterator inChildren, Coordinator coordinator) throws MoHasChildrenException, MoAccessException {
        while (inChildren.hasMoreElements()) {
            ManagedObject tempMo = inChildren.nextMo();
            logger.traceDebug(THIS_CLASS, "Deleting child: " + tempMo.getLocalDistinguishedName());
            if (tempMo.getChildren().hasMoreElements()) {
                this.deleteAllChildrenIteratively(tempMo.getChildren(), coordinator);
            }
            tempMo.delete(coordinator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForAutoConfig() throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "waitForAutoConfig()");
        String ldn = "ManagedElement=1,Equipment=1,Subrack=1,Slot=2,PlugInUnit=1";
        ManagedElementDataMo managedElementData = (ManagedElementDataMo)this.moRepositoryWrapper.lookup("ManagedElement=1,ManagedElementData=1");
        int maxwait = 120000;
        int wait = 1000;
        int waited = 0;
        boolean becameBusy = false;
        boolean becameIdle = false;
        while (waited < 120000) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    int status = managedElementData.getAutoConfigurationStatus(null);
                    ManagedObject piu1 = this.moRepositoryWrapper.lookup("ManagedElement=1,Equipment=1,Subrack=1,Slot=2,PlugInUnit=1");
                    if (piu1 != null && !becameBusy) {
                        becameBusy = true;
                    }
                    if (status == 0 && becameBusy && !becameIdle) {
                        becameIdle = true;
                    }
                    if (becameBusy && becameIdle) {
                        break;
                    }
                    this.lock.wait(1000L);
                    waited = 1000 + waited;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        if (!becameBusy || !becameIdle) {
            throw new RbsConfigurationFailedException("Timeout during waiting for Auto Configuration of ManagedElement=1,Equipment=1,Subrack=1,Slot=2,PlugInUnit=1. Auto Configuration became busy:" + becameBusy + " Auto Configuration became idle:" + becameIdle);
        }
        logger.traceReturn(THIS_CLASS, "waitForAutoConfig()");
    }

    public String getSchemaPath() {
        return this.schemaPath;
    }

    public void setSchemaPath(String inSchemaPath, boolean testCase) {
        this.schemaPath = testCase ? inSchemaPath : "rbsManagerMetaData/rbsConfiguration/";
    }

    public void setWaiter(IWaiter inWaiter) {
        this.siteEquipmentConfigurator.setWaiter(inWaiter);
    }

    public DigitalEquipmentData getDigitalEquipmentData() {
        if (!this.isFileParsed) {
            try {
                this.parseSiteEquipmentFile();
            }
            catch (RbsConfigurationFailedException e) {
                logger.traceError(THIS_CLASS, "Parse SiteEquipment file failed.");
            }
        }
        return this.digitalEquipmentData;
    }

    public NodeData getNodeData() {
        return this.nodeData;
    }
}

