/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment;

import java.io.IOException;
import java.util.ArrayList;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.AntennaSystemConfigurationFailedException;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.datastructure.AntennaNearUnitData;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.datastructure.AntennaSystemData;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.datastructure.AntennaSystemDataFinder;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.datastructure.AntennaUnitGroupData;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.datastructure.RetSubUnitData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationContext;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.RetSubUnitParser;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class RetSubUnitParserImpl
implements RetSubUnitParser {
    private static final Class THIS_CLASS = RetSubUnitParserImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final RbsConfigurationMao rbsConfigurationMao;

    public RetSubUnitParserImpl(RbsConfigurationMao theRbsConfigurationMao) {
        this.rbsConfigurationMao = theRbsConfigurationMao;
    }

    public AntennaConfigurationFileHolder[] parseAntennaConfigurationFiles(String siteEquipmentFile) throws AntennaSystemConfigurationFailedException, IOException {
        logger.traceEnter(THIS_CLASS, "parseSiteEquipmentForAntennaConfigurationFiles()");
        RbsConfigurationContext rbsConfigurationContext = this.rbsConfigurationMao.getRbsConfigurationContext();
        MoRepositoryWrapper moRepositoryWrapper = rbsConfigurationContext.getGenericMaoContext().getMoRepositoryWrapper();
        AntennaSystemDataFinder antennaSystemDataFinder = new AntennaSystemDataFinder();
        AntennaSystemData antennaSystemData = antennaSystemDataFinder.parseAntennaSystemXmlFile(siteEquipmentFile, moRepositoryWrapper);
        AntennaUnitGroupData[] antennaUnitGroupData = antennaSystemData.antennaUnitGroupData;
        ArrayList<AntennaConfigurationFileHolder> antennaConfifFilesList = new ArrayList<AntennaConfigurationFileHolder>();
        for (int i = 0; i < antennaUnitGroupData.length; ++i) {
            AntennaNearUnitData[] antennaNearUnitData = antennaUnitGroupData[i].antennaNearUnitData;
            for (int j = 0; j < antennaNearUnitData.length; ++j) {
                RetSubUnitData[] retSubUnitData = antennaNearUnitData[j].retSubUnitData;
                for (int k = 0; k < retSubUnitData.length; ++k) {
                    if (retSubUnitData[k].antennaConfigurationFile == null || retSubUnitData[k].antennaConfigurationFile.equals("")) continue;
                    String retSubUnitLdn = this.createLdn(antennaUnitGroupData[i].antennaUnitGroupId, antennaNearUnitData[j].antennaNearUnitId, retSubUnitData[k].retSubUnitId);
                    antennaConfifFilesList.add(new AntennaConfigurationFileHolder(retSubUnitLdn, retSubUnitData[k].antennaConfigurationFile));
                }
            }
        }
        AntennaConfigurationFileHolder[] result2 = new AntennaConfigurationFileHolder[antennaConfifFilesList.size()];
        antennaConfifFilesList.toArray(result2);
        logger.traceReturn(THIS_CLASS, "parseSiteEquipmentForAntennaConfigurationFiles()");
        return result2;
    }

    private String createLdn(String antennaUnitGroupId, String antennaNearUnitId, String retSubUnitId) {
        return "ManagedElement=1,Equipment=1,AntennaUnitGroup=" + antennaUnitGroupId + "," + "AntennaNearUnit" + "=" + antennaNearUnitId + "," + "RetSubUnit" + "=" + retSubUnitId;
    }

    public static class AntennaConfigurationFileHolder {
        public final String ldn;
        public final String antennaConfigurationFile;

        public AntennaConfigurationFileHolder(String theLdn, String theAntennaConfigurationFile) {
            this.ldn = theLdn;
            this.antennaConfigurationFile = theAntennaConfigurationFile;
        }
    }
}

