/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment;

import java.util.List;
import se.ericsson.cello.managedelement.ManagedElementDataMo;
import se.ericsson.cello.managedelement.ManagedElementMo;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.AntennaSystemConfigurationFailedException;
import se.ericsson.crbs.cat.mao.antennasystemconfiguration.AntennaSystemConfigurationMaoImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationConfigHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationUnlockHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.FileParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ProgressReportHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.AntennaSystemConfigurationReportLoggerImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.SupportSystemConfigurationReportLoggerImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.AuxHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.IWaiter;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.PlugInUnitFinder;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.PlugInUnitHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.SectorHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.Waiter;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.datastructure.DigitalEquipmentData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.datastructure.RiPortData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.datastructure.SectorEquipmentData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.datastructure.SiteEquipmentData;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.transactions.TransactionServicesFactoryImpl;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;
import se.ericsson.crbs.supsys.supportsystemconfiguration.SupportSystemConfigurationFailedException;
import se.ericsson.crbs.supsys.supportsystemconfiguration.SupportSystemConfigurationMao;
import se.ericsson.crbs.supsys.supportsystemconfiguration.reportlogger.SupportSystemConfigurationReportLogger;

public class SiteEquipmentConfigurator {
    private static final String RESERVED_BY = "reservedBy";
    private static final Class THIS_CLASS = SiteEquipmentConfigurator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final transient GenericMaoContext genericMaoContext;
    private final transient MoRepositoryWrapper moRepositoryWrapper;
    private final RbsConfigurationHelper helper;
    private final RbsConfigurationMao rbsConfiguration;
    private final FileParameters fileParameters;
    private int riLinkCounter = 1;
    private IWaiter waiter = new Waiter();

    public SiteEquipmentConfigurator(MoRepositoryWrapper inMoRepositoryWrapper, RbsConfigurationMao inRbsConfiguration) {
        this.moRepositoryWrapper = inMoRepositoryWrapper;
        this.rbsConfiguration = inRbsConfiguration;
        this.helper = (RbsConfigurationHelper)this.rbsConfiguration.getRbsConfigurationContext().getHelper(RbsConfigurationHelper.class);
        this.genericMaoContext = this.rbsConfiguration.getRbsConfigurationContext().getGenericMaoContext();
        this.fileParameters = FileParameters.instance(this.rbsConfiguration);
    }

    public void configureSiteEquipmentMos(SiteEquipmentData siteEquipmentData, Coordinator coordinator) throws RbsConfigurationFailedException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "configureRbsEquipment()");
        if (siteEquipmentData.digitalEquipmentData != null && siteEquipmentData.digitalEquipmentData.checkMultiDu()) {
            this.checkAutoConfigValue(coordinator);
            this.setupIDL2RiPorts(siteEquipmentData.digitalEquipmentData);
        }
        this.configureRadioEquipmentWithProgress(siteEquipmentData, coordinator);
        this.configureSupportSystemWithProgress(siteEquipmentData, coordinator);
        this.assignPositionRefToAuxPlugInUnits(siteEquipmentData, coordinator);
        this.assignPositionInformationToAuxPlugInUnitsRd(siteEquipmentData, coordinator);
        this.assignPositionCoordinatesToAuxPlugInUnitsRd(siteEquipmentData, coordinator);
        this.configureAntennasSystemWithProgress(siteEquipmentData, coordinator);
        this.setLteMpProgramsRestartCounterLimit(coordinator);
        logger.traceReturn(THIS_CLASS, "configureRbsEquipment()");
    }

    private void assignPositionRefToAuxPlugInUnits(SiteEquipmentData siteEquipmentData, Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "assignPositionRefToAuxPlugInUnits()");
        try {
            ProgressReportHandler.getInstance().updateProgressReportInformation(1100, 3, "Configuring Radio Equipment", true);
            this.setAuxPiu(siteEquipmentData.sectorEquipments, siteEquipmentData.isMultiCabinetConfiguration, coordinator);
            ProgressReportHandler.getInstance().updateProgressReportInformation(1100, 5, "Successfully configured Radio Equipment", false);
        }
        catch (RbsConfigurationFailedException rcfe) {
            String errorMsg = ExceptionHelper.appendReason((String)"Failed to configure Radio Equipment", (Throwable)((Object)rcfe));
            ProgressReportHandler.getInstance().updateProgressReportInformation(1100, 4, errorMsg, false);
            throw rcfe;
        }
        logger.traceReturn(THIS_CLASS, "assignPositionRefToAuxPlugInUnits()");
    }

    private void assignPositionInformationToAuxPlugInUnitsRd(SiteEquipmentData siteEquipmentData, Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "assignPositionInformationToAuxPlugInUnitsRd()");
        try {
            ProgressReportHandler.getInstance().updateProgressReportInformation(1100, 3, "Configuring Radio Equipment for RD (positionInformation)", true);
            this.setPositionInformation(siteEquipmentData.sectorEquipments, coordinator);
            ProgressReportHandler.getInstance().updateProgressReportInformation(1100, 5, "Successfully configured Radio Equipment for RD (positionInformation)", false);
        }
        catch (RbsConfigurationFailedException rcfe) {
            String errorMsg = ExceptionHelper.appendReason((String)"Failed to configure Radio Equipment for RD (positionInformation)", (Throwable)((Object)rcfe));
            ProgressReportHandler.getInstance().updateProgressReportInformation(1100, 4, errorMsg, false);
            throw rcfe;
        }
        logger.traceReturn(THIS_CLASS, "assignPositionInformationToAuxPlugInUnitsRd()");
    }

    private void assignPositionCoordinatesToAuxPlugInUnitsRd(SiteEquipmentData siteEquipmentData, Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "assignPositionCoordinatesToAuxPlugInUnitsRd()");
        try {
            ProgressReportHandler.getInstance().updateProgressReportInformation(1100, 3, "Configuring Radio Equipment for RD (positionCoordinates)", true);
            this.setPositionCoordinates(siteEquipmentData.sectorEquipments, coordinator);
            ProgressReportHandler.getInstance().updateProgressReportInformation(1100, 5, "Successfully configured Radio Equipment for RD (positionCoordinates)", false);
        }
        catch (RbsConfigurationFailedException rcfe) {
            String errorMsg = ExceptionHelper.appendReason((String)"Failed to configure Radio Equipment for RD (positionCoordinates)", (Throwable)((Object)rcfe));
            ProgressReportHandler.getInstance().updateProgressReportInformation(1100, 4, errorMsg, false);
            throw rcfe;
        }
        logger.traceReturn(THIS_CLASS, "assignPositionCoordinatesToAuxPlugInUnitsRd()");
    }

    private void configureRadioEquipmentWithProgress(SiteEquipmentData siteEquipmentData, Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "configureRadioEquipmentWithProgress()");
        try {
            ProgressReportHandler.getInstance().updateProgressReportInformation(1100, 3, "Configuring Radio Equipment", true);
            this.setAutoConfigurationAllowed(true, coordinator);
            this.createAuxPiu(siteEquipmentData.sectorEquipments, coordinator);
            this.setupRdiPortMos(siteEquipmentData.sectorEquipments, coordinator);
            ProgressReportHandler.getInstance().updateProgressReportInformation(1100, 5, "Successfully configured Radio Equipment", false);
        }
        catch (RbsConfigurationFailedException rcfe) {
            String errorMsg = ExceptionHelper.appendReason((String)"Failed to configure Radio Equipment", (Throwable)((Object)rcfe));
            ProgressReportHandler.getInstance().updateProgressReportInformation(1100, 4, errorMsg, false);
            throw rcfe;
        }
        logger.traceReturn(THIS_CLASS, "configureRadioEquipmentWithProgress()");
    }

    private void configureSupportSystemWithProgress(SiteEquipmentData siteEquipmentData, Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "configureSupportSystemWithProgress()");
        try {
            ProgressReportHandler.getInstance().updateProgressReportInformation(1200, 3, "Configuring Support System", true);
            this.configureSupportSystem(coordinator);
            this.setProductAndSiteData(siteEquipmentData, coordinator);
            ProgressReportHandler.getInstance().updateProgressReportInformation(1200, 5, "Successfully configuried Support System", false);
        }
        catch (RbsConfigurationFailedException rcfe) {
            String errorMsg = ExceptionHelper.appendReason((String)"Failed to configure Support System", (Throwable)((Object)rcfe));
            ProgressReportHandler.getInstance().updateProgressReportInformation(1200, 4, errorMsg, false);
            throw rcfe;
        }
        logger.traceReturn(THIS_CLASS, "configureSupportSystemWithProgress()");
    }

    private void configureAntennasSystemWithProgress(SiteEquipmentData siteEquipmentData, Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "configureAntennasSystemWithProgress()");
        try {
            ProgressReportHandler.getInstance().updateProgressReportInformation(1300, 3, "Configuring Antenna System", true);
            this.createAntennaMos(coordinator);
            this.setupRiPortMos(siteEquipmentData.sectorEquipments, coordinator);
            this.createSectorMos(siteEquipmentData.sectorEquipments, coordinator);
            this.unlockAllCreatedMos(coordinator);
            ProgressReportHandler.getInstance().updateProgressReportInformation(1300, 5, "Successfully configured Antenna System", true);
        }
        catch (RbsConfigurationFailedException rcfe) {
            String errorMsg = ExceptionHelper.appendReason((String)"Failed to configure Antenna System", (Throwable)((Object)rcfe));
            ProgressReportHandler.getInstance().updateProgressReportInformation(1300, 4, errorMsg, false);
            throw rcfe;
        }
        logger.traceReturn(THIS_CLASS, "configureAntennasSystemWithProgress()");
    }

    private void setLteMpProgramsRestartCounterLimit(Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "setLteMpProgramsRestartCounterLimit()");
        ((RbsConfigurationConfigHelper)this.rbsConfiguration.getRbsConfigurationContext().getHelper(RbsConfigurationConfigHelper.class)).setLteMpProgramsRestartCounterLimit(1, coordinator);
        logger.traceReturn(THIS_CLASS, "setLteMpProgramsRestartCounterLimit()");
    }

    public void setAutoConfigurationAllowed(boolean value, Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "setAutoConfigurationAllowed()");
        ManagedElementDataMo managedElementData = (ManagedElementDataMo)this.moRepositoryWrapper.lookup("ManagedElement=1,ManagedElementData=1");
        try {
            managedElementData.setAutoConfigurationAllowed(value, coordinator);
        }
        catch (MoAccessException mae) {
            String msg = "Could not activate autoConfiguration on Mo ManagedElementData.";
            this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, "Environment fault", "Could not activate autoConfiguration on Mo ManagedElementData.");
            logger.traceError(THIS_CLASS, "setAutoConfigurationAllowed():Could not activate autoConfiguration on Mo ManagedElementData. Original exception: " + mae.getVariablesAsString());
            throw new RbsConfigurationFailedException("Configuration fault", "Could not activate autoConfiguration on Mo ManagedElementData.", (Exception)((Object)mae));
        }
        logger.traceReturn(THIS_CLASS, "setAutoConfigurationAllowed()");
    }

    public void checkAutoConfigValue(Coordinator coordinator) {
        ManagedElementDataMo managedElementData = (ManagedElementDataMo)this.moRepositoryWrapper.lookup("ManagedElement=1,ManagedElementData=1");
        try {
            boolean value = managedElementData.getAutoConfigurationAllowed(coordinator);
            RbsConfigurationReportLoggerFactory.getLogger().logInformation("Check autoConfigurationAllowed", "autoConfigurationAllowed is " + value);
        }
        catch (MoAccessException e) {
            e.printStackTrace();
        }
    }

    protected void setAuxPiu(SectorEquipmentData[] sectorEquipments, boolean isMultiCabConf, Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "setAuxPiu()");
        try {
            AuxHelper auxHelper = (AuxHelper)this.rbsConfiguration.getRbsConfigurationContext().getHelper(AuxHelper.class);
            for (int sectorIndex = 0; sectorIndex < sectorEquipments.length; ++sectorIndex) {
                for (int radioIndex = 0; radioIndex < sectorEquipments[sectorIndex].radioEquipment.radioUnits.length; ++radioIndex) {
                    auxHelper.setPluginUnitRef(sectorEquipments[sectorIndex].radioEquipment.radioUnits[radioIndex].positionRef, isMultiCabConf, sectorEquipments[sectorIndex].radioEquipment.radioUnits[radioIndex].unitId, coordinator);
                }
            }
        }
        catch (MoAccessException mae) {
            String slogan = "MO create failed";
            String faultMsg = "Could not set positionRef for all AuxPlugInUnits.";
            ProgressReportHandler.getInstance().updateProgressReportInformation(1100, 4, ExceptionHelper.appendReason((String)"Could not set positionRef for all AuxPlugInUnits.", (Throwable)mae), true);
            throw new RbsConfigurationFailedException("MO create failed", "Could not set positionRef for all AuxPlugInUnits.", (Exception)((Object)mae));
        }
        logger.traceReturn(THIS_CLASS, "setAuxPiu()");
    }

    protected void setPositionInformation(SectorEquipmentData[] sectorEquipments, Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "setPositionInformation()");
        try {
            AuxHelper auxHelper = (AuxHelper)this.rbsConfiguration.getRbsConfigurationContext().getHelper(AuxHelper.class);
            for (int sectorIndex = 0; sectorIndex < sectorEquipments.length; ++sectorIndex) {
                for (int radioDotIndex = 0; radioDotIndex < sectorEquipments[sectorIndex].radioEquipment.radioDotUnits.length; ++radioDotIndex) {
                    auxHelper.setRdPositionInformation(sectorEquipments[sectorIndex].radioEquipment.radioDotUnits[radioDotIndex].positionInformation, sectorEquipments[sectorIndex].radioEquipment.radioDotUnits[radioDotIndex].unitId, coordinator);
                }
            }
        }
        catch (MoAccessException mae) {
            String slogan = "MO create failed";
            String faultMsg = "Could not set positionInformation for AuxPlugInUnits RD.";
            ProgressReportHandler.getInstance().updateProgressReportInformation(1100, 4, ExceptionHelper.appendReason((String)"Could not set positionInformation for AuxPlugInUnits RD.", (Throwable)mae), true);
            throw new RbsConfigurationFailedException("MO create failed", "Could not set positionInformation for AuxPlugInUnits RD.", (Exception)((Object)mae));
        }
        logger.traceReturn(THIS_CLASS, "setPositionInformation()");
    }

    protected void setPositionCoordinates(SectorEquipmentData[] sectorEquipments, Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "setPositionCoordinates()");
        try {
            AuxHelper auxHelper = (AuxHelper)this.rbsConfiguration.getRbsConfigurationContext().getHelper(AuxHelper.class);
            for (int sectorIndex = 0; sectorIndex < sectorEquipments.length; ++sectorIndex) {
                for (int radioDotIndex = 0; radioDotIndex < sectorEquipments[sectorIndex].radioEquipment.radioDotUnits.length; ++radioDotIndex) {
                    auxHelper.setRdPositionCoordinates(sectorEquipments[sectorIndex].radioEquipment.radioDotUnits[radioDotIndex].getPositionCoordinates(), sectorEquipments[sectorIndex].radioEquipment.radioDotUnits[radioDotIndex].unitId, coordinator);
                }
            }
        }
        catch (MoAccessException mae) {
            String slogan = "MO create failed";
            String faultMsg = "Could not set positionCoordinates for AuxPlugInUnits RD.";
            ProgressReportHandler.getInstance().updateProgressReportInformation(1100, 4, ExceptionHelper.appendReason((String)"Could not set positionCoordinates for AuxPlugInUnits RD.", (Throwable)mae), true);
            throw new RbsConfigurationFailedException("MO create failed", "Could not set positionCoordinates for AuxPlugInUnits RD.", (Exception)((Object)mae));
        }
        logger.traceReturn(THIS_CLASS, "setPositionCoordinates()");
    }

    protected void createAuxPiu(SectorEquipmentData[] sectorEquipments, Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createAuxPiu()");
        try {
            AuxHelper auxHelper = (AuxHelper)this.rbsConfiguration.getRbsConfigurationContext().getHelper(AuxHelper.class);
            for (int sectorIndex = 0; sectorIndex < sectorEquipments.length; ++sectorIndex) {
                for (int radioIndex = 0; radioIndex < sectorEquipments[sectorIndex].radioEquipment.radioUnits.length; ++radioIndex) {
                    auxHelper.createAuxPlugInUnit(sectorEquipments[sectorIndex].radioEquipment.radioUnits[radioIndex].unitId, coordinator);
                }
                for (int radioDotIndex = 0; radioDotIndex < sectorEquipments[sectorIndex].radioEquipment.radioDotUnits.length; ++radioDotIndex) {
                    auxHelper.createAuxPlugInUnit(sectorEquipments[sectorIndex].radioEquipment.radioDotUnits[radioDotIndex].unitId, coordinator);
                }
            }
        }
        catch (MoAccessException mae) {
            String slogan = "MO create failed";
            String faultMsg = "Could not create all AuxPlugInUnits.";
            ProgressReportHandler.getInstance().updateProgressReportInformation(1100, 4, ExceptionHelper.appendReason((String)"Could not create all AuxPlugInUnits.", (Throwable)mae), true);
            throw new RbsConfigurationFailedException("MO create failed", "Could not create all AuxPlugInUnits.", (Exception)((Object)mae));
        }
        logger.traceReturn(THIS_CLASS, "createAuxPiu()");
    }

    protected void autoCreateChildrenForPlugInUnits(Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "autoCreateChildrenForPlugInUnits()");
        PlugInUnitHelper plugHelper = new PlugInUnitHelper(this.genericMaoContext);
        plugHelper.prepareChildrenForAllPlugInUnits(coordinator);
        logger.traceReturn(THIS_CLASS, "autoCreateChildrenForPlugInUnits()");
    }

    private void configureSupportSystem(Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "configureSupportSystem()");
        ManagedObject supportSystemConfiguration = this.moRepositoryWrapper.lookup("ManagedElement=1,SupportSystemConfiguration=1");
        if (supportSystemConfiguration == null) {
            String slogan = "MO not found";
            String faultMsg = "Unable to find the system created MO SupportSystemConfiguration.";
            throw new RbsConfigurationFailedException("MO not found", "Unable to find the system created MO SupportSystemConfiguration.");
        }
        SupportSystemConfigurationReportLoggerImpl reportLogger = new SupportSystemConfigurationReportLoggerImpl();
        ((SupportSystemConfigurationMao)supportSystemConfiguration).registerReportLogger((SupportSystemConfigurationReportLogger)reportLogger);
        String siteEquipmentFilePath = this.fileParameters.getSiteEquipmentFilePath();
        try {
            ((SupportSystemConfigurationMao)supportSystemConfiguration).actionConfigureSupportSystem(siteEquipmentFilePath, coordinator);
        }
        catch (SupportSystemConfigurationFailedException sscfe) {
            throw new RbsConfigurationFailedException(sscfe.getFormattedMessages());
        }
        logger.traceReturn(THIS_CLASS, "configureSupportSystem()");
    }

    protected void createAntennaMos(Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createAntennaMos()");
        try {
            AntennaSystemConfigurationMaoImpl antennaSystemConfiguration = new AntennaSystemConfigurationMaoImpl(this.genericMaoContext);
            AntennaSystemConfigurationReportLoggerImpl reportLogger = new AntennaSystemConfigurationReportLoggerImpl();
            antennaSystemConfiguration.registerReportLogger(reportLogger);
            String siteEquipmentFilePath = this.fileParameters.getSiteEquipmentFilePath();
            antennaSystemConfiguration.actionConfigureAntennaSystem(siteEquipmentFilePath, coordinator);
        }
        catch (AntennaSystemConfigurationFailedException ascfe) {
            throw new RbsConfigurationFailedException("Antenna configuration failed", ascfe.getFormattedMessages());
        }
        logger.traceReturn(THIS_CLASS, "createAntennaMos()");
    }

    protected void createSectorMos(SectorEquipmentData[] sectorEquipments, Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createSectorMos()");
        boolean mixedModeUsed = false;
        try {
            SectorHelper sectorHelper = (SectorHelper)this.rbsConfiguration.getRbsConfigurationContext().getHelper(SectorHelper.class);
            for (int sectorIndex = 0; sectorIndex < sectorEquipments.length; ++sectorIndex) {
                sectorHelper.createSectorFunctionMo(sectorEquipments[sectorIndex], coordinator);
                if (!sectorEquipments[sectorIndex].mixedModeRadio.booleanValue()) continue;
                mixedModeUsed = true;
            }
            if (mixedModeUsed) {
                this.activateMixedModeFeature(coordinator);
            }
        }
        catch (MoAccessException mae) {
            String slogan = "MO create failed";
            String faultMsg = "Could not create all SectorFunctions.";
            throw new RbsConfigurationFailedException("MO create failed", "Could not create all SectorFunctions.", (Exception)((Object)mae));
        }
        logger.traceReturn(THIS_CLASS, "createSectorMos()");
    }

    private void activateMixedModeFeature(Coordinator coordinator) throws RbsConfigurationFailedException {
        ManagedObject mixedModeMo = this.moRepositoryWrapper.lookup("ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatures=1,MixedMode=1");
        if (mixedModeMo == null) {
            throw new RbsConfigurationFailedException("MO MixedMode representing the Optional Feature Mixed Mode is missing, unable to activate needed feature!");
        }
        try {
            mixedModeMo.setAttribute("featureStateMixedMode", (Object)RbsConfigurationDefinitions.ACTIVATED, coordinator);
            RbsConfigurationReportLoggerFactory.getLogger().logAttribute("MixedMode", "featureStateMixedMode", "ACTIVATED");
        }
        catch (MoAccessException mae) {
            throw new RbsConfigurationFailedException("SectorEquipmentConfiguration", "Unable to activate feature MixedMode.", (Exception)((Object)mae)){};
        }
    }

    private void setProductAndSiteData(SiteEquipmentData siteEquipmentData, Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "setProductAndSiteData()");
        ManagedElementMo managedElement = (ManagedElementMo)this.moRepositoryWrapper.lookup("ManagedElement=1");
        if (managedElement == null) {
            String slogan = "MO not found";
            String faultMsg = "Unable to find the system created MO ManagedElement.";
            throw new RbsConfigurationFailedException("MO not found", "Unable to find the system created MO ManagedElement.");
        }
        try {
            managedElement.setSite(siteEquipmentData.nodeData.getSite(), coordinator);
            this.addRatInfoToProductName(coordinator, managedElement);
            RbsConfigurationReportLoggerFactory.getLogger().logAttributes("ManagedElement", new String[]{"Site"}, new Object[]{siteEquipmentData.nodeData.getSite()});
        }
        catch (MoAccessException mae) {
            String slogan = "Set attributes failed";
            String faultMsg = "Failed to set attributes on ManagedElement MO.";
            throw new RbsConfigurationFailedException("Set attributes failed", "Failed to set attributes on ManagedElement MO.");
        }
        logger.traceReturn(THIS_CLASS, "setProductAndSiteData(" + siteEquipmentData.nodeData.getSite() + ")");
    }

    private void addRatInfoToProductName(Coordinator coordinator, ManagedElementMo managedElement) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "addRatInfoToProductName()");
        String currentProductName = managedElement.getProductName(coordinator);
        if (!(null == currentProductName || "".equals(currentProductName) || currentProductName.endsWith("L") || currentProductName.endsWith("W") || currentProductName.endsWith("G"))) {
            RbsConfigurationReportLoggerFactory.getLogger().logInformation("ManagedElement", "Adding Radio Access Technology information to product name.");
            String newProductName = currentProductName + "L";
            managedElement.setProductName(newProductName, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "addRatInfoToProductName()");
    }

    protected void setupRdiPortMos(SectorEquipmentData[] sectorEquipments, Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "setupRdiPortMos()");
        for (int sectorIndex = 0; sectorIndex < sectorEquipments.length; ++sectorIndex) {
            for (int radioDotIndex = 0; radioDotIndex < sectorEquipments[sectorIndex].radioEquipment.radioDotUnits.length; ++radioDotIndex) {
                ManagedObject auxPiuRd = PlugInUnitFinder.findPlugInUnit(sectorEquipments[sectorIndex].radioEquipment.radioDotUnits[radioDotIndex].unitId, this.moRepositoryWrapper);
                String auxPiuLdnRd = auxPiuRd.getLocalDistinguishedName();
                this.setupRdiPortReference(auxPiuLdnRd, sectorEquipments[sectorIndex].radioEquipment.radioDotUnits[radioDotIndex].rdiPortRef, coordinator);
            }
        }
        logger.traceReturn(THIS_CLASS, "setupRdiPortMos()");
    }

    private void setupRdiPortReference(String auxPiuLdnRd, String rdRdiPortRefRdn, Coordinator coordinator) throws RbsConfigurationFailedException {
        String rdRdiPortLdn = auxPiuLdnRd + "," + "RdiPort" + "=" + "1";
        int finalSeparator = rdRdiPortRefRdn.lastIndexOf(45);
        String iruRdiPortId = rdRdiPortRefRdn.substring(finalSeparator + 1);
        int firstSeparator = rdRdiPortRefRdn.indexOf(45);
        int secondSeparator = rdRdiPortRefRdn.indexOf(45, firstSeparator + 1);
        int thirdSeparator = rdRdiPortRefRdn.indexOf(45, secondSeparator + 1);
        String rbsSubrackId = rdRdiPortRefRdn.substring(firstSeparator + 1, secondSeparator);
        String rbsSlotId = rdRdiPortRefRdn.substring(secondSeparator + 1, thirdSeparator);
        String iruRdn = rdRdiPortRefRdn.substring(0, finalSeparator);
        String iruLdn = "ManagedElement=1,Equipment=1,RbsSubrack=" + rbsSubrackId + "," + "RbsSlot" + "=" + rbsSlotId + "," + "AuxPlugInUnit" + "=" + iruRdn;
        String iruRdiPortLdn = iruLdn + "," + "RdiPort" + "=" + iruRdiPortId;
        if (iruRdiPortId != null) {
            ManagedObject rdRdiPort = this.moRepositoryWrapper.lookup(rdRdiPortLdn);
            if (rdRdiPort == null) {
                String slogan = "MO not found";
                String faultMsg = "Could not find the RdiPort to set reference on. LDN: " + rdRdiPortLdn + ".";
                throw new RbsConfigurationFailedException("MO not found", faultMsg);
            }
            ManagedObject iruRdiPort = this.moRepositoryWrapper.lookup(iruRdiPortLdn);
            if (iruRdiPort == null) {
                String slogan = "MO not found";
                String faultMsg = "Could not find the RdiPort to set reference on. LDN: " + iruRdiPortLdn + ".";
                throw new RbsConfigurationFailedException("MO not found", faultMsg);
            }
            ManagedObject rdReferencedRdiPort = iruRdiPort;
            ManagedObject iruReferencedRdiPort = rdRdiPort;
            try {
                rdRdiPort.setAttribute("remoteRdiPortRef", (Object)rdReferencedRdiPort, coordinator);
                iruRdiPort.setAttribute("remoteRdiPortRef", (Object)iruReferencedRdiPort, coordinator);
            }
            catch (MoAccessException mae) {
                String slogan = "Failed to update attribute";
                String faultMsg = "Could not set remote rdiport reference.";
                throw new RbsConfigurationFailedException("Failed to update attribute", "Could not set remote rdiport reference.", (Exception)((Object)mae));
            }
            RbsConfigurationReportLoggerFactory.getLogger().logAction("RdiPort", "set remoteRdiPortRef", new String[]{"from", "to  "}, new String[]{rdRdiPort.getLocalDistinguishedName(), rdReferencedRdiPort.getLocalDistinguishedName()});
            RbsConfigurationReportLoggerFactory.getLogger().logAction("RdiPort", "set remoteRdiPortRef", new String[]{"from", "to  "}, new String[]{iruRdiPort.getLocalDistinguishedName(), iruReferencedRdiPort.getLocalDistinguishedName()});
        }
    }

    protected void setupRiPortMos(SectorEquipmentData[] sectorEquipments, Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "setupRiPortMos()");
        for (int sectorIndex = 0; sectorIndex < sectorEquipments.length; ++sectorIndex) {
            for (int radioIndex = 0; radioIndex < sectorEquipments[sectorIndex].radioEquipment.radioUnits.length; ++radioIndex) {
                ManagedObject auxPiu = PlugInUnitFinder.findPlugInUnit(sectorEquipments[sectorIndex].radioEquipment.radioUnits[radioIndex].unitId, this.moRepositoryWrapper);
                String auxPiuLdn = auxPiu.getLocalDistinguishedName();
                Integer linkType = RbsConfigurationDefinitions.LINK_TYPE_CPRI;
                List riPorts = sectorEquipments[sectorIndex].radioEquipment.radioUnits[radioIndex].getRiPorts();
                for (int riPortIndex = 0; riPortIndex < riPorts.size(); ++riPortIndex) {
                    RiPortData riPort = (RiPortData)riPorts.get(riPortIndex);
                    this.setupReference(auxPiuLdn, riPort.getId(), riPort.getRef(), coordinator, linkType);
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "setupRiPortMos()");
    }

    private void setupReference(String parentLdn, String rdnValue, String port, Coordinator coordinator, Integer linkType) throws RbsConfigurationFailedException {
        String riPortLdn = parentLdn + "," + "RiPort" + "=" + rdnValue;
        String referencePort = port;
        if (referencePort != null) {
            ManagedObject riPort = this.moRepositoryWrapper.lookup(riPortLdn);
            if (riPort == null) {
                String slogan = "MO not found";
                String faultMsg = "Could not find the RiPort to set reference on. LDN: " + riPortLdn + ".";
                throw new RbsConfigurationFailedException("MO not found", faultMsg);
            }
            ManagedObject referencedRiPort = this.getRefPort(referencePort);
            if (referencedRiPort == null) {
                String slogan = "Referenced MO not found";
                String faultMsg = "Could not find the referenced RiPort(" + referencePort + ") for the " + "AuxPlugInUnit" + " with LDN: " + parentLdn + ".";
                throw new RbsConfigurationFailedException("Referenced MO not found", faultMsg);
            }
            ManagedObject riLinkMaoImpl1 = null;
            ManagedObject riLinkMaoImpl2 = null;
            try {
                riLinkMaoImpl1 = this.getRiLink(riPort, coordinator);
            }
            catch (NoSuchAttributeException e) {
                throw new RbsConfigurationFailedException("Cannot create RiLink", "Cannot get RiLink from RiPort: " + riPort.getLocalDistinguishedName());
            }
            catch (MoAccessException e) {
                throw new RbsConfigurationFailedException("Cannot create RiLink", "Cannot get RiLink from RiPort: " + riPort.getLocalDistinguishedName());
            }
            try {
                riLinkMaoImpl2 = this.getRiLink(referencedRiPort, coordinator);
            }
            catch (NoSuchAttributeException e) {
                throw new RbsConfigurationFailedException("Cannot create RiLink", "Cannot get RiLink from RiPort: " + referencedRiPort.getLocalDistinguishedName());
            }
            catch (MoAccessException e) {
                throw new RbsConfigurationFailedException("Cannot create RiLink", "Cannot get RiLink from RiPort: " + referencedRiPort.getLocalDistinguishedName());
            }
            if (riLinkMaoImpl1 != riLinkMaoImpl2 || riLinkMaoImpl1 == null) {
                ManagedObject equipment = this.moRepositoryWrapper.lookup("ManagedElement=1,Equipment=1");
                AttrListImpl attrList = new AttrListImpl();
                attrList.addElement("riPortRef1", (Object)referencedRiPort);
                attrList.addElement("riPortRef2", (Object)riPort);
                attrList.addElement("linkType", (Object)linkType);
                this.createMo("RiLink", equipment, String.valueOf(this.riLinkCounter), attrList, coordinator);
                ++this.riLinkCounter;
            }
        }
    }

    private ManagedObject getRiLink(ManagedObject riPortMaoImpl, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        ManagedObject[] reservedBy = (ManagedObject[])riPortMaoImpl.getAttribute(RESERVED_BY, coordinator);
        if (reservedBy != null) {
            for (int i = 0; i < reservedBy.length; ++i) {
                if (!"RiLink".equals(reservedBy[i].getType())) continue;
                return reservedBy[i];
            }
        }
        return null;
    }

    private ManagedObject createMo(String moType, ManagedObject parent, String identity, AttrListImpl attrList, Coordinator coordinator) throws RbsConfigurationFailedException {
        ManagedObject createdMo = null;
        MoFactory moFactory = this.findAndCheckFactory(moType);
        AttrListImpl attributeList = attrList == null ? new AttrListImpl() : attrList;
        try {
            createdMo = moFactory.createMo(parent, (AttrList)attributeList, identity, null, coordinator);
        }
        catch (MoAccessException mae) {
            logger.traceError(THIS_CLASS, "Could not create MO of type " + moType + " with id: " + identity);
            throw new RbsConfigurationFailedException("Create failed", "Could not create MO of type " + moType + " with id: " + identity, (Exception)((Object)mae));
        }
        this.logCreate(createdMo, attrList);
        return createdMo;
    }

    private void logCreate(ManagedObject anMo, AttrListImpl attrList) {
        String[] names = new String[attrList.size() + 1];
        Object[] values = new Object[attrList.size() + 1];
        for (int index = 0; index < attrList.size() + 1; ++index) {
            if (index == 0) {
                names[index] = "LDN";
                values[index] = anMo.getLocalDistinguishedName();
                continue;
            }
            names[index] = attrList.getName(index - 1);
            values[index] = attrList.getValue(index - 1);
        }
        RbsConfigurationReportLoggerFactory.getLogger().logAction(anMo.getType(), "create", names, values);
    }

    private MoFactory findAndCheckFactory(String moType) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "findAndCheckFactory() " + moType);
        MoFactory moFactory = this.genericMaoContext.getMoFactoryMgrWrapper().lookup(moType);
        if (moFactory == null) {
            throw new RbsConfigurationFailedException("MO factory not found", "Could not find MO factory for type " + moType + ".");
        }
        logger.traceReturn(THIS_CLASS, "findAndCheckFactory() " + moType);
        return moFactory;
    }

    protected void unlockAllCreatedMos(Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "unlockAllCreatedMos()");
        RbsConfigurationUnlockHelper.getInstance().unlockAllCreatedMos(coordinator);
        MoIterator rfPorts = this.moRepositoryWrapper.lookupType("rfPort");
        if (rfPorts != null) {
            while (rfPorts.hasMoreElements()) {
                ManagedObject rfPort = rfPorts.nextMo();
                try {
                    rfPort.setAttribute("administrativeState", (Object)RbsConfigurationDefinitions.ADMINISTRATIVE_STATE_UNLOCKED, coordinator);
                    RbsConfigurationReportLoggerFactory.getLogger().logAttribute(rfPort.getRelativeDistinguishedName(), "administrativeState", "UNLOCKED");
                }
                catch (MoAccessException mae) {
                    RbsConfigurationReportLoggerFactory.getLogger().logFailure("Failed to unlock", "Could not unlock the MO : " + rfPort.getLocalDistinguishedName() + " Please unlock this manually later! Reason: " + (Object)((Object)mae) + " " + RbsConfigurationFailedException.convertVariablesMessage(mae.getVariablesAsString()));
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "unlockAllCreatedMos()");
    }

    private ManagedObject getRefPort(String riportRef) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "getRefPort() " + riportRef);
        ManagedObject refPort = null;
        String parentLdn = null;
        int delimiter = 45;
        int lastIndexOfDelimiter = riportRef.lastIndexOf(45);
        String parentId = null;
        String riport = null;
        try {
            parentId = riportRef.substring(0, lastIndexOfDelimiter);
            riport = riportRef.substring(lastIndexOfDelimiter + 1, riportRef.length());
        }
        catch (IndexOutOfBoundsException iobe) {
            throw new RbsConfigurationFailedException("RiPort failure", "Could not configure RiPort: " + riportRef);
        }
        try {
            parentLdn = PlugInUnitFinder.findPlugInUnit(parentId, this.moRepositoryWrapper).getLocalDistinguishedName();
        }
        catch (RbsConfigurationFailedException rcfe) {
            String slogan = "RiPort failure";
            String faultMsg = "Could not configure RiPorts";
            throw new RbsConfigurationFailedException("RiPort failure", "Could not configure RiPorts", (Exception)((Object)rcfe));
        }
        refPort = this.moRepositoryWrapper.lookup(parentLdn + "," + "RiPort" + "=" + riport);
        logger.traceReturn(THIS_CLASS, "getRefPort() refPort: " + (refPort == null ? "null" : refPort.getLocalDistinguishedName()));
        return refPort;
    }

    public void setupIDL2RiPorts(DigitalEquipmentData digitalEquipmentData) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "setupIDL2RiPorts()");
        this.waiter.waitForSec(30);
        TransactionFactory transFact = TransactionServicesFactoryImpl.getInstance().getCppTransactionFactory();
        Control control = null;
        try {
            control = transFact.create(0);
            Coordinator coordinator = control.getCoordinator();
            try {
                for (int digitalUnitIndex = 0; digitalUnitIndex < digitalEquipmentData.getDigitalUnit().length; ++digitalUnitIndex) {
                    for (int riPortIndex = 0; riPortIndex < digitalEquipmentData.getDigitalUnit()[digitalUnitIndex].getRiPorts().size(); ++riPortIndex) {
                        RiPortData riPort = (RiPortData)digitalEquipmentData.getDigitalUnit()[digitalUnitIndex].getRiPorts().get(riPortIndex);
                        if (!digitalEquipmentData.checkIDL2Link(digitalEquipmentData.getDigitalUnit()[digitalUnitIndex].unitId, riPort)) {
                            String errMsg = "IDL2 link is not valid: the other end RiPort data does not match current DU " + digitalEquipmentData.getDigitalUnit()[digitalUnitIndex].unitId + " RiPortData (id,ref) (" + riPort.getId() + ", " + riPort.getRef() + ").";
                            logger.traceError(THIS_CLASS, errMsg);
                            throw new RbsConfigurationFailedException("Cannot setup IDL2 RiLink", errMsg);
                        }
                        ManagedObject piu = PlugInUnitFinder.findPlugInUnit(digitalEquipmentData.getDigitalUnit()[digitalUnitIndex].unitId, this.moRepositoryWrapper);
                        String piuLdn = piu.getLocalDistinguishedName();
                        Integer linkType = RbsConfigurationDefinitions.LINK_TYPE_IDL2;
                        this.setupReference(piuLdn, riPort.getId(), riPort.getRef(), coordinator, linkType);
                    }
                }
                try {
                    control.getTerminator().commit();
                }
                catch (InactiveTransactionException e) {
                    control.getTerminator().rollback();
                    throw new RbsConfigurationFailedException("Cannot setup IDL2 RiLink", e.getMessage());
                }
            }
            catch (RbsConfigurationFailedException e) {
                control.getTerminator().rollback();
                throw new RbsConfigurationFailedException("Cannot setup IDL2 RiLink", e.getMessage());
            }
        }
        catch (TransactionRolledBackException e) {
            throw new RbsConfigurationFailedException("Cannot setup IDL2 RiLink", e.getMessage());
        }
        catch (InactiveTransactionException e1) {
            throw new RbsConfigurationFailedException("Cannot setup IDL2 RiLink", e1.getMessage());
        }
        logger.traceReturn(THIS_CLASS, "setupIDL2RiPorts()");
    }

    public void setWaiter(IWaiter inWaiter) {
        this.waiter = inWaiter;
    }
}

