/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.datastructure;

import se.ericsson.crbs.cat.common.ArrayHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;

public class AntennaFeederCableData {
    public final transient String branch;
    public final transient int antennaSupervision;
    public final transient int[] dlAttenuation;
    public final transient int[] ulAttenuation;
    public final transient int[] electricalDlDelay;
    public final transient int[] electricalUlDelay;

    public AntennaFeederCableData(String branchIn, int antennaSupervisionIn, String dlAttenuationStringIn, String ulAttenuationStringIn, String electricalDlDelayStringIn, String electricalUlDelayStringIn) {
        this.branch = branchIn;
        this.antennaSupervision = antennaSupervisionIn;
        this.dlAttenuation = this.stringToIntArray("dlAttenuation", dlAttenuationStringIn);
        this.ulAttenuation = this.stringToIntArray("ulAttenuation", ulAttenuationStringIn);
        this.electricalDlDelay = this.stringToIntArray("electricalDlDelay", electricalDlDelayStringIn);
        this.electricalUlDelay = this.stringToIntArray("electricalUlDelay", electricalUlDelayStringIn);
    }

    private int[] stringToIntArray(String attributeName, String stringValue) {
        int[] intarr = null;
        try {
            intarr = ArrayHelper.stringToIntArray(stringValue, ",");
        }
        catch (NumberFormatException nfe) {
            RbsConfigurationReportLoggerFactory.getLogger().logInformation("Parser Information", "Not possible to parse AntennaFeederCable:" + attributeName + " from a string to an int array: " + stringValue + " Reason: " + nfe.getMessage());
        }
        return intarr;
    }
}

