/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.datastructure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.xml.sax.helpers.AttributesImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.ParserHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.datastructure.DigitalUnitData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.datastructure.InterPiuLinkData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.datastructure.RiPortData;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.xml.XMLElement;

public class DigitalEquipmentData {
    private static final Class THIS_CLASS = DigitalEquipmentData.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private DigitalUnitData[] digitalUnit;

    public DigitalEquipmentData(DigitalUnitData[] digitalUnitIn) {
        this.setDigitalUnit(digitalUnitIn);
    }

    public void createDigitalEquipment(Map typeElementMap) throws IOException {
        logger.traceEnter(THIS_CLASS, "createDigitalEquipment()");
        String xmlTag = "DigitalEquipment".toLowerCase(Locale.getDefault());
        if (typeElementMap.containsKey(xmlTag)) {
            List elements = (List)typeElementMap.get(xmlTag);
            if (elements.size() > 1) {
                throw new IOException("Invalid XML file: DigitalEquipment is out of bounds. Min: 0 Max: 1.");
            }
            if (elements.size() == 1) {
                ArrayList<DigitalUnitData> digitalUnits = new ArrayList<DigitalUnitData>();
                List xmlChildren = ((XMLElement)elements.get(0)).getChildren();
                for (int i = 0; i < xmlChildren.size(); ++i) {
                    String xmlTagRiPort;
                    String xmlTagInterPiuLink;
                    XMLElement element = (XMLElement)xmlChildren.get(i);
                    AttributesImpl attributes = element.getAttributes();
                    String val = attributes.getValue("unitId");
                    DigitalUnitData digitalUnitData = new DigitalUnitData(val);
                    List subElements = element.getChildren();
                    Map subElementMap = ParserHelper.createXmlTypeElementMap(subElements);
                    if (subElementMap.containsKey(xmlTagInterPiuLink = "InterPiuLink".toLowerCase(Locale.getDefault()))) {
                        List interPiuLinks = (List)subElementMap.get(xmlTagInterPiuLink);
                        for (int interPiuLinkIdx = 0; interPiuLinkIdx < interPiuLinks.size(); ++interPiuLinkIdx) {
                            XMLElement interPiuLink = (XMLElement)interPiuLinks.get(interPiuLinkIdx);
                            AttributesImpl interPiuLinkAttrs = interPiuLink.getAttributes();
                            String interPiuLinkRef = interPiuLinkAttrs.getValue("ref");
                            if (interPiuLinkRef == null) continue;
                            digitalUnitData.addInterPiuLink(new InterPiuLinkData(interPiuLinkRef));
                        }
                    }
                    if (subElementMap.containsKey(xmlTagRiPort = "RiPort".toLowerCase(Locale.getDefault()))) {
                        List riPorts = (List)subElementMap.get(xmlTagRiPort);
                        for (int riPortIdx = 0; riPortIdx < riPorts.size(); ++riPortIdx) {
                            XMLElement riPort = (XMLElement)riPorts.get(riPortIdx);
                            AttributesImpl riPortAttrs = riPort.getAttributes();
                            String riPortId = riPortAttrs.getValue("id");
                            String riPortRef = riPortAttrs.getValue("ref");
                            if (riPortId == null || riPortRef == null) continue;
                            digitalUnitData.addRiPort(new RiPortData(riPortId, riPortRef));
                        }
                    }
                    digitalUnits.add(digitalUnitData);
                }
                DigitalUnitData[] digitalUnitDatas = new DigitalUnitData[digitalUnits.size()];
                digitalUnits.toArray(digitalUnitDatas);
                this.setDigitalUnit(digitalUnitDatas);
            }
        }
        logger.traceReturn(THIS_CLASS, "createDigitalEquipment()");
    }

    public DigitalUnitData[] getDigitalUnit() {
        return this.digitalUnit;
    }

    public DigitalUnitData getDigitalUnitForId(String unitId) {
        DigitalUnitData unitData = null;
        for (int i = 0; i < this.digitalUnit.length; ++i) {
            if (!this.digitalUnit[i].unitId.equals(unitId)) continue;
            unitData = this.digitalUnit[i];
            break;
        }
        return unitData;
    }

    public void setDigitalUnit(DigitalUnitData[] inDigitalUnit) {
        this.digitalUnit = inDigitalUnit;
    }

    public boolean checkMultiDu() {
        boolean checkMulti = false;
        for (int i = 0; i < this.digitalUnit.length; ++i) {
            if (this.digitalUnit[i].unitId.equals("DU-1")) continue;
            checkMulti = true;
        }
        return checkMulti;
    }

    public boolean has3Dus() {
        boolean has3Dus = false;
        for (int i = 0; i < this.digitalUnit.length; ++i) {
            if (!this.digitalUnit[i].unitId.equals("DU-3")) continue;
            has3Dus = true;
        }
        return has3Dus;
    }

    public boolean checkIDL2Link(String duName, RiPortData riPort) {
        logger.traceEnter(THIS_CLASS, "checkIDL2Link()");
        boolean ret = false;
        String curRiPortId = riPort.getId();
        String curRiPortRef = riPort.getRef();
        int idx = curRiPortRef.lastIndexOf(45);
        String enderDuName = curRiPortRef.substring(0, idx);
        String enderRiPortId = curRiPortRef.substring(idx + 1);
        String enderRiPortRef = duName + "-" + curRiPortId;
        for (int i = 0; i < this.digitalUnit.length; ++i) {
            if (!this.digitalUnit[i].unitId.equals(enderDuName)) continue;
            List tmpRiPortList = this.digitalUnit[i].getRiPorts();
            for (int j = 0; j < tmpRiPortList.size(); ++j) {
                RiPortData tmpRiPort = (RiPortData)tmpRiPortList.get(j);
                if (!tmpRiPort.getId().equals(enderRiPortId) || !tmpRiPort.getRef().equals(enderRiPortRef)) continue;
                ret = true;
            }
        }
        logger.traceReturn(THIS_CLASS, "checkIDL2Link()");
        return ret;
    }

    public boolean checkInterPiuLinkToDU1(String duName) {
        for (int digitalUnitIndex = 0; digitalUnitIndex < this.digitalUnit.length; ++digitalUnitIndex) {
            DigitalUnitData curDU = this.digitalUnit[digitalUnitIndex];
            if (curDU.unitId.equals(duName) && curDU.getInterPiuLinks().isEmpty() && curDU.getRiPorts().isEmpty()) {
                return true;
            }
            if (!curDU.unitId.equals("DU-1")) continue;
            for (int interPiuLinkIndex = 0; interPiuLinkIndex < curDU.getInterPiuLinks().size(); ++interPiuLinkIndex) {
                InterPiuLinkData interPiuLink = (InterPiuLinkData)curDU.getInterPiuLinks().get(interPiuLinkIndex);
                if (!interPiuLink.getRef().equals(duName)) continue;
                return true;
            }
        }
        return false;
    }
}

