/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.smrs.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class SmrsInfoParser
extends DefaultHandler {
    private static final Class THIS_CLASS = SmrsInfoParser.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private String smrsUserName = "";
    private String smrsPassword = "";
    private String smrsServer = "";
    private String summaryFilePath = "";
    private boolean smrsInfoPresent = false;

    public String getSmrsUserName() {
        return this.smrsUserName;
    }

    public String getSmrsPassword() {
        return this.smrsPassword;
    }

    public String getSmrsServer() {
        return this.smrsServer;
    }

    public String getSummaryFilePath() {
        return this.summaryFilePath;
    }

    public boolean isSmrsInfoPresent() {
        return this.smrsInfoPresent;
    }

    public void parse(String xmlString) throws IOException {
        logger.traceEnter(THIS_CLASS, "parse(xmlString)");
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            ByteArrayInputStream bais = new ByteArrayInputStream(xmlString.getBytes());
            InputSource input = new InputSource(bais);
            saxParser.parse(input, (DefaultHandler)this);
            logger.traceGeneral(THIS_CLASS, "Received info: \"" + this.getLogInfo() + "\"");
        }
        catch (SAXException e) {
            throw new IOException(e.toString());
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.toString());
        }
        logger.traceReturn(THIS_CLASS, "parse(xmlString)");
    }

    public void startDocument() throws SAXException {
        this.smrsUserName = "";
        this.smrsPassword = "";
        this.smrsServer = "";
        this.summaryFilePath = "";
        this.smrsInfoPresent = false;
    }

    public void startElement(String namespaceUri, String localName, String qName, Attributes attributes) throws SAXException {
        logger.traceEnter(this.getClass(), "startElement(" + qName + ")");
        if ("SmrsInfo".equals(qName)) {
            this.smrsInfoPresent = true;
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.smrsUserName = attributes.getValue("smrsUserName");
                this.smrsPassword = attributes.getValue("smrsPassword");
                this.smrsServer = attributes.getValue("smrsServer");
                this.summaryFilePath = attributes.getValue("summaryFilePath");
            }
        }
        logger.traceReturn(this.getClass(), "startElement(" + qName + ")");
    }

    private String getLogInfo() {
        return "SMRS user name: \"" + this.smrsUserName + "\", SMRS server: \"" + this.smrsServer + "\", Summary file path: \"" + this.summaryFilePath;
    }
}

