/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state;

import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationContext;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ProgressReportHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.StateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.StateHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.StateHandlerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.StateHolder;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public abstract class AbstractStateExecutor
implements StateExecutor {
    private static final Class THIS_CLASS = AbstractStateExecutor.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected final String executorName;
    protected StateHolder stateHolder = null;
    protected final ProgressReportHandler progressReportHandler;
    protected RbsConfigurationMao rbsConfigurationMao;
    protected final RbsConfigurationContext rbsConfigurationContext;
    protected final MoRepositoryWrapper moRepositoryWrapper;
    protected final MoFactoryMgrWrapper moFactoryMgrWrapper;
    protected final RbsConfigurationHelper helper;
    protected final StateHandler stateHandler;

    public AbstractStateExecutor(String inExecutorName, RbsConfigurationMao inRbsConfigurationMao, boolean continueWithNextStep, int nextState) {
        logger.traceEnter(THIS_CLASS, "AbstractStateExecutor(" + inExecutorName + ")");
        this.executorName = inExecutorName;
        this.rbsConfigurationMao = inRbsConfigurationMao;
        this.rbsConfigurationContext = inRbsConfigurationMao.getRbsConfigurationContext();
        this.helper = (RbsConfigurationHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationHelper.class);
        this.moRepositoryWrapper = this.rbsConfigurationContext.getGenericMaoContext().getMoRepositoryWrapper();
        this.moFactoryMgrWrapper = inRbsConfigurationMao.getRbsConfigurationContext().getGenericMaoContext().getMoFactoryMgrWrapper();
        this.progressReportHandler = ProgressReportHandler.getInstance();
        this.stateHandler = StateHandlerFactory.getInstance().getStateHandler(inRbsConfigurationMao);
        this.stateHolder = new StateHolder(continueWithNextStep, nextState);
        logger.traceReturn(THIS_CLASS, "AbstractStateExecutor(" + inExecutorName + ")");
    }

    public String getExecutorName() {
        return this.executorName;
    }

    public final StateHolder getStateHolder() {
        logger.traceEnter(THIS_CLASS, "getStateHolder()");
        logger.traceGeneral(THIS_CLASS, "State for \"" + this.executorName + "\" is: " + this.stateHolder);
        logger.traceReturn(THIS_CLASS, "getStateHolder()");
        return this.stateHolder;
    }

    public abstract void execute();

    public boolean prepareNodeRestart() {
        logger.traceEnter(THIS_CLASS, "prepareNodeRestart()");
        boolean result2 = true;
        logger.traceReturn(THIS_CLASS, "prepareNodeRestart() true");
        return true;
    }

    protected void updateProgressReportInformation(int integrationStepNumber, int status, String detailedInformation, boolean updateProgressReport) {
        this.progressReportHandler.updateProgressReportInformation(integrationStepNumber, status, detailedInformation, updateProgressReport);
    }

    protected void updateProgressReportInformation(int integrationStepNumber, int status, String detailedInformation, boolean updateProgressReport, Coordinator coordinator) {
        this.progressReportHandler.updateProgressReportInformation(integrationStepNumber, status, detailedInformation, updateProgressReport, coordinator);
    }
}

