/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state;

import se.ericsson.cello.ipsec.IpSecMo;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.AbstractStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.StateHolder;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.transactions.TransactionServicesFactoryImpl;

public class ActivateIpSecurityStateExecutor
extends AbstractStateExecutor {
    private static final Class THIS_CLASS = ActivateIpSecurityStateExecutor.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public ActivateIpSecurityStateExecutor(RbsConfigurationMao inRbsConfigurationMao) {
        super(THIS_CLASS.getName(), inRbsConfigurationMao, true, 72);
    }

    public void execute() {
        logger.traceEnter(THIS_CLASS, "execute()");
        boolean successful = true;
        if (this.useIpSecurity()) {
            this.updateProgressReportInformation(1450, 3, "The step Activate IP Security has been started.", true);
            successful = this.activateIpSecurity();
            if (successful) {
                this.updateProgressReportInformation(1450, 5, "The step Activate IP Security is successfully finished.", true);
            }
        } else {
            this.updateProgressReportInformation(1450, 2, "Ip security is not configured to be used.", true);
        }
        this.stateHolder = successful ? new StateHolder(true, 60) : new StateHolder(true, 21);
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    private boolean useIpSecurity() {
        boolean useIpSecurity = false;
        Integer wantedIpSecLevel = (Integer)this.rbsConfigurationMao.retrievePersistently("wantedIpSecLevel");
        if (wantedIpSecLevel != null && wantedIpSecLevel != 0) {
            useIpSecurity = true;
        }
        return useIpSecurity;
    }

    private boolean activateIpSecurity() {
        logger.traceEnter(THIS_CLASS, "activateIpSecurity()");
        boolean successful = false;
        while (true) {
            try {
                TransactionFactory transFact = TransactionServicesFactoryImpl.getInstance().getCppTransactionFactory();
                Control control = transFact.create(1000);
                Coordinator coordinator = control.getCoordinator();
                try {
                    successful = this.doActivateIpSecurity(coordinator);
                    control.getTerminator().commit();
                }
                catch (MoAccessException mae) {
                    control.getTerminator().rollback();
                    String faultMessage = ExceptionHelper.getExceptionMessage((Throwable)mae);
                    this.handleFault(faultMessage, ExceptionHelper.appendReason((String)"Activation of Ip security failed.", (Throwable)mae));
                }
            }
            catch (TransactionRolledBackException e) {
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UNDEFINED, "Transaction failure", "Transaction failure. Retrying");
                continue;
            }
            catch (InactiveTransactionException e) {
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UNDEFINED, "Transaction failure", "Transaction failure. Retrying");
                continue;
            }
            break;
        }
        logger.traceReturn(THIS_CLASS, "activateIpSecurity()");
        return successful;
    }

    private boolean doActivateIpSecurity(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "doActivateIpSecurity");
        boolean successful = false;
        ManagedObject ipSecMo = this.getIpSecMo();
        boolean licenseIsEnabled = this.isLicenseEnabled(ipSecMo, coordinator);
        boolean certificateIsInstalled = this.isCertificateInstalled(ipSecMo, coordinator);
        if (licenseIsEnabled && certificateIsInstalled) {
            ipSecMo.setAttribute("featureState", (Object)RbsConfigurationDefinitions.ACTIVATED, coordinator);
            successful = true;
        } else {
            String faultMessage = licenseIsEnabled ? "Certificate is not installed." : "License is not enabled.";
            this.handleFault(faultMessage, "Activation of Ip security failed. " + faultMessage);
        }
        logger.traceReturn(THIS_CLASS, "doActivateIpSecurity");
        return successful;
    }

    private ManagedObject getIpSecMo() throws MoNotFoundException {
        ManagedObject ipSecMo = this.moRepositoryWrapper.lookup("ManagedElement=1,IpSystem=1,IpSec=1");
        if (ipSecMo == null) {
            throw new MoNotFoundException("IpSec MO not found.");
        }
        return ipSecMo;
    }

    private boolean isLicenseEnabled(ManagedObject ipSecMo, Coordinator coordinator) throws MoAccessException {
        boolean enabled = true;
        Integer licenseState = (Integer)ipSecMo.getAttribute("licenseState", coordinator);
        boolean licenseIsEnabled = licenseState == null ? false : licenseState == 1;
        return licenseIsEnabled;
    }

    private boolean isCertificateInstalled(ManagedObject ipSecMoIn, Coordinator coordinator) throws MoAccessException {
        Struct certificate = (Struct)ipSecMoIn.getAttribute("certificate", coordinator);
        boolean certificateIsInstalled = false;
        if (certificate != null && RbsConfigurationHelper.existsAndNotEmpty((String)certificate.getValue("serialNumber"))) {
            certificateIsInstalled = true;
        } else if (ipSecMoIn instanceof IpSecMo) {
            IpSecMo ipSecMo = (IpSecMo)ipSecMoIn;
            long vendorCredentials = ipSecMo.getVendorCredentials(coordinator);
            String errorMessage = ipSecMo.getCertEnrollErrorMsg(coordinator);
            int enrollState = ipSecMo.getCertEnrollState(coordinator);
            if (vendorCredentials == 1L && enrollState == 0 && (errorMessage == null || errorMessage.length() == 0)) {
                certificateIsInstalled = true;
            }
        }
        return certificateIsInstalled;
    }

    private void handleFault(String faultMessage, String progressReportMessage) {
        logger.traceError(THIS_CLASS, "Failed to activate Ip security. Reason: " + faultMessage);
        this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_PERMANENT_IPSEC_FOR_OAM_ACTIVATION_FAULT, "Activation of Ip security failed.", faultMessage);
        this.updateProgressReportInformation(1450, 4, progressReportMessage, true);
    }
}

