/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state;

import java.io.IOException;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.geolocationcheck.GeoLocationCheckHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.geolocationcheck.GeoLocationCheckHandlerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.NodeAddressChangeParamsHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.RbsConfigurationSiteBasic;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.RbsConfigurationSiteBasicFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.AbstractStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.StateHolder;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionHandler;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.security.cppsec.esa.ExpressSecurityActivation;

public class ActivateSiteBasicStateExecutor
extends AbstractStateExecutor {
    private static final Class THIS_CLASS = ActivateSiteBasicStateExecutor.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final ExpressSecurityActivation esa;
    private final Object esaLock;

    public ActivateSiteBasicStateExecutor(RbsConfigurationMao inRbsConfigurationMao, ExpressSecurityActivation aEsa, Object aEsaLock) {
        super(THIS_CLASS.getName(), inRbsConfigurationMao, true, 60);
        this.rbsConfigurationMao = inRbsConfigurationMao;
        this.esaLock = aEsaLock;
        this.esa = aEsa;
    }

    public void execute() {
        logger.traceEnter(THIS_CLASS, "execute()");
        RbsConfigurationSiteBasic siteBasic = RbsConfigurationSiteBasicFactory.getInstance().getRbsConfigurationSiteBasic(this.rbsConfigurationMao, false, this.esa, this.esaLock);
        TransactionHandler.runWithLoopWithoutException(siteBasic);
        TransactionHandler.runWithLoopWithoutException(siteBasic);
        TransactionHandler.runWithLoopWithoutException(siteBasic);
        try {
            NodeAddressChangeParamsHandler.storeNodeAddressChangeParams(this.rbsConfigurationMao);
        }
        catch (MoAccessException e) {
            logger.traceDebug(THIS_CLASS, "Fail to store Node Address Change Parameters");
        }
        catch (IOException e) {
            logger.traceDebug(THIS_CLASS, "Fail to get SiteBasic File");
        }
        GeoLocationCheckHandler geoLocationCheckHandler = GeoLocationCheckHandlerFactory.getInstance().getGeoLocationCheckHandler(3, this.rbsConfigurationMao);
        if (geoLocationCheckHandler != null) {
            geoLocationCheckHandler.start();
        }
        this.stateHolder = new StateHolder(true, 71);
        logger.traceReturn(THIS_CLASS, "execute()");
    }
}

