/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationSmrsHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.isi.RbsConfigurationIsiHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.FileParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.SecurityParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.AbstractStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.StateHolder;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class FetchFilesStateExecutor
extends AbstractStateExecutor {
    private static final Class THIS_CLASS = FetchFilesStateExecutor.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private String rootPrefix = "";

    public FetchFilesStateExecutor(RbsConfigurationMao inRbsConfigurationMao) {
        super(THIS_CLASS.getName(), inRbsConfigurationMao, true, 21);
    }

    public void execute() {
        logger.traceEnter(THIS_CLASS, "execute()");
        this.restoreAutoIntegrationParametersIfNlhExists();
        try {
            RbsConfigurationSmrsHelper smrsHelper = (RbsConfigurationSmrsHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationSmrsHelper.class);
            smrsHelper.getAndProcessSummaryFile();
            if (this.isIsiEnabled() && !this.isIsiComplete()) {
                this.stateHolder = new StateHolder(true, 25);
            } else {
                this.updateProgressReportInformation(450, 2, "Installing Integration Basic Package", true);
                this.stateHolder = new StateHolder(true, 30);
            }
        }
        catch (RbsConfigurationFailedException rcfe) {
            String errorMsg = ExceptionHelper.appendReason((String)"SMRS info has been lost.", (Throwable)((Object)rcfe));
            this.updateProgressReportInformation(300, 4, errorMsg, false);
            this.updateProgressReportInformation(400, 4, errorMsg, false);
            this.updateProgressReportInformation(1500, 4, errorMsg, false);
            this.updateProgressReportInformation(900, 4, errorMsg, true);
            this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_SMRS_CONNECTION_FAULT, "Missing information", errorMsg);
            this.stateHolder = new StateHolder(true, 21);
        }
        catch (NoClassDefFoundError exc) {
            String errorMsg = "Faulty SummaryFile";
            logger.traceGeneral(THIS_CLASS, "NoClassDefFoundError " + exc.getMessage());
            if (exc.getMessage().equalsIgnoreCase("java.sql.SQLException")) {
                logger.traceGeneral(THIS_CLASS, "Error parsing Summary XML file");
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_SUMMARY_FILE_FAULT, "ErroneousInput", "Faulty SummaryFile");
                this.stateHolder = new StateHolder(true, 21);
            }
            throw exc;
        }
        this.decideIfToActivateSecurity();
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    public void decideIfToActivateSecurity() {
        logger.traceEnter(THIS_CLASS, "decideIfToActivateSecurity()");
        boolean activateSecurity = SecurityParameters.instance(this.rbsConfigurationMao).getActivateSecurityAsBoolean();
        String localIscf = SecurityParameters.instance().getLocalInitialSecurityConfigurationFile();
        logger.traceDebug(THIS_CLASS, "decideIfToActivateSecurity() localIscf: " + localIscf + ", activateSecurity:" + activateSecurity);
        if (localIscf.trim().length() == 0) {
            SecurityParameters.instance().setActivateSecurity("false");
        } else {
            File localIscfFile = new File(localIscf);
            if (localIscfFile.exists()) {
                SecurityParameters.instance().setActivateSecurity("true");
            } else {
                SecurityParameters.instance().setActivateSecurity("false");
            }
        }
        logger.traceReturn(THIS_CLASS, "decideIfToActivateSecurity() activateSecurity: " + SecurityParameters.instance(this.rbsConfigurationMao).getActivateSecurity());
    }

    private void restoreAutoIntegrationParametersIfNlhExists() {
        if (this.nlhExists()) {
            RbsConfigurationIsiHelper isiHelper = (RbsConfigurationIsiHelper)this.rbsConfigurationMao.getRbsConfigurationContext().getHelper(RbsConfigurationIsiHelper.class);
            try {
                isiHelper.restoreAutoIntegrationParameters(this.rootPrefix + "/c/systemfiles/lte/autointegration/Nlh.xml");
            }
            catch (IOException ioe) {
                logger.traceError(THIS_CLASS, "Failure while Network Loader trying to restore AutoIntegration Parameters: " + ioe.getMessage(), (Throwable)ioe);
            }
            catch (GeneralSecurityException se) {
                logger.traceError(THIS_CLASS, "Failure while Network Loader trying to decrypt nlh.xml: " + se.getMessage(), (Throwable)se);
            }
            FileParameters.instance(this.rbsConfigurationMao).setNodeSelfConfigurationMode("InitialSoftwareInstallationPerformed");
        } else {
            FileParameters.instance(this.rbsConfigurationMao).setNodeSelfConfigurationMode("InitialSoftwareInstallationNotPerformed");
        }
    }

    private boolean nlhExists() {
        File nlhFile = new File(this.rootPrefix + "/c/systemfiles/lte/autointegration/Nlh.xml");
        return nlhFile.exists() && nlhFile.isFile();
    }

    protected void setUnitTestRootPrefix(String prefix) {
        this.rootPrefix = prefix;
    }

    protected String getUnitTestRootPrefix() {
        return this.rootPrefix;
    }

    private boolean isIsiEnabled() {
        FileParameters fileParemeters = FileParameters.instance(this.rbsConfigurationMao);
        String name = fileParemeters.getIntegrationBasicPackageFilePath();
        return name != null && name.indexOf(".") > 0;
    }

    private boolean isIsiComplete() {
        boolean result2 = false;
        File nlh = new File("/c/systemfiles/lte/autointegration/Nlh.xml");
        if (nlh.isFile() && nlh.length() > 0L) {
            result2 = true;
        }
        return result2;
    }
}

