/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state;

import java.io.File;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.crbs.cat.mao.nodeaddresschange.MoRepositoryHelper;
import se.ericsson.crbs.cat.mao.nodeaddresschange.NodeAddressChangeParams;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationIpHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationIpHelperImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.isi.RbsConfigurationIsiHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.OssInformer;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.OssInformerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.NodeAddressChangeParamsHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.AbstractStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.StateHolder;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.transactions.TransactionServicesFactoryImpl;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class InformOssStateExecutor
extends AbstractStateExecutor {
    private static final Class THIS_CLASS = InformOssStateExecutor.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final int TX_TIMEOUT = 0;
    private final TransactionFactory transFact;
    private final boolean normalStartUp;

    public InformOssStateExecutor(boolean inNormalStartUp, RbsConfigurationMao inRbsConfigurationMao) {
        super(THIS_CLASS.getName(), inRbsConfigurationMao, !inNormalStartUp, inNormalStartUp ? 110 : 80);
        this.normalStartUp = inNormalStartUp;
        this.transFact = TransactionServicesFactoryImpl.getInstance().getCppTransactionFactory();
    }

    public void execute() {
        logger.traceEnter(THIS_CLASS, "execute(normalStartup), - " + this.normalStartUp);
        this.updateProgressReportInformation(2300, 3, "Informing OSS that the RBS is up and running", true);
        try {
            this.rbsConfigurationMao.storePersistently("informOss", "STARTED");
            logger.traceGeneral(THIS_CLASS, "The attribute informOss has been successfully stored with the value STARTED persistently.");
        }
        catch (MoAccessException ignore) {
            logger.traceError(THIS_CLASS, "Could not store the attribute informOss with the value STARTED persistently.");
        }
        this.loopOverTransactionErrors();
        File nlhFile = new File("/c/systemfiles/lte/autointegration/Nlh.xml");
        if (nlhFile.exists()) {
            RbsConfigurationIsiHelper isiHelper = (RbsConfigurationIsiHelper)this.rbsConfigurationMao.getRbsConfigurationContext().getHelper(RbsConfigurationIsiHelper.class);
            isiHelper.cleanEncryptedFilesAndRollbackFile("");
        }
        boolean doContinue = !this.normalStartUp;
        int nextState = 110;
        if (doContinue) {
            nextState = 90;
        }
        this.stateHolder = new StateHolder(doContinue, nextState);
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loopOverTransactionErrors() {
        logger.traceEnter(THIS_CLASS, "loopOverTransactionErrors()");
        while (true) {
            String outerErrorMsg = "";
            try {
                Control control = this.transFact.create(0);
                boolean informingOssSuccessfull = this.tryInformOss(control);
                if (informingOssSuccessfull) {
                    break;
                }
            }
            catch (TransactionRolledBackException e) {
                outerErrorMsg = "Transaction failure. Retrying.";
            }
            catch (InactiveTransactionException e) {
                outerErrorMsg = "Transaction failure. Retrying.";
            }
            finally {
                if (!outerErrorMsg.equalsIgnoreCase("")) {
                    this.updateProgressReportInformation(2300, 4, outerErrorMsg, true);
                    this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UNDEFINED, "Inform OSS failure!", outerErrorMsg);
                }
            }
            this.helper.waitForRetry(this.executorName + ".execute()");
        }
        logger.traceReturn(THIS_CLASS, "loopOverTransactionErrors()");
    }

    private boolean tryInformOss(Control control) throws InactiveTransactionException {
        String innerErrorMsg = "";
        boolean informingOssSuccessfull = false;
        try {
            if (!this.normalStartUp) {
                this.helper.setRbsProgressInformation(RbsConfigurationDefinitions.RBS_PI_NOTIFYING_OSS);
            }
            this.doInformOss(control);
            informingOssSuccessfull = true;
        }
        catch (MoAccessException mae) {
            control.getTerminator().rollback();
            innerErrorMsg = "OSS NodeDiscovery failed, no OAM Ip address found! Retrying.";
        }
        catch (Exception exception) {
            control.getTerminator().rollback();
            logger.traceDebug(THIS_CLASS, "innerErrorMsg: " + innerErrorMsg + ". Exception: " + ExceptionHelper.convertToString((Throwable)exception));
            innerErrorMsg = "OSS NodeDiscovery failed! Retrying.";
        }
        if (!innerErrorMsg.equalsIgnoreCase("")) {
            this.updateProgressReportInformation(2300, 4, innerErrorMsg, true);
            this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_OSS_CONNECTION_FAULT, "Hello failed!", innerErrorMsg);
        }
        return informingOssSuccessfull;
    }

    private void doInformOss(Control control) throws MoAccessException, TransactionRolledBackException, InactiveTransactionException {
        logger.traceEnter(THIS_CLASS, "doInformOss()");
        Coordinator coordinator = control.getCoordinator();
        RbsConfigurationIpHelper ipHelper = (RbsConfigurationIpHelper)((Object)this.rbsConfigurationContext.getHelper(RbsConfigurationIpHelperImpl.class));
        String rbsIpAddress = ipHelper.getOamIpAddress(coordinator);
        String[] ipAddressesToCheck = new String[]{rbsIpAddress};
        boolean configurationModeIKE = MoRepositoryHelper.hasDynamicConfigurationMode((MoRepositoryWrapper)this.rbsConfigurationContext.getMoRepositoryWrapper(), (String[])ipAddressesToCheck, (int)0);
        boolean configurationModeDhcp = !configurationModeIKE && MoRepositoryHelper.hasDynamicConfigurationMode((MoRepositoryWrapper)this.rbsConfigurationContext.getMoRepositoryWrapper(), (String[])ipAddressesToCheck, (int)1);
        OssInformer ossInformer = OssInformerFactory.createOssInformer(this.rbsConfigurationContext);
        if (!this.normalStartUp && (configurationModeDhcp || configurationModeIKE)) {
            this.callNodeSecurityAddressChanged(rbsIpAddress, ossInformer);
        } else if (this.normalStartUp && configurationModeDhcp) {
            this.callNodeAddressChanged(rbsIpAddress, ossInformer);
        } else if (this.normalStartUp && configurationModeIKE) {
            this.callNodeSecurityAddressChanged(rbsIpAddress, ossInformer);
        } else if (this.normalStartUp) {
            this.callNodeUp(rbsIpAddress, ossInformer);
        } else {
            this.callNodeSecurityUp(rbsIpAddress, ossInformer);
        }
        control.getTerminator().commit();
        logger.traceReturn(THIS_CLASS, "doInformOss()");
    }

    private void callNodeUp(String rbsIpAddress, OssInformer ossInformer) {
        logger.traceEnter(THIS_CLASS, "callNodeUp()");
        ossInformer.informOss(null, rbsIpAddress);
        logger.traceReturn(THIS_CLASS, "callNodeUp()");
    }

    private void callNodeAddressChanged(String rbsIpAddress, OssInformer ossInformer) {
        logger.traceEnter(THIS_CLASS, "callNodeAddressChanged()");
        String siteBasicNodeId = (String)this.rbsConfigurationMao.retrievePersistently("nodeIdValue");
        String rbsDn = siteBasicNodeId != null && siteBasicNodeId.length() > 0 ? siteBasicNodeId : this.rbsConfigurationMao.getNamePrefix();
        ossInformer.informOss(rbsDn, rbsIpAddress);
        logger.traceReturn(THIS_CLASS, "callNodeAddressChanged()");
    }

    private void callNodeSecurityUp(String rbsIpAddress, OssInformer ossInformer) {
        logger.traceEnter(THIS_CLASS, "callNodeSecurityUp()");
        NodeAddressChangeParams params = NodeAddressChangeParamsHandler.getNodeAddressChangeParams(this.rbsConfigurationMao);
        params.setIpAddress(rbsIpAddress);
        ossInformer.nodeSecurityUp(params.getIpAddress(), params.getSshKey(), params.getInstallerName(), params.getWantedSecLevel(), params.getMinimumSecLevel(), params.getReachedSecLevel(), params.getSecurityChecksums(), params.getSecurityChecksumVersion(), params.getOamCertSerNo(), params.getOamCertFingerPrint(), params.getWantedIpSecLevel(), params.getReachedIpSecLevel(), params.getiPSecCUSCertSerNo(), params.getiPSecCUSCertFingerPrint());
        logger.traceReturn(THIS_CLASS, "callNodeSecurityUp()");
    }

    private void callNodeSecurityAddressChanged(String rbsIpAddress, OssInformer ossInformer) {
        logger.traceEnter(THIS_CLASS, "callNodeSecurityAddressChanged()");
        NodeAddressChangeParams params = NodeAddressChangeParamsHandler.getNodeAddressChangeParams(this.rbsConfigurationMao);
        params.setIpAddress(rbsIpAddress);
        ossInformer.nodeSecurityAddressChanged(params.getDn(), params.getIpAddress(), params.getSshKey(), params.getInstallerName(), params.getWantedSecLevel(), params.getMinimumSecLevel(), params.getReachedSecLevel(), params.getSecurityChecksums(), params.getSecurityChecksumVersion(), params.getOamCertSerNo(), params.getOamCertFingerPrint(), params.getWantedIpSecLevel(), params.getReachedIpSecLevel(), params.getiPSecCUSCertSerNo(), params.getiPSecCUSCertFingerPrint());
        logger.traceReturn(THIS_CLASS, "callNodeSecurityAddressChanged()");
    }
}

