/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state;

import java.io.File;
import se.ericsson.crbs.cat.common.FileHelper;
import se.ericsson.crbs.cat.common.ZipFileHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.isi.IsiHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.FileParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.AbstractStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.StateHolder;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.RestartNodeTp;
import se.ericsson.crbs.common.FileHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class InitialSoftwareInstallationStateExecutor
extends AbstractStateExecutor {
    private static final Class THIS_CLASS = InitialSoftwareInstallationStateExecutor.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public InitialSoftwareInstallationStateExecutor(RbsConfigurationMao inRbsConfigurationMao) {
        super(THIS_CLASS.getName(), inRbsConfigurationMao, true, 25);
        FileParameters.instance(this.rbsConfigurationMao).setIntegrationBasicPackageFileExtractPath(RbsConfigurationDefinitions.ISI_TEMP_PATH);
    }

    public void execute() {
        logger.traceEnter(THIS_CLASS, "execute()");
        this.updateProgressReportInformation(450, 3, "Installing Integration Basic Package", true);
        this.prepareRollback(RbsConfigurationDefinitions.ISI_BACKUP_C);
        RbsConfigurationReportLoggerFactory.getLogger().logInformation("Network Loader", "Installing Integration Basic Package");
        try {
            FileParameters fileParameters = FileParameters.instance(this.rbsConfigurationMao);
            logger.traceDebug(THIS_CLASS, "Unzip IHBP from " + fileParameters.getIntegrationBasicPackageFilePath() + " to directory " + fileParameters.getIntegrationBasicPackageFileExtractPath());
            ZipFileHelper.unzipFile((String)fileParameters.getIntegrationBasicPackageFilePath(), (String)fileParameters.getIntegrationBasicPackageFileExtractPath());
        }
        catch (FileHelper.FileException e) {
            logger.traceAbnormal(THIS_CLASS, "Failed to unzip IHBP file due to exception: " + e.getMessage());
            this.rollBack();
        }
        IsiHandler isiHandler = new IsiHandler(this.rbsConfigurationMao);
        try {
            isiHandler.execute();
        }
        catch (RbsConfigurationFailedException e) {
            logger.traceDebug(THIS_CLASS, "Installation of Integration Basic Package Failed: " + e.getMessage());
            this.rollBack();
        }
        this.updateProgressReportInformation(450, 5, "Installing Integration Basic Package", true);
        RbsConfigurationReportLoggerFactory.getLogger().logInformation("Initial Software Installation Complete", "Restart Node and start Node Self Configuration");
        RbsConfigurationReportLoggerFactory.getLogger().flushLogEntryBufferToFile();
        try {
            this.restartNode();
        }
        catch (RbsConfigurationFailedException e) {
            logger.traceDebug(THIS_CLASS, "Node Restart Failed: " + e.getMessage());
            this.rollBack();
        }
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    private void prepareRollback(String backupStorageC) {
        logger.traceEnter(THIS_CLASS, "prepareRollback() StorageC:" + backupStorageC);
        File cBackup = new File(RbsConfigurationDefinitions.HARD_DISK_C + RbsConfigurationDefinitions.BACKUP_FOLDER);
        if (!cBackup.exists() && !cBackup.mkdir()) {
            logger.info(THIS_CLASS, "Fail to create " + RbsConfigurationDefinitions.HARD_DISK_C + RbsConfigurationDefinitions.BACKUP_FOLDER);
        }
        logger.traceReturn(THIS_CLASS, "prepareRollback()");
    }

    private void rollBack() {
        this.updateProgressReportInformation(450, 0, "Installing Integration Basic Package", true);
        try {
            FileHelper.deleteFilesInDirectory(new File(RbsConfigurationDefinitions.ISI_TEMP_PATH));
        }
        catch (FileHelper.FileException e) {
            logger.traceDebug(THIS_CLASS, "Failed to remove :" + RbsConfigurationDefinitions.ISI_TEMP_PATH);
        }
        this.stateHolder = new StateHolder(true, 21);
    }

    private void restartNode() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "restartNode()");
        String restartInfo = "Node restart to switch to Integration Basic Package CV.";
        TransactionHandler.run(new RestartNodeTp(this.rbsConfigurationMao, new Integer(2), new Integer(0), restartInfo, "Node restart"));
        logger.traceReturn(THIS_CLASS, "restartNode()");
    }
}

