/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.security.GeneralSecurityException;
import se.ericsson.cello.cns.VendorCredentialsException;
import se.ericsson.cello.cns.VendorCredentialsMgr;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.swmanagement.ConfigurationVersionMo;
import se.ericsson.crbs.cat.common.FileHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.actions.ClientTimeSetter;
import se.ericsson.crbs.cat.mao.rbsconfiguration.isi.RbsConfigurationIsiHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.npc.transactionpackages.SetLogicalNameTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.FileParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.NodeParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.SecurityParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.StateMachineParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ProgressReportFileHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.security.FileEncryptor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.CreateIpSecMo;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.AbstractStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.StateHolder;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.fetchsiteinstallation.SiteInstallationFileParser;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.initialcv.InitialAiCv;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.initialcv.InitialAiCvFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionHandler;
import se.ericsson.crbs.common.FileHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class IntegrationNotStartedStateExecutor
extends AbstractStateExecutor {
    private static final Class THIS_CLASS = IntegrationNotStartedStateExecutor.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private ProgressReportFileHandler progressReportFileHandler;
    private RbsConfigurationIsiHelper isiHelper;
    private String prefix = "";

    public IntegrationNotStartedStateExecutor(RbsConfigurationMao inRbsConfigurationMao) {
        super(THIS_CLASS.getName(), inRbsConfigurationMao, false, 0);
        this.progressReportFileHandler = inRbsConfigurationMao.getProgressReportFileHandler();
    }

    public void execute() {
        block17: {
            logger.traceEnter(THIS_CLASS, "execute()");
            CreateIpSecMo ipSecMoCreator = new CreateIpSecMo(this.moRepositoryWrapper, this.moFactoryMgrWrapper);
            ipSecMoCreator.create();
            try {
                if (!this.isInConfigLevelBasicCv() || !this.hasVendorCredentials() || this.isCancelledByUser() || this.isIpStackConfigured()) break block17;
                SecurityParameters.instance(this.rbsConfigurationMao).setActivateSecurity("true");
                SecurityParameters.instance().setActivateIpSecurity("true");
                this.setIntegrationLogFilePathAndStartlog();
                this.updateNodeUtcTime();
                this.isiHelper = (RbsConfigurationIsiHelper)this.rbsConfigurationMao.getRbsConfigurationContext().getHelper(RbsConfigurationIsiHelper.class);
                String nlhFilePath = this.prefix + "/c/systemfiles/lte/autointegration/Nlh.xml";
                File nlhFile = new File(nlhFilePath);
                if (nlhFile.exists()) {
                    ConfigurationVersionMo currentCV = this.isiHelper.getCvMo(this.rbsConfigurationMao);
                    String currentCvName = currentCV.getExecutingCv(null);
                    String rollBackCv = "basic_cv";
                    try {
                        rollBackCv = this.isiHelper.getNlRollBackCv(nlhFile.getPath());
                        logger.traceDebug(THIS_CLASS, "Network Loader Rollback CV: " + rollBackCv);
                    }
                    catch (IOException ioe) {
                        logger.traceDebug(THIS_CLASS, "Fail to get Network Loader Rollback CV: " + nlhFile.getPath());
                    }
                    catch (GeneralSecurityException se) {
                        logger.traceDebug(THIS_CLASS, "Fail to decrypt file: " + nlhFile.getPath());
                    }
                    if (!rollBackCv.equalsIgnoreCase(currentCvName)) {
                        try {
                            String sifFilePath = this.prefix + this.isiHelper.getSiteInstallationFile(nlhFilePath);
                            FileParameters.instance(this.rbsConfigurationMao).setSiteInstallationFilePath(sifFilePath);
                            FileEncryptor encryptor = new FileEncryptor();
                            encryptor.decryptFile(sifFilePath, this.isiHelper.getXmlEncryptionKey());
                            File tmpFile = new File(sifFilePath + "_decrypted");
                            new SiteInstallationFileParser(this.getSiteInstallationXml(tmpFile.getPath()), this.rbsConfigurationMao).parse();
                            if (tmpFile.exists()) {
                                tmpFile.delete();
                            }
                            TransactionHandler.run(new SetLogicalNameTp(NodeParameters.instance(this.rbsConfigurationMao).getLogicalName(), this.moRepositoryWrapper));
                        }
                        catch (IOException e) {
                            logger.traceError(THIS_CLASS, "Fail to restore AI parameters", (Throwable)e);
                        }
                        catch (GeneralSecurityException e) {
                            logger.traceDebug(THIS_CLASS, "Fail to decrypt file: " + nlhFile.getPath());
                        }
                    } else {
                        try {
                            this.isiHelper.cleanConfigurationFilesAndIsiTempFiles(this.prefix);
                        }
                        catch (FileHelper.FileException e) {
                            logger.traceDebug(THIS_CLASS, "Fail to remove Configuration Files: " + e.getMessage());
                        }
                    }
                }
                try {
                    this.isiHelper.removeMergedIbpLoadModules(this.prefix, this.rbsConfigurationMao);
                }
                catch (FileHelper.FileException e) {
                    logger.traceDebug(THIS_CLASS, "Fail to remove isi_backup directory: " + e.getMessage());
                }
                String message = "AI wo laptop - to handle cancellation";
                String faultMsg = "Could not create the CV.";
                InitialAiCv iacf = InitialAiCvFactory.instance(this.rbsConfigurationMao);
                String aiWoLaptopCvName = iacf.createInitialCv("RbsConfiguration_Initial", true, "AI wo laptop - to handle cancellation", "Could not create the CV.");
                if (aiWoLaptopCvName != null && aiWoLaptopCvName.trim().length() > 0) {
                    iacf.saveCvName(aiWoLaptopCvName);
                    this.stateHolder = new StateHolder(true, 10);
                }
            }
            catch (MoAccessException mae) {
                logger.traceError(THIS_CLASS, "Failure while trying to start WO laptop ", (Throwable)mae);
            }
        }
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    private String getSiteInstallationXml(String fileIn) throws IOException {
        return FileHelper.getFileContents(new File(fileIn));
    }

    private void updateNodeUtcTime() throws NoSuchAttributeException, MoAccessException {
        ManagedObject managedElementData = this.moRepositoryWrapper.lookup("ManagedElement=1,ManagedElementData=1");
        if (managedElementData != null) {
            Long currentTime = (Long)managedElementData.getAttribute("nodeUTCTime", null);
            logger.traceDebug(THIS_CLASS, "current time on node: " + currentTime);
            long jarTime = this.getLatestJarTime();
            logger.traceDebug(THIS_CLASS, "current jar time: " + jarTime);
            if (currentTime == null || currentTime < jarTime) {
                ClientTimeSetter clientTimeSetter = new ClientTimeSetter(this.moRepositoryWrapper, this.helper);
                clientTimeSetter.setTime(jarTime);
            }
        }
    }

    private long getLatestJarTime() {
        logger.traceEnter(THIS_CLASS, "getLatestJarTime()");
        try {
            String rn = THIS_CLASS.getName().replace('.', '/') + ".class";
            logger.traceDebug(THIS_CLASS, "Path of this class: " + rn);
            JarURLConnection j = (JarURLConnection)ClassLoader.getSystemResource(rn).openConnection();
            logger.traceReturn(THIS_CLASS, "getLatestJarTime()");
            return j.getJarFile().getEntry("META-INF/MANIFEST.MF").getTime();
        }
        catch (IOException e) {
            logger.traceAbnormal(THIS_CLASS, "Failed to open connection towards Jar file. Reason: " + e.getMessage());
            return -1L;
        }
    }

    private boolean isIpStackConfigured() {
        logger.traceEnter(THIS_CLASS, "isIpStackConfigured()");
        boolean ipHostLink = this.checkIfMoExists("IpHostLink");
        boolean ipInterface = this.checkIfMoExists("IpInterface");
        boolean gigaBitEthernet = this.checkIfMoExists("GigaBitEthernet");
        logger.traceReturn(THIS_CLASS, "isIpStackConfigured()");
        return ipHostLink && ipInterface && gigaBitEthernet;
    }

    private boolean checkIfMoExists(String moType) {
        MoIterator moIter = this.moRepositoryWrapper.lookupType(moType);
        return moIter != null && moIter.hasMoreElements();
    }

    private void setIntegrationLogFilePathAndStartlog() {
        logger.traceEnter(THIS_CLASS, "setIntegrationLogFilePathAndStartlog()");
        String logFilePathSting = (String)this.rbsConfigurationMao.retrievePersistently("integrationLogFilePath");
        if (logFilePathSting == null || logFilePathSting.equals("")) {
            try {
                this.rbsConfigurationMao.storePersistently("integrationLogFilePath", this.progressReportFileHandler.getLogFilePath());
            }
            catch (MoAccessException e) {
                logger.traceError(THIS_CLASS, "Failed to retrieve Integration log file. Reason: " + e.getMessage());
            }
            String nlhFilePath = this.helper.getLocalPath() + "Nlh.xml";
            boolean nlhFileExists = new File(nlhFilePath).exists();
            if (!nlhFileExists) {
                this.progressReportFileHandler.integrationStarted();
                RbsConfigurationReportLoggerFactory.getLogger().finishAndSaveReportFile(false);
                RbsConfigurationReportLoggerFactory.getLogger().initiateConfigurationReport();
            } else {
                String logFilePath = (String)this.rbsConfigurationMao.retrievePersistently("integrationLogFilePath");
                this.progressReportFileHandler.integrationContinued(logFilePath);
                RbsConfigurationReportLoggerFactory.getLogger().restoreConfigurationReport();
            }
            this.progressReportHandler.setIntegrationStarted(Boolean.TRUE, true, true, true);
        }
        logger.traceReturn(THIS_CLASS, "setIntegrationLogFilePathAndStartlog()");
    }

    private boolean isInConfigLevelBasicCv() throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "isInConfigLevelBasicCv()");
        Integer rbsConfigLevel = (Integer)this.rbsConfigurationMao.getAttribute("rbsConfigLevel");
        boolean result2 = RbsConfigurationDefinitions.RBS_CL_BASIC_CV.intValue() == rbsConfigLevel.intValue();
        logger.traceReturn(THIS_CLASS, "isInConfigLevelBasicCv() " + result2);
        return result2;
    }

    private boolean hasVendorCredentials() {
        logger.traceEnter(THIS_CLASS, "hasVendorCredentials()");
        boolean result2 = false;
        try {
            result2 = VendorCredentialsMgr.getVCInterface().isVCPresent();
        }
        catch (VendorCredentialsException vce) {
            logger.traceDebug(THIS_CLASS, "Failed to read Vendor Credentails, interpret that as there is no VC on the node");
        }
        logger.traceReturn(THIS_CLASS, "hasVendorCredentials() " + result2);
        return result2;
    }

    private boolean isCancelledByUser() {
        logger.traceEnter(THIS_CLASS, "isCancelledByUser()");
        String integrationWasCancelledByUser = StateMachineParameters.instance(this.rbsConfigurationMao).getWoLaptopCancelledByUser();
        boolean result2 = integrationWasCancelledByUser != null && Boolean.TRUE.toString().equalsIgnoreCase(integrationWasCancelledByUser);
        logger.traceReturn(THIS_CLASS, "isCancelledByUser() " + result2);
        return result2;
    }

    protected void setUnitTestRootPrefix(String pathIn) {
        this.prefix = pathIn;
    }
}

