/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state;

import java.io.File;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationSmrsHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.FileParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.NodeParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.SecurityParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ProgressReportHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ric.RicInfo;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.AbstractStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.StateHolder;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.security.cppsec.esa.CertInfo;
import se.ericsson.security.cppsec.esa.EsaReturnVal;
import se.ericsson.security.cppsec.esa.ExpressSecurityActivation;
import se.ericsson.security.cppsec.esa.SecurityActivationException;
import se.ericsson.security.cppsec.esa.SecurityActivationInputException;

public class PrepareSecurityStateExecutor
extends AbstractStateExecutor {
    private static final Class THIS_CLASS = PrepareSecurityStateExecutor.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final ExpressSecurityActivation esa;
    private final Object esaLock;
    static /* synthetic */ Class class$se$ericsson$crbs$cat$mao$rbsconfiguration$helper$RbsConfigurationSmrsHelper;

    public PrepareSecurityStateExecutor(RbsConfigurationMao inRbsConfigurationMao, ExpressSecurityActivation inEsa, Object inEsaLock) {
        super(THIS_CLASS.getName(), inRbsConfigurationMao, true, 75);
        this.esa = inEsa;
        this.esaLock = inEsaLock;
    }

    public void execute() {
        logger.traceEnter(THIS_CLASS, "execute()");
        this.setDefaultValues();
        if (SecurityParameters.instance(this.rbsConfigurationMao).getActivateSecurityAsBoolean()) {
            this.prepareSecurityConfiguration();
        }
        this.stateHolder = new StateHolder(true, 76);
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    private void setDefaultValues() {
        try {
            this.rbsConfigurationMao.storePersistently("wantedSecurityLevel", new Integer(1));
            this.rbsConfigurationMao.storePersistently("minimumSecurityLevel", new Integer(1));
            this.rbsConfigurationMao.storePersistently("reachedSecurityLevel", new Integer(1));
            this.rbsConfigurationMao.storePersistently("securityChecksums", "");
            this.rbsConfigurationMao.storePersistently("securityChecksumVersion", "");
            this.rbsConfigurationMao.storePersistently("oamCertSerialNumber", "");
            this.rbsConfigurationMao.storePersistently("oamCertFingerPrint", "");
            this.rbsConfigurationMao.storePersistently("sshKey", "");
        }
        catch (MoAccessException mae) {
            String errorMsg = ExceptionHelper.appendReason((String)"Unable to persistently store default values for security", (Throwable)mae);
            logger.traceError(THIS_CLASS, errorMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareSecurityConfiguration() {
        logger.traceEnter(THIS_CLASS, "prepareSecurityConfiguration()");
        this.updateProgressReportInformation(2000, 3, "Installing node security.", true);
        String userName = FileParameters.instance(this.rbsConfigurationMao).getSmrsUserName();
        String logicalName = NodeParameters.instance(this.rbsConfigurationMao).getLogicalName();
        boolean keepTrying = true;
        while (keepTrying) {
            String rbsIntegrationCode = SecurityParameters.instance(this.rbsConfigurationMao).getIntegrationCode();
            String iscfFilePath = SecurityParameters.instance(this.rbsConfigurationMao).getLocalInitialSecurityConfigurationFile();
            EsaReturnVal esaRetVal = null;
            File target = new File(iscfFilePath);
            if (target.exists()) {
                String errorMsg;
                try {
                    logger.traceDebug(THIS_CLASS, "prepareSecurityConfiguration(): will call esa.install");
                    Object object = this.esaLock;
                    synchronized (object) {
                        esaRetVal = this.esa.install(iscfFilePath, rbsIntegrationCode, userName, logicalName);
                        this.rbsConfigurationMao.storePersistently("esaInstalled", Boolean.TRUE.toString());
                    }
                    logger.traceDebug(THIS_CLASS, "prepareSecurityConfiguration(): esa.install successful");
                    keepTrying = false;
                    this.updateProgressReportInformation(2000, 5, "Successfully installed node security.", true);
                    this.helper.setRbsConfigLevel(RbsConfigurationDefinitions.RBS_CL_SECURITY_PREPARATION_COMPLETE);
                    this.handleEsaResult(esaRetVal);
                }
                catch (SecurityActivationException e) {
                    this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_SECURITY_CONFIGURATION_FAULT, "Security preparation failure! Will retry...", e.getMessage());
                    errorMsg = "Failed at ESA install. Will retry: " + e.getMessage();
                    logger.traceError(THIS_CLASS, errorMsg, (Throwable)e);
                    this.updateProgressReportInformation(2000, 4, "Security preparation failure! " + errorMsg + " " + "Will retry...", true);
                    this.refetchIscf(iscfFilePath);
                }
                catch (SecurityActivationInputException e) {
                    if (e.getMessage().indexOf("The ISCF and RIC does not match!") > -1) {
                        ProgressReportHandler.getInstance().addWrongRbsIntegrationCode(new RicInfo(""));
                    }
                    this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_SECURITY_CONFIGURATION_FAULT, "Security preparation failure! Will retry...", e.getMessage());
                    errorMsg = "Failed at ESA install. Will retry: " + e.getMessage();
                    logger.traceError(THIS_CLASS, errorMsg, (Throwable)e);
                    this.updateProgressReportInformation(2000, 4, "Security preparation failure! " + errorMsg + " " + "Will retry...", true);
                    this.refetchIscf(iscfFilePath);
                }
                catch (Exception e) {
                    this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_SECURITY_CONFIGURATION_FAULT, "Security preparation failure!", ExceptionHelper.appendReason((String)"Failed at ESA install. Caught an unexpected Exception: ", (Throwable)e));
                    errorMsg = "Failed at ESA install. Caught an unexpected Exception: " + ExceptionHelper.convertToString((Throwable)e);
                    logger.traceError(THIS_CLASS, errorMsg);
                    this.updateProgressReportInformation(2000, 0, "Security preparation failure! " + errorMsg, true);
                    this.refetchIscf(iscfFilePath);
                }
                continue;
            }
            this.refetchIscf(iscfFilePath);
        }
        logger.traceReturn(THIS_CLASS, "prepareSecurityConfiguration()");
    }

    protected void handleEsaResult(EsaReturnVal esaRetVal) {
        if (esaRetVal != null) {
            String faultReasonMsg = "";
            String loggerMsg = "";
            boolean keepTrying = true;
            while (keepTrying) {
                try {
                    faultReasonMsg = "Unable to persistently store: minimumSecurityLevel";
                    loggerMsg = "Failed to persistently store minimum security level: ";
                    int minLevel = esaRetVal.getMinimumSecurityLevel();
                    logger.traceDebug(THIS_CLASS, "handleEsaResult: esa returned minimum sec level: " + minLevel);
                    this.rbsConfigurationMao.storePersistently("minimumSecurityLevel", new Integer(minLevel));
                    faultReasonMsg = "Unable to persistently store: wantedSecurityLevel";
                    loggerMsg = "Failed to persistently store wanted security level: ";
                    int wantedLevel = esaRetVal.getWantedSecurityLevel();
                    logger.traceDebug(THIS_CLASS, "handleEsaResult: esa returned wanted sec level: " + wantedLevel);
                    this.rbsConfigurationMao.storePersistently("wantedSecurityLevel", new Integer(wantedLevel));
                    CertInfo[] certInfo = esaRetVal.getOamCertInfo();
                    if (certInfo != null && certInfo[0] != null) {
                        this.storeSerialNumberAndFingerPrint(certInfo);
                    }
                    keepTrying = false;
                }
                catch (MoAccessException e) {
                    this.helper.waitForRetry("Waiting to store Security Levels persistently...");
                    this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_SECURITY_CONFIGURATION_FAULT, faultReasonMsg + " Will retry install...", e.getMessage());
                    logger.traceError(THIS_CLASS, loggerMsg + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void storeSerialNumberAndFingerPrint(CertInfo[] certInfo) throws MoAccessException {
        String ipSecSerialNumber = certInfo[0].getSerialNumber();
        String ipSecFingerPrint = certInfo[0].getCertificateFingerprint();
        if (ipSecSerialNumber != null && ipSecFingerPrint != null) {
            this.rbsConfigurationMao.storePersistently("oamCertSerialNumber", ipSecSerialNumber);
            this.rbsConfigurationMao.storePersistently("oamCertFingerPrint", ipSecFingerPrint);
        }
    }

    private void refetchIscf(String iscfFilePath) {
        logger.traceEnter(THIS_CLASS, "refetchIscf()");
        boolean iscfRefetched = false;
        int iscfFetchAttempt = 0;
        while (!iscfRefetched) {
            ++iscfFetchAttempt;
            try {
                RbsConfigurationSmrsHelper smrsHelper = (RbsConfigurationSmrsHelper)this.rbsConfigurationContext.getHelper(class$se$ericsson$crbs$cat$mao$rbsconfiguration$helper$RbsConfigurationSmrsHelper == null ? PrepareSecurityStateExecutor.class$("se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationSmrsHelper") : class$se$ericsson$crbs$cat$mao$rbsconfiguration$helper$RbsConfigurationSmrsHelper);
                smrsHelper.reFetchInitialSecurityContainerFile(iscfFetchAttempt);
                iscfRefetched = true;
            }
            catch (RbsConfigurationFailedException rcfe) {
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_SECURITY_CONFIGURATION_FAULT, "Failed to re-fetch ISCF!", rcfe.getVariablesAsString());
                String retryErrorMsg = ExceptionHelper.appendReason((String)("Failed to re-fetch ISCF (" + iscfFilePath + ")"), (Throwable)((Object)rcfe));
                logger.traceError(THIS_CLASS, retryErrorMsg, (Throwable)((Object)rcfe));
                this.updateProgressReportInformation(1900, 0, retryErrorMsg, false);
                String dependentErrorMessage = "Could not be performed as the ISCF could not be retrieved";
                this.updateProgressReportInformation(2000, 0, "Could not be performed as the ISCF could not be retrieved", false);
                this.updateProgressReportInformation(2200, 0, "Could not be performed as the ISCF could not be retrieved", true);
            }
        }
        logger.traceReturn(THIS_CLASS, "refetchIscf()");
    }
}

