/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state;

import java.io.File;
import se.ericsson.crbs.cat.mao.rbsconfiguration.PersistentDataCleaner;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.isi.RbsConfigurationIsiHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.SecurityParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLogger;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.security.SecurityHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.AbstractStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.initialcv.InitialAiCvFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.RestartNodeTp;
import se.ericsson.crbs.common.FileHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.transactions.TransactionServicesFactoryImpl;
import se.ericsson.security.cppsec.esa.ExpressSecurityActivation;

public class RollbackIntegrationStateExecutor
extends AbstractStateExecutor {
    private static final Class THIS_CLASS = RollbackIntegrationStateExecutor.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final ExpressSecurityActivation esa;
    private final Object esaLock;
    private final boolean performNodeRestart;
    public String rootDirForTest = System.getProperty("user.home") + File.separator + "TestDir";

    public RollbackIntegrationStateExecutor(RbsConfigurationMao inRbsConfigurationMao, ExpressSecurityActivation inEsa, Object inEsaLock, boolean inPerformNodeRestart) {
        super(THIS_CLASS.getName(), inRbsConfigurationMao, false, 0);
        logger.traceEnter(THIS_CLASS, "RollbackIntegrationStateExecutor() performNodeRestart:" + inPerformNodeRestart);
        this.esa = inEsa;
        this.esaLock = inEsaLock;
        this.performNodeRestart = inPerformNodeRestart;
        TransactionServicesFactoryImpl.getInstance().getCppTransactionFactory();
        logger.traceReturn(THIS_CLASS, "RollbackIntegrationStateExecutor()");
    }

    public void execute() {
        logger.traceEnter(THIS_CLASS, "execute()");
        this.rollbackIntegration();
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    private void rollbackIntegration() {
        logger.traceEnter(THIS_CLASS, "rollbackIntegration()");
        String failureSlogan = "Cancel integration failed!";
        this.progressReportHandler.setIntegrationCancelled(Boolean.TRUE, true);
        if (SecurityParameters.instance(this.rbsConfigurationMao).getActivateIpSecurityAsBoolean()) {
            SecurityHelper securityHelper = new SecurityHelper();
            securityHelper.resetSecurityActivation("Cancel integration failed!", this.rbsConfigurationMao, this.esa, this.esaLock);
        }
        InitialAiCvFactory.instance(this.rbsConfigurationMao).restoreCv();
        InitialAiCvFactory.instance(this.rbsConfigurationMao).deleteInitialCv("RbsConfiguration_Initial", "Cancel integration failed!");
        PersistentDataCleaner persistentAttributesCleaner = new PersistentDataCleaner(this.rbsConfigurationMao);
        persistentAttributesCleaner.cleanPersistentAttributesAndRemoveFiles("cancel_");
        String rootDir = "";
        if ("true".equalsIgnoreCase(System.getProperty("UNIT_TEST"))) {
            rootDir = this.rootDirForTest;
        }
        RbsConfigurationIsiHelper isiHelper = (RbsConfigurationIsiHelper)this.rbsConfigurationMao.getRbsConfigurationContext().getHelper(RbsConfigurationIsiHelper.class);
        try {
            isiHelper.cleanConfigurationFilesAndIsiTempFiles(rootDir);
        }
        catch (FileHelper.FileException e) {
            logger.traceDebug(THIS_CLASS, "Fail to remove Configuration Files: " + e.getMessage());
        }
        if (this.performNodeRestart) {
            TransactionHandler.runWithLoopWithoutException(new RestartNodeTp(this.rbsConfigurationMao, "RBS integration cancelled by site installer", "Cancel integration failed!"));
        } else {
            this.progressReportHandler.setIntegrationCanBeCancelled(Boolean.FALSE);
            this.progressReportHandler.setIntegrationStarted(Boolean.FALSE, SecurityParameters.instance(this.rbsConfigurationMao).getActivateSecurityAsBoolean(), SecurityParameters.instance(this.rbsConfigurationMao).getActivateIpSecurityAsBoolean(), false);
            this.progressReportHandler.setIntegrationFinished(Boolean.FALSE, false, null);
            this.progressReportHandler.setIntegrationCanBeStarted(Boolean.TRUE, true);
        }
        RbsConfigurationReportLogger reporLogger = RbsConfigurationReportLoggerFactory.getLogger();
        reporLogger.logInformation("rollback", "The integration could not finish. Rolling back.");
        reporLogger.finishAndSaveReportFile(true);
        logger.traceReturn(THIS_CLASS, "rollbackIntegration()");
    }
}

