/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state;

import java.io.File;
import se.ericsson.cello.ipsec.IpSecMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.common.StringHelper;
import se.ericsson.crbs.cat.mao.interfaces.NodeAddressChange;
import se.ericsson.crbs.cat.mao.nodeaddresschange.NodeAddressChangeParams;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationContext;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.AutoIntParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.SecurityParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ProgressReportFileHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ProgressReportHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.security.AbstractIpSecThread;
import se.ericsson.crbs.cat.mao.rbsconfiguration.security.IpSecThreadFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.security.SecurityProgressReporter;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.NodeAddressChangeParamsHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.AbstractConfigureRetProfileThread;
import se.ericsson.crbs.cat.mao.rbsconfiguration.siteequipment.ConfigureRetProfileThreadFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.AbstractStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.ActivateExtensionDUStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.ActivateIpSecurityStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.ActivateSecurityLevelStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.ActivateSiteBasicStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.ActivateSiteEquipmentStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.ContinueUpgradeStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.CreateCvStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.CvCreatedStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.FetchFilesStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.FetchSiteInstallationFileStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.InformOssStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.InitialSoftwareInstallationStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.InstallLicenseStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.IntegrationNotStartedStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.IpConfigurationStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.PrepareIpSecurityStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.PrepareSecurityStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.ReadyForServiceStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.RollbackIntegrationStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.StateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.StateHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.StateHolder;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.UnknownStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.UpgradeStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.VerifyOssConnectivityStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.VlanScanStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.WaitForCellsToBeEnabledStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.WaitForGeoLocationCheckStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.WaitForIpSecurityThreadStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.WaitForS1StateExecutor;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;
import se.ericsson.security.cppsec.esa.EsaMessageHandler;
import se.ericsson.security.cppsec.esa.ExpressSecurityActivation;
import se.ericsson.security.cppsec.esa.ExpressSecurityActivationFactory;

public class StateHandlerImpl
implements Runnable,
StateHandler {
    private static final Class THIS_CLASS = StateHandlerImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected boolean securitySuccess = false;
    protected Thread stateHandlerThread = null;
    protected StateExecutorWrapper stateExecutorWrapper = new StateExecutorWrapper();
    private final ProgressReportHandler progressReportHandler;
    private final ExpressSecurityActivation esa;
    private final RbsConfigurationHelper helper;
    private final boolean moRestored;
    private final RbsConfigurationMao rbsConfigurationMao;
    private final ProgressReportFileHandler progressReportFileHandler;
    private AbstractIpSecThread ipSecThread = null;
    private AbstractConfigureRetProfileThread retProfileThread = null;
    private final Object esaLock = new Object();
    private boolean keepRunning = true;

    public StateHandlerImpl(RbsConfigurationMao inRbsConfigurationMao) {
        this.progressReportHandler = ProgressReportHandler.getInstance();
        this.rbsConfigurationMao = inRbsConfigurationMao;
        this.progressReportFileHandler = inRbsConfigurationMao.getProgressReportFileHandler();
        this.moRestored = inRbsConfigurationMao.isMoRestored();
        RbsConfigurationContext rbsConfigurationContext = inRbsConfigurationMao.getRbsConfigurationContext();
        this.helper = (RbsConfigurationHelper)rbsConfigurationContext.getHelper(RbsConfigurationHelper.class);
        SecurityProgressReporter progressReporter = new SecurityProgressReporter();
        this.esa = ExpressSecurityActivationFactory.createExpressSecurityActivation((EsaMessageHandler)progressReporter);
    }

    public void start() {
        logger.traceEnter(THIS_CLASS, "start()");
        this.stateHandlerThread = new Thread((Runnable)this, "CRBS_lmCatOamLmU_RbsConfiguration_start");
        this.stateHandlerThread.start();
        logger.traceGeneral(THIS_CLASS, "Started state handling in a separate thread: " + StringHelper.doubleQuote((String)this.stateHandlerThread.getName()));
        logger.traceReturn(THIS_CLASS, "start()");
    }

    public void stop() {
        this.keepRunning = false;
    }

    public void run() {
        try {
            this.stateHandler();
        }
        catch (Throwable throwable) {
            String errorMsg = "State handler received an unexpected exception - will terminate!";
            logger.traceError(THIS_CLASS, ExceptionHelper.appendReason((String)"State handler received an unexpected exception - will terminate!", (Throwable)throwable), throwable);
        }
    }

    private void stateHandler() {
        boolean integrationOnGoing;
        logger.traceEnter(THIS_CLASS, "stateHandler()");
        int integrationState = this.getConfigurationState();
        boolean bl = integrationOnGoing = integrationState != 0 && integrationState != 110;
        if (integrationOnGoing) {
            String logFilePath = (String)this.rbsConfigurationMao.retrievePersistently("integrationLogFilePath");
            this.progressReportFileHandler.integrationContinued(logFilePath);
        }
        this.initializeProgressReportHandling(!integrationOnGoing);
        this.stateExecutorWrapper.setStateExecutor(this.getNextStateExecutor(null));
        if (this.stateExecutorWrapper.getStateExecutor().getStateHolder().getNextState() != 0) {
            RbsConfigurationReportLoggerFactory.getLogger().restoreConfigurationReport();
        }
        if (integrationOnGoing) {
            this.restartInformOssState();
        } else {
            this.storeInformOssAttribute("NOT_STARTED");
        }
        this.runExecutors();
        int lastIntegrationState = this.getConfigurationState();
        if (lastIntegrationState > 80) {
            this.setNodeAddressChangeParams();
        }
        RbsConfigurationReportLoggerFactory.getLogger().flushLogEntryBufferToFile();
        logger.traceReturn(THIS_CLASS, "stateHandler()");
    }

    private void setNodeAddressChangeParams() {
        logger.traceEnter(THIS_CLASS, "setNodeAddressChangeParams()");
        NodeAddressChange nodeAddressChange = this.rbsConfigurationMao.getNodeAddressChange();
        if (nodeAddressChange != null) {
            NodeAddressChangeParams params = NodeAddressChangeParamsHandler.getNodeAddressChangeParams(this.rbsConfigurationMao);
            nodeAddressChange.setParameters(params);
        } else {
            logger.traceAbnormal(THIS_CLASS, "rbsConfigurationMao.getNodeAddressChange() returned null.");
        }
        logger.traceReturn(THIS_CLASS, "setNodeAddressChangeParams()");
    }

    private void runExecutors() {
        logger.traceDebug(THIS_CLASS, this.progressReportHandler.getTraceMessage());
        logger.traceDebug(THIS_CLASS, AutoIntParameters.instance(this.rbsConfigurationMao).toString());
        boolean doContinue = true;
        while (this.keepRunning && doContinue) {
            logger.traceGeneral(THIS_CLASS, "State handler executing state: " + StringHelper.doubleQuote((String)this.stateExecutorWrapper.getStateExecutor().getExecutorName()));
            this.stateExecutorWrapper.getStateExecutor().execute();
            logger.traceDebug(THIS_CLASS, this.progressReportHandler.getTraceMessage());
            logger.traceDebug(THIS_CLASS, AutoIntParameters.instance(this.rbsConfigurationMao).toString());
            logger.traceGeneral(THIS_CLASS, "State handler executed state: " + StringHelper.doubleQuote((String)this.stateExecutorWrapper.getStateExecutor().getExecutorName()));
            int nextState = this.stateExecutorWrapper.getStateExecutor().getStateHolder().getNextState();
            if (nextState == -10) {
                doContinue = false;
                continue;
            }
            this.helper.setConfigurationStateAndProgressLevel(nextState);
            doContinue = this.stateExecutorWrapper.getStateExecutor().getStateHolder().doContinueWithNextStep();
            if (doContinue) {
                this.stateExecutorWrapper.setStateExecutor(this.getNextStateExecutor(this.stateExecutorWrapper.getStateExecutor()));
                logger.traceGeneral(THIS_CLASS, "State handler retrieved next state: " + StringHelper.doubleQuote((String)this.stateExecutorWrapper.getStateExecutor().getExecutorName()));
                continue;
            }
            logger.traceGeneral(THIS_CLASS, "State handler instructed to stop");
        }
    }

    private void restartInformOssState() {
        logger.traceEnter(THIS_CLASS, "restartInformOssState()");
        String currentInformOss = "NOT_STARTED";
        Object currInformOssObj = this.rbsConfigurationMao.retrievePersistently("informOss");
        if (currInformOssObj != null) {
            currentInformOss = (String)currInformOssObj;
        }
        if (currentInformOss.compareToIgnoreCase("STARTED") == 0) {
            InformOssStateExecutor stateExecutor = new InformOssStateExecutor(false, this.rbsConfigurationMao);
            logger.traceGeneral(THIS_CLASS, "State handler executing state (restart): " + StringHelper.doubleQuote((String)stateExecutor.getExecutorName()));
            stateExecutor.execute();
            logger.traceGeneral(THIS_CLASS, "State handler executed state (restart): " + StringHelper.doubleQuote((String)stateExecutor.getExecutorName()));
        } else if (currentInformOss.compareToIgnoreCase("SENT_MESSAGE") == 0) {
            ProgressReportHandler.getInstance().updateProgressReportInformation(2300, 5, "Successfuly informed OSS that the RBS is up and running", true);
            this.storeInformOssAttribute("FINISHED");
            logger.traceGeneral(THIS_CLASS, "Report Inform OSS Finished after restart.");
        }
        logger.traceReturn(THIS_CLASS, "restartInformOssState()");
    }

    private void storeInformOssAttribute(String attributeValue) {
        try {
            this.rbsConfigurationMao.storePersistently("informOss", attributeValue);
            logger.traceGeneral(THIS_CLASS, "The attribute informOss has been successfully stored with the value " + attributeValue + " persistently.");
        }
        catch (MoAccessException ignore) {
            logger.traceError(THIS_CLASS, "Could not store the attribute informOss with the value " + attributeValue + " persistently.");
        }
    }

    public final int getConfigurationState() {
        logger.traceEnter(THIS_CLASS, "getConfigurationState()");
        int currentState = 0;
        Object currStateObj = this.rbsConfigurationMao.retrievePersistently("configurationState");
        if (currStateObj != null) {
            currentState = (Integer)currStateObj;
        }
        logger.traceReturn(THIS_CLASS, "getConfigurationState() = " + currentState);
        return currentState;
    }

    protected void initializeProgressReportHandling(boolean checkIntegrationCanBeStarted) {
        logger.traceEnter(THIS_CLASS, "initializeProgressReportHandling()");
        String progressReport = "";
        if (this.moRestored) {
            try {
                progressReport = (String)this.rbsConfigurationMao.getAttribute("progressReport");
                logger.traceGeneral(THIS_CLASS, "progressReport attribute read from attribute: " + progressReport);
            }
            catch (MoAccessException mae) {
                logger.traceAbnormal(THIS_CLASS, ExceptionHelper.appendReason((String)"Failed to read progressReport attribute", (Throwable)mae));
                progressReport = "";
                logger.traceGeneral(THIS_CLASS, "progressReport attribute created from scratch: " + progressReport);
            }
        } else {
            progressReport = "";
            logger.traceGeneral(THIS_CLASS, "progressReport attribute created from scratch: " + progressReport);
        }
        this.progressReportHandler.init("", progressReport, this.rbsConfigurationMao);
        if (checkIntegrationCanBeStarted) {
            this.checkAndSetIntegrationCanBeStarted(null);
        }
        this.progressReportHandler.setProgressReport(this.progressReportHandler.getProgressReport(), false, null);
        logger.traceReturn(THIS_CLASS, "initializeProgressReportHandling()");
    }

    public final boolean checkAndSetIntegrationCanBeStarted(Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "checkAndSetIntegrationCanBeStarted()");
        boolean result2 = false;
        try {
            Integer correctConfigLevel = RbsConfigurationDefinitions.RBS_CL_BASIC_CV;
            Integer currentConfigLevel = (Integer)this.rbsConfigurationMao.getAttribute("rbsConfigLevel", coordinator);
            Boolean integrationCanBeStarted = !this.rbsConfigurationMao.isIntegrationStarted() && correctConfigLevel.equals(currentConfigLevel) ? Boolean.TRUE : Boolean.FALSE;
            this.progressReportHandler.setIntegrationCanBeStarted(integrationCanBeStarted, true, coordinator);
            result2 = integrationCanBeStarted;
        }
        catch (MoAccessException e) {
            this.progressReportHandler.setIntegrationCanBeStarted(Boolean.FALSE, true, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "checkAndSetIntegrationCanBeStarted()");
        return result2;
    }

    public void rollbackIntegration() {
        logger.traceEnter(THIS_CLASS, "rollbackIntegration()");
        this.keepRunning = false;
        boolean prepareNodeRestart = this.stateExecutorWrapper.prepareNodeRestart();
        RollbackIntegrationStateExecutor rollbackIntegrationStateExecutor = new RollbackIntegrationStateExecutor(this.rbsConfigurationMao, this.esa, this.esaLock, prepareNodeRestart);
        rollbackIntegrationStateExecutor.execute();
        if (!prepareNodeRestart) {
            this.keepRunning = true;
        }
        logger.traceReturn(THIS_CLASS, "rollbackIntegration()");
    }

    private StateExecutor getNextStateExecutor(StateExecutor currentStateExecutor) {
        int nextState;
        logger.traceEnter(THIS_CLASS, "getNextStateExecutor()");
        AbstractStateExecutor stateExecutor = null;
        if (currentStateExecutor == null) {
            nextState = this.getConfigurationState();
        } else {
            StateHolder stateHolder = currentStateExecutor.getStateHolder();
            nextState = stateHolder.getNextState();
        }
        switch (nextState) {
            case 0: {
                stateExecutor = new IntegrationNotStartedStateExecutor(this.rbsConfigurationMao);
                break;
            }
            case 10: {
                stateExecutor = new VlanScanStateExecutor(this.rbsConfigurationMao);
                break;
            }
            case 11: {
                stateExecutor = new IpConfigurationStateExecutor(this.rbsConfigurationMao);
                break;
            }
            case 110: {
                stateExecutor = new InformOssStateExecutor(true, this.rbsConfigurationMao);
                break;
            }
            case 20: {
                stateExecutor = new FetchSiteInstallationFileStateExecutor(this.rbsConfigurationMao);
                break;
            }
            case 21: {
                stateExecutor = new FetchFilesStateExecutor(this.rbsConfigurationMao);
                break;
            }
            case 25: {
                stateExecutor = new InitialSoftwareInstallationStateExecutor(this.rbsConfigurationMao);
                break;
            }
            case 30: {
                stateExecutor = new UpgradeStateExecutor(this.rbsConfigurationMao);
                break;
            }
            case 40: {
                stateExecutor = new ContinueUpgradeStateExecutor(this.rbsConfigurationMao);
                break;
            }
            case 60: {
                stateExecutor = new ActivateSiteBasicStateExecutor(this.rbsConfigurationMao, this.esa, this.esaLock);
                break;
            }
            case 65: {
                this.retProfileThread = ConfigureRetProfileThreadFactory.getInstance().getConfigureRetProfileThread(this.rbsConfigurationMao);
                stateExecutor = new ActivateSiteEquipmentStateExecutor(this.rbsConfigurationMao, this.retProfileThread);
                break;
            }
            case 75: {
                stateExecutor = new PrepareSecurityStateExecutor(this.rbsConfigurationMao, this.esa, this.esaLock);
                break;
            }
            case 63: {
                this.ipSecThread = IpSecThreadFactory.getInstance().getIpSecThread(this.rbsConfigurationMao);
                stateExecutor = new PrepareIpSecurityStateExecutor(this.rbsConfigurationMao, this.ipSecThread);
                break;
            }
            case 70: {
                logger.traceDebug(THIS_CLASS, "state RBS_CS_WAIT_FOR_IP_SECURITY: ipSecThread = " + this.ipSecThread);
                stateExecutor = new WaitForIpSecurityThreadStateExecutor(this.rbsConfigurationMao, this.ipSecThread);
                break;
            }
            case 72: {
                stateExecutor = new ActivateIpSecurityStateExecutor(this.rbsConfigurationMao);
                break;
            }
            case 71: {
                stateExecutor = new ActivateExtensionDUStateExecutor(this.rbsConfigurationMao);
                break;
            }
            case 73: {
                stateExecutor = new VerifyOssConnectivityStateExecutor(this.rbsConfigurationMao, this.esa, this.esaLock);
                break;
            }
            case 76: {
                stateExecutor = new ActivateSecurityLevelStateExecutor(this.rbsConfigurationMao, this.esa);
                break;
            }
            case 80: {
                stateExecutor = new InformOssStateExecutor(false, this.rbsConfigurationMao);
                break;
            }
            case 50: {
                stateExecutor = new InstallLicenseStateExecutor(this.rbsConfigurationMao);
                break;
            }
            case 90: {
                stateExecutor = new CreateCvStateExecutor(this.rbsConfigurationMao);
                break;
            }
            case 95: {
                stateExecutor = new CvCreatedStateExecutor(this.rbsConfigurationMao);
                break;
            }
            case 100: {
                stateExecutor = new WaitForS1StateExecutor(this.rbsConfigurationMao);
                break;
            }
            case 115: {
                stateExecutor = new WaitForGeoLocationCheckStateExecutor(this.rbsConfigurationMao);
                break;
            }
            case 120: {
                stateExecutor = new WaitForCellsToBeEnabledStateExecutor(this.rbsConfigurationMao);
                break;
            }
            case 130: {
                stateExecutor = new ReadyForServiceStateExecutor(this.rbsConfigurationMao, this.retProfileThread);
                break;
            }
            default: {
                stateExecutor = new UnknownStateExecutor(nextState, this.rbsConfigurationMao);
            }
        }
        logger.traceReturn(THIS_CLASS, "getNextStateExecutor(" + stateExecutor.getExecutorName() + ")");
        return stateExecutor;
    }

    protected void updateProgressReportInformation(int integrationStepNumber, int status, String detailedInformation, boolean updateProgressReport) {
        ProgressReportHandler.getInstance().updateProgressReportInformation(integrationStepNumber, status, detailedInformation, updateProgressReport);
    }

    public boolean checkOkToStartIpSecThread() {
        logger.traceEnter(THIS_CLASS, "checkOkToStartIpSecThread()");
        boolean runIpSec = false;
        MoRepositoryWrapper moRepository = this.rbsConfigurationMao.getRbsConfigurationContext().getGenericMaoContext().getMoRepositoryWrapper();
        IpSecMo ipSecMo = (IpSecMo)moRepository.lookup("ManagedElement=1,IpSystem=1,IpSec=1");
        boolean licenseIsEnabled = false;
        String errorMessage = "Missing IPSec MO or wrong LicenseState on IPSec MO!";
        if (ipSecMo == null) {
            logger.traceGeneral(THIS_CLASS, "ipSecMo is null!");
        } else {
            licenseIsEnabled = this.isLicenseEnabled(ipSecMo);
            logger.traceDebug(THIS_CLASS, "Param: licenseIsEnabled = " + licenseIsEnabled);
        }
        boolean activateIpSecurity = this.isActivateIpSecurity();
        logger.traceDebug(THIS_CLASS, "Param: activateIpSecurity = " + activateIpSecurity);
        if (!activateIpSecurity) {
            errorMessage = "Installation of IPSec certificates disabled by user";
        }
        String localIscf = SecurityParameters.instance(this.rbsConfigurationMao).getLocalInitialSecurityConfigurationFile();
        boolean localIscfExists = this.isLocalIscfExisting(localIscf);
        logger.traceDebug(THIS_CLASS, "Param: localIscfExists = " + localIscfExists);
        if (!localIscfExists) {
            errorMessage = "Missing ISCF with path: " + localIscf;
        }
        if (licenseIsEnabled && localIscfExists && activateIpSecurity) {
            runIpSec = true;
        } else {
            this.updateProgressReportInformation(2100, 2, errorMessage, true);
        }
        logger.traceReturn(THIS_CLASS, "checkOkToStartIpSecThread(), runIpSec = " + runIpSec);
        return runIpSec;
    }

    private boolean isLocalIscfExisting(String localIscf) {
        boolean iscfExists = false;
        if (localIscf != null) {
            File localIscfFile = new File(localIscf);
            iscfExists = localIscfFile.exists();
        }
        return iscfExists;
    }

    private boolean isActivateIpSecurity() {
        SecurityParameters sp = SecurityParameters.instance(this.rbsConfigurationMao);
        String rbsIntegrationCode = sp.getIntegrationCode();
        boolean activateIpSecurity = true;
        if (rbsIntegrationCode != null && !rbsIntegrationCode.equals("")) {
            String retreievedActivateIpSec = sp.getActivateIpSecurity();
            activateIpSecurity = Boolean.valueOf(retreievedActivateIpSec);
        }
        return activateIpSecurity;
    }

    private boolean isLicenseEnabled(IpSecMo ipSecMo) {
        boolean licenseIsEnabled;
        boolean enabled = true;
        try {
            Integer licenseState = (Integer)ipSecMo.getAttribute("licenseState", null);
            licenseIsEnabled = licenseState == 1;
        }
        catch (Exception e) {
            licenseIsEnabled = false;
            logger.traceError(THIS_CLASS, "The attribute: licenseState could not be fetched from the IpSec MO!");
        }
        return licenseIsEnabled;
    }

    private class StateExecutorWrapper {
        private StateExecutor stateExecutor = null;

        private StateExecutorWrapper() {
        }

        private synchronized StateExecutor getStateExecutor() {
            return this.stateExecutor;
        }

        private synchronized void setStateExecutor(StateExecutor stateExecutorIn) {
            this.stateExecutor = stateExecutorIn;
        }

        private synchronized boolean prepareNodeRestart() {
            return this.stateExecutor == null ? true : this.stateExecutor.prepareNodeRestart();
        }
    }
}

