/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state;

import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.UpgradeParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ProgressReportHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.AbstractStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.StateHolder;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.UpgradeHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.UpgradeHandlerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.UpgradeResult;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class UpgradeStateExecutor
extends AbstractStateExecutor {
    private static final Class THIS_CLASS = UpgradeStateExecutor.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public UpgradeStateExecutor(RbsConfigurationMao inRbsConfigurationMao) {
        super(THIS_CLASS.getName(), inRbsConfigurationMao, true, 30);
    }

    public void execute() {
        logger.traceEnter(THIS_CLASS, "execute()");
        UpgradeResult upgrading = this.startUpgrade();
        this.stateHolder = UpgradeResult.INSTALL_IN_PROGRESS.equals(upgrading) ? new StateHolder(true, 30) : (UpgradeResult.UPGRADE_IN_PROGRESS.equals(upgrading) ? new StateHolder(false, 40) : (UpgradeResult.LOCAL_UPGRADE_FAILED.equals(upgrading) ? new StateHolder(true, 30) : (UpgradeResult.REMOTE_UPGRADE_FAILED.equals(upgrading) ? new StateHolder(true, 21) : new StateHolder(true, 50))));
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    private UpgradeResult startUpgrade() {
        logger.traceEnter(THIS_CLASS, "startUpgrade()");
        UpgradeResult result2 = null;
        UpgradeParameters up = UpgradeParameters.instance(this.rbsConfigurationMao);
        String localUpgradePath = up.getUpgradePackageFilePath();
        String remoteUpgradePath = up.getUpgradePackageRemotePath();
        if (RbsConfigurationHelper.existsAndNotEmpty(localUpgradePath) && !"DoNoTuSeVaLuEfRoMsUmMaRy".equals(localUpgradePath)) {
            ProgressReportHandler.getInstance().setIntegrationCanBeCancelled(Boolean.FALSE);
            UpgradeHandler upgradeHandler = UpgradeHandlerFactory.getUpgradeHandler(this.rbsConfigurationMao, this.moRepositoryWrapper, this.moFactoryMgrWrapper);
            result2 = upgradeHandler.performUpgrade(true, localUpgradePath);
        } else if (RbsConfigurationHelper.existsAndNotEmpty(remoteUpgradePath) && !"DoNoTuSeVaLuEfRoMsUmMaRy".equals(localUpgradePath)) {
            ProgressReportHandler.getInstance().setIntegrationCanBeCancelled(Boolean.FALSE);
            UpgradeHandler upgradeHandler = UpgradeHandlerFactory.getUpgradeHandler(this.rbsConfigurationMao, this.moRepositoryWrapper, this.moFactoryMgrWrapper);
            result2 = upgradeHandler.performUpgrade(false, remoteUpgradePath);
        } else {
            String infoMsg = "No upgrade performed since no upgrade package was specified.";
            RbsConfigurationReportLoggerFactory.getLogger().logInformation("Upgrade", "No upgrade performed since no upgrade package was specified.");
            this.updateProgressReportInformation(500, 2, "No upgrade performed since no upgrade package was specified.", false);
            this.updateProgressReportInformation(600, 2, "No upgrade performed since no upgrade package was specified.", false);
            this.updateProgressReportInformation(700, 2, "No upgrade performed since no upgrade package was specified.", true);
            result2 = UpgradeResult.NO_UPGRADE;
        }
        logger.traceReturn(THIS_CLASS, "startUpgrade() upgrade result is " + result2.toString());
        return result2;
    }
}

