/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state;

import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import se.ericsson.cello.ipoam.IpHostLinkMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.OrbSupervisingThread;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.ResetHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.OssInformerHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.nodediscover.OssNodeDiscoveryException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.nodediscover.OssNodeDiscoveryResolver;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.nodediscover.OssNodeDiscoveryResolverFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.rollback.RollbackStack;
import se.ericsson.crbs.cat.mao.rbsconfiguration.rollback.RollbackStackImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.AbstractStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.StateHolder;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.SetNodeInterfaceNameTp;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.security.cppsec.esa.ExpressSecurityActivation;

public class VerifyOssConnectivityStateExecutor
extends AbstractStateExecutor {
    private static final Class THIS_CLASS = VerifyOssConnectivityStateExecutor.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final long ORB_RESTART_MAX_WAITING_TIME = 30000L;
    private static final long OSS_VERIFY_MAX_WAITING_TIME = 600L;
    private final ExpressSecurityActivation esa;
    private final Object esaLock;

    public VerifyOssConnectivityStateExecutor(RbsConfigurationMao inRbsConfigurationMao, ExpressSecurityActivation esaIn, Object esaLockIn) {
        super(THIS_CLASS.getName(), inRbsConfigurationMao, true, 73);
        this.esa = esaIn;
        this.esaLock = esaLockIn;
    }

    public void execute() {
        logger.traceEnter(THIS_CLASS, "execute()");
        RollbackStack rollbackStack = RollbackStackImpl.getInstance(this.rbsConfigurationMao, this.moRepositoryWrapper);
        boolean successful = this.verifyConnectivity(rollbackStack);
        if (successful) {
            this.stateHolder = new StateHolder(true, 75);
            rollbackStack.clearStack();
        } else {
            String failureSlogan = "Verify OSS connectivity failed.";
            ResetHelper rh = new ResetHelper(this.rbsConfigurationMao);
            rh.resetSecurityActivationAndRestartNode("Verify OSS connectivity failed.", this.esa, this.esaLock);
            this.stateHolder = new StateHolder(true, 0);
        }
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    private boolean verifyConnectivity(RollbackStack rollbackStack) {
        boolean successful = true;
        String ipHostLinkRdnValue = (String)this.rbsConfigurationMao.retrievePersistently("ipHostLinkRdnValue");
        if (this.useIpSecurityForOaM(ipHostLinkRdnValue)) {
            this.updateProgressReportInformation(1850, 3, "The step Verifying OSS Connectivity has been started.", true);
            IpHostLinkMo ipHostLinkMo = (IpHostLinkMo)this.rbsConfigurationContext.getMoRepositoryWrapper().lookup("ManagedElement=1,IpOam=1,Ip=1,IpHostLink=" + ipHostLinkRdnValue);
            if (ipHostLinkMo == null) {
                MoNotFoundException moNotFoundException = new MoNotFoundException("ManagedElement=1,IpOam=1,Ip=1,IpHostLink=" + ipHostLinkRdnValue);
                logger.traceError(this.getClass(), "Couldn't find MO <ipHostLinkMO>" + moNotFoundException.getMessage());
                this.setProgressReportToFailed((Exception)((Object)moNotFoundException));
                return false;
            }
            long startTime = System.currentTimeMillis();
            long elapsedTimeSec = 0L;
            Exception lastExcep = new Exception("Timeout during VerifyOSS Connectivity");
            while (true) {
                try {
                    this.verifyOssConnectivity(ipHostLinkRdnValue, rollbackStack);
                    this.updateProgressReportInformation(1850, 5, "The step Verifying OSS Connectivity is successfully finished.", true);
                    successful = true;
                }
                catch (MoNotFoundException e) {
                    successful = false;
                    logger.traceError(this.getClass(), e.getMessage());
                    this.setProgressReportToFailed(lastExcep);
                }
                catch (Exception e) {
                    successful = false;
                    lastExcep = e;
                    logger.traceGeneral(this.getClass(), "Failed to connect to OSS.");
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException e1) {
                        logger.traceError(this.getClass(), "sleep during connect to OSS failed " + e1.getMessage());
                        e1.printStackTrace();
                    }
                    elapsedTimeSec = (System.currentTimeMillis() - startTime) / 1000L;
                    logger.traceGeneral(this.getClass(), "elapsedTimeSec=" + elapsedTimeSec);
                    if (elapsedTimeSec <= 600L) continue;
                    successful = false;
                    this.setProgressReportToFailed(lastExcep);
                    logger.traceGeneral(this.getClass(), "Timeout no connection to OSS");
                }
                break;
            }
        }
        this.updateProgressReportInformation(1850, 2, "Ip step Verifying OSS Connectivity is not configured to be used.", true);
        logger.traceReturn(THIS_CLASS, "verifyConnectivity() " + successful);
        return successful;
    }

    private void setProgressReportToFailed(Exception lastExcep) {
        this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_PERMANENT_IPSEC_FOR_OAM_ACTIVATION_FAULT, "Verify OSS connectivity failed.", ExceptionHelper.getExceptionMessage((Throwable)lastExcep));
        this.updateProgressReportInformation(1850, 0, "Verify OSS connectivity failed.", true);
    }

    private void verifyOssConnectivity(String ipHostLinkRdnValue, RollbackStack rollbackStack) throws MoAccessException, RbsConfigurationFailedException, NotFound, CannotProceed, InvalidName, OssNodeDiscoveryException {
        Struct[] ipv6Addresses;
        IpHostLinkMo ipHostLinkMo = (IpHostLinkMo)this.moRepositoryWrapper.lookup("ManagedElement=1,IpOam=1,Ip=1,IpHostLink=" + ipHostLinkRdnValue);
        boolean isIpv6 = false;
        if (ipHostLinkMo != null && (ipv6Addresses = ipHostLinkMo.getIpv6Addresses(null)) != null && ipv6Addresses.length > 0 && ipv6Addresses[0].getValue("ipAddress") != null && ((String)ipv6Addresses[0].getValue("ipAddress")).trim().length() > 0) {
            isIpv6 = true;
        }
        OssInformerHelper informOssHelper = new OssInformerHelper(this.helper, this.moRepositoryWrapper, isIpv6);
        String nameServerAddress = informOssHelper.getOssAddress();
        int nameServerPort = 50073;
        String nodeDiscoveryServiceName = informOssHelper.getOssNodeDiscoveryServiceName();
        OrbSupervisingThread orbSupervisingThread = new OrbSupervisingThread();
        orbSupervisingThread.start();
        TransactionHandler.run(new SetNodeInterfaceNameTp(this.rbsConfigurationMao, this.rbsConfigurationContext.getGenericMaoContext(), ipHostLinkRdnValue, rollbackStack, true));
        try {
            logger.traceGeneral(THIS_CLASS, "Waiting for ORB to be restarted");
            orbSupervisingThread.join(30000L);
            if (!orbSupervisingThread.orbHasBeenDownAndComeUpAgain()) {
                logger.traceGeneral(this.getClass(), "The ORB did not go down and did not come up again within 30 seconds");
            }
        }
        catch (InterruptedException e) {
            logger.traceAbnormal(THIS_CLASS, "The ORB waiting was interrupted.");
        }
        OssNodeDiscoveryResolver ossNodeDiscoveryResolver = OssNodeDiscoveryResolverFactory.createOssNodeDiscoveryResolver(nameServerAddress, 50073, nodeDiscoveryServiceName, isIpv6);
        ossNodeDiscoveryResolver.verifyOssConnectivity();
    }

    private boolean useIpSecurityForOaM(String ipHostLinkRdnValue) {
        return ipHostLinkRdnValue != null && !"".equals(ipHostLinkRdnValue);
    }
}

