/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state;

import java.util.StringTokenizer;
import se.ericsson.cello.iptransport.GigaBitEthernetMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.IpParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.VlanIds;
import se.ericsson.crbs.cat.mao.rbsconfiguration.pbootparam.PbootParamProxyFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.AbstractStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.StateHolder;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.fetchsiteinstallation.SerialNumber;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.initialipconfiguration.fetchegisresponse.EgisStateMonitor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.vlanscan.CreateGigaBitEthernetMo;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.vlanscan.VlanScanProxy;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.vlanscan.VlanScanProxyFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.RestartNodeTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.SetAutoConfigurationAllowedTp;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class VlanScanStateExecutor
extends AbstractStateExecutor {
    private static final Class THIS_CLASS = VlanScanStateExecutor.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final int LINK_ONE_PRIMARY_LINK_TWO_SECONDARY = 0;
    private static final int MAC_ADDRESS_LENGTH = 6;
    private static final int SECOND = 1000;
    private static final int MINUTE = 60000;
    private static final int[] SLEEP_BEFORE_ATTEMPT = new int[]{0, 10000, 300000};
    private static final int TIMEOUT_FOR_VLAN_SCAN = 180000;
    private static final int MINUTES_BEFORE_NODE_RESTART_IF_FAILURE = 5;
    private static final int MILLISECS_BEFORE_NODE_RESTART_IF_FAILURE = 300000;
    private int[] sleepBeforeAttempt = SLEEP_BEFORE_ATTEMPT;
    private int timeoutForVlanScan = 180000;
    private int waitBeforeNodeRestartIfFailure = 300000;
    private boolean cancelled;

    public VlanScanStateExecutor(RbsConfigurationMao inRbsConfigurationMao) {
        super(THIS_CLASS.getName(), inRbsConfigurationMao, false, 10);
    }

    public void execute() {
        logger.traceEnter(THIS_CLASS, "execute()");
        if (!this.doPerformVlanScan()) {
            this.updateProgressReportInformation(20, 2, "VLAN scan skipped as vlanId is already known", true);
            this.stateHolder = new StateHolder(true, 11);
        } else if (this.isAIpHostLinkInstance()) {
            this.updateProgressReportInformation(20, 2, "VLAN scan skipped and AI stopped as there is a configured IP stack", true);
            this.stateHolder = new StateHolder(false, 0);
        } else {
            int[] arrayOfVlanIds = null;
            GigaBitEthernetMo gigaBitEthernetMo = null;
            int attempt = 0;
            while (!(arrayOfVlanIds != null && arrayOfVlanIds.length != 0 || this.cancelled)) {
                block23: {
                    String macAddress = null;
                    int[] macAddressIntArray = null;
                    String serialNumber = null;
                    int progressReportAction = attempt == 0 ? 3 : 4;
                    this.updateProgressReportInformation(20, progressReportAction, "Prepare VLAN scan", true);
                    try {
                        this.sleepBeforeNextAttempt(attempt, progressReportAction);
                        if (this.cancelled) break block23;
                        try {
                            gigaBitEthernetMo = this.createGigaBitEthernetIfNotExistsOrNotOperational(gigaBitEthernetMo, progressReportAction);
                        }
                        catch (MoAccessException mae) {
                            logger.traceDebug(THIS_CLASS, "MoAccessExeption thrown by createGigaBitEthernetIfNotExistsOrNotOperational");
                        }
                        if (gigaBitEthernetMo == null || this.cancelled) break block23;
                        try {
                            macAddress = this.getMacAddress(gigaBitEthernetMo);
                            macAddressIntArray = this.convertMacAddressToIntArray(macAddress);
                        }
                        catch (MoAccessException mae) {
                            logger.traceDebug(THIS_CLASS, "MoAccessExeption thrown by getMacAddress(gigaBitEthernetMo)");
                        }
                        try {
                            serialNumber = PbootParamProxyFactory.getPbootParamProxy().getPbootParameter("fru_serialnumber");
                            if (serialNumber == null) {
                                logger.traceDebug(THIS_CLASS, "fru_serialnumber not found in PBOOT parameters, trying to find serialnumber");
                                serialNumber = PbootParamProxyFactory.getPbootParamProxy().getPbootParameter("serialnumber");
                                if (serialNumber == null) {
                                    logger.traceError(THIS_CLASS, "serialnumber not found in PBOOT parameters also");
                                    serialNumber = this.getSerialNumber();
                                }
                            }
                            logger.traceDebug(THIS_CLASS, "HW serial number is: " + serialNumber);
                        }
                        catch (MoAccessException mae) {
                            logger.traceDebug(THIS_CLASS, "MoAccessExeption thrown by getSerialNumber()");
                        }
                        if (this.cancelled) break block23;
                        logger.traceDebug(THIS_CLASS, "Attempting a VLAN scan, mac address: " + macAddress);
                        this.updateProgressReportInformation(20, progressReportAction, "Perform VLAN scan", true);
                        VlanScanProxyFactory.getVlanScanProxy().huntForVlanScanProcess();
                        try {
                            arrayOfVlanIds = VlanScanProxyFactory.getVlanScanProxy().performVlanScan(macAddressIntArray, this.convertSerialNumberToArray(serialNumber), this.timeoutForVlanScan);
                            if (!this.cancelled) {
                                this.setVlanIds(arrayOfVlanIds, attempt);
                            }
                        }
                        catch (MoAccessException mae) {
                            this.updateProgressReportInformation(20, 0, "VLAN scan failed at attempt " + (attempt + 1) + ": " + (Object)((Object)mae), true);
                            logger.traceDebug(THIS_CLASS, "Failed to perform VLAN scan at attempt: " + (attempt + 1) + ", reason:" + (Object)((Object)mae));
                        }
                    }
                    catch (MoAccessException mae2) {
                        this.restartNode(attempt, mae2);
                        arrayOfVlanIds = null;
                        break;
                    }
                }
                ++attempt;
            }
            if (this.cancelled) {
                this.updateProgressReportInformation(20, 0, "VLAN scan was cancelled", true);
                new CreateGigaBitEthernetMo().deleteGigabitEthernetMoTraceExceptions(this.rbsConfigurationMao.getRbsConfigurationContext().getGenericMaoContext());
                this.stateHolder = new StateHolder(false, 0);
            } else if (VlanIds.instance(this.rbsConfigurationMao).getVlanIds().length > 0) {
                this.updateProgressReportInformation(20, 5, "VLanIds: " + this.convertVlanIdsToString(VlanIds.instance().getVlanIds()), true);
                this.stateHolder = new StateHolder(true, 11);
            }
        }
        SetAutoConfigurationAllowedTp setAutoConfigurationAllowed = new SetAutoConfigurationAllowedTp(this.rbsConfigurationMao.getRbsConfigurationContext().getGenericMaoContext(), true);
        try {
            TransactionHandler.run(setAutoConfigurationAllowed);
        }
        catch (RbsConfigurationFailedException rcfe) {
            String msg = "Could not activate autoConfiguration on Mo ManagedElementData.";
            this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, "Environment fault", "Could not activate autoConfiguration on Mo ManagedElementData.");
            logger.traceError(THIS_CLASS, "setAutoConfigurationAllowed():Could not activate autoConfiguration on Mo ManagedElementData. Original exception: " + rcfe.getVariablesAsString());
        }
        EgisStateMonitor.getInstance().setIsEgisResponseFetched(false);
        EgisStateMonitor.getInstance().setEgisExecuted(false);
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prepareNodeRestart() {
        logger.traceEnter(THIS_CLASS, "prepareNodeRestart()");
        VlanScanStateExecutor vlanScanStateExecutor = this;
        synchronized (vlanScanStateExecutor) {
            this.cancelled = true;
            try {
                VlanScanProxy vlanScanProxy = VlanScanProxyFactory.getVlanScanProxy();
                vlanScanProxy.huntForVlanScanProcess();
                vlanScanProxy.cancelVlanScan();
            }
            catch (RbsConfigurationFailedException rcfe) {
                logger.traceDebug(THIS_CLASS, "Failed to cancel VLAN scan, reason:" + (Object)((Object)rcfe));
            }
            this.notifyAll();
        }
        boolean result2 = false;
        logger.traceReturn(THIS_CLASS, "prepareNodeRestart() false");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void sleepBeforeNextAttempt(int attempt, int progressReportAction) {
        logger.traceEnter(THIS_CLASS, "sleepBeforeAttempt() attempt:" + attempt);
        long startAt = System.currentTimeMillis();
        VlanScanStateExecutor vlanScanStateExecutor = this;
        synchronized (vlanScanStateExecutor) {
            if (!this.cancelled) {
                int milliSeconds = attempt < this.sleepBeforeAttempt.length ? this.sleepBeforeAttempt[attempt] : this.sleepBeforeAttempt[this.sleepBeforeAttempt.length - 1];
                logger.traceDebug(THIS_CLASS, "sleepBeforeAttempt() " + milliSeconds + "ms");
                if (milliSeconds > 0) {
                    String timeStr = milliSeconds >= 60000 ? milliSeconds / 60000 + " minute(s)" : (milliSeconds >= 1000 ? milliSeconds / 1000 + " seconds(s)" : milliSeconds + " ms");
                    String msg = "Retrying VLAN scan in " + timeStr;
                    logger.traceDebug(THIS_CLASS, "sleepBeforeAttempt() " + msg);
                    this.updateProgressReportInformation(20, progressReportAction, "Retry VLAN scan in " + timeStr, true);
                    try {
                        this.wait(milliSeconds);
                    }
                    catch (InterruptedException ie) {
                        logger.traceDebug(THIS_CLASS, "Interrupted while waiting: " + ie.getMessage());
                    }
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "sleepBeforeAttempt() " + (System.currentTimeMillis() - startAt) + "ms");
    }

    private GigaBitEthernetMo createGigaBitEthernetIfNotExistsOrNotOperational(GigaBitEthernetMo gigaBitEthernetMo, int progressReportAction) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "createGigaBitEthernetIfNotExistsOrNotOperational()");
        if (gigaBitEthernetMo == null || gigaBitEthernetMo.getOperationalState(null) != 1) {
            this.updateProgressReportInformation(20, progressReportAction, "Create GigaBitEthernet MO", true);
            gigaBitEthernetMo = new CreateGigaBitEthernetMo().createNewGigabitEthernetMoInstance(this.rbsConfigurationMao.getRbsConfigurationContext().getGenericMaoContext());
        }
        logger.traceReturn(THIS_CLASS, "createGigaBitEthernetIfNotExistsOrNotOperational()");
        return gigaBitEthernetMo;
    }

    final String getMacAddress(GigaBitEthernetMo gigaBitEthernetMo) throws MoAccessException {
        return 0 == gigaBitEthernetMo.getPrimaryLink(null) ? gigaBitEthernetMo.getMacAddressLink1(null) : gigaBitEthernetMo.getMacAddressLink2(null);
    }

    private void restartNode(int attempt, MoAccessException mae) {
        String msg = "Node will restart in 5 minutes, VLAN scan failed and terminated at attempt " + (attempt + 1) + ", reason: " + (Object)((Object)mae);
        this.updateProgressReportInformation(20, 0, msg, true);
        logger.traceDebug(THIS_CLASS, msg);
        this.stateHolder = new StateHolder(false, 0);
        try {
            logger.traceDebug(THIS_CLASS, "Sleep for " + this.waitBeforeNodeRestartIfFailure + " millisecs");
            Thread.sleep(this.waitBeforeNodeRestartIfFailure);
            logger.traceDebug(THIS_CLASS, "Done sleeping");
        }
        catch (InterruptedException ie) {
            logger.traceDebug(THIS_CLASS, "Interrupted while sleeping 300000: " + ie.getMessage());
        }
        TransactionHandler.runWithLoopWithoutException(new RestartNodeTp(this.rbsConfigurationMao, "VLAN scan failed", "Node restart due to VLAN scan failure"));
    }

    private void setVlanIds(int[] arrayOfVlanIds, int attempt) {
        VlanIds.instance(this.rbsConfigurationMao).setVlanIds(arrayOfVlanIds);
        RbsConfigurationReportLoggerFactory.getLogger().logAction("GigaBitEthernet", "VLAN scan", new String[]{"macAddress", "attempt", "vlanIds"}, new String[]{"macAddress", Integer.toString(attempt + 1), this.convertVlanIdsToString(arrayOfVlanIds)});
    }

    private boolean doPerformVlanScan() {
        int vlanId = IpParameters.instance(this.rbsConfigurationMao).getVlanId();
        return vlanId == -2;
    }

    private boolean isAIpHostLinkInstance() {
        MoIterator moIt = this.rbsConfigurationMao.getRbsConfigurationContext().getGenericMaoContext().getMoRepositoryWrapper().lookupType("IpHostLink");
        return moIt != null && moIt.hasMoreElements();
    }

    public void setSleepBeforeAttempt(int[] sleepBeforeAttemptIn) {
        this.sleepBeforeAttempt = sleepBeforeAttemptIn;
    }

    public void setTimeoutForVlanScan(int timeoutForVlanScanIn) {
        this.timeoutForVlanScan = timeoutForVlanScanIn;
    }

    public void setWaitBeforeNodeRestartIfFailure(int waitBeforeNodeRestartIfFailureIn) {
        this.waitBeforeNodeRestartIfFailure = waitBeforeNodeRestartIfFailureIn;
    }

    private int[] convertMacAddressToIntArray(String macAddress) {
        int[] intArray = new int[6];
        StringTokenizer st = new StringTokenizer(macAddress, ":");
        for (int i = 0; i < 6 && st.hasMoreElements(); ++i) {
            intArray[i] = Integer.parseInt((String)st.nextElement(), 16);
        }
        return intArray;
    }

    final String getSerialNumber() throws MoAccessException {
        SerialNumber serialNumber = new SerialNumber();
        return serialNumber.getSerialNumber(this.moRepositoryWrapper, null);
    }

    final int[] convertSerialNumberToArray(String serialNumber) throws MoAccessException {
        byte[] serialNumberBytes = serialNumber.getBytes();
        int[] serialNumberInt = new int[serialNumber.length()];
        for (int i = 0; i < serialNumber.length(); ++i) {
            serialNumberInt[i] = serialNumberBytes[i];
        }
        return serialNumberInt;
    }

    private String convertVlanIdsToString(int[] inVlanIds) {
        StringBuffer result2 = new StringBuffer();
        if (inVlanIds != null) {
            for (int i = 0; inVlanIds != null && i < inVlanIds.length; ++i) {
                result2.append((i > 0 ? "," : "") + inVlanIds[i]);
            }
        }
        return result2.toString();
    }
}

