/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state;

import java.util.ArrayList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.AbstractStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.StateHolder;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class WaitForCellsToBeEnabledStateExecutor
extends AbstractStateExecutor {
    private static final String DISABLED_STR = "DISABLED";
    private static final String ENABLED_STR = "ENABLED";
    private static final Class THIS_CLASS = WaitForCellsToBeEnabledStateExecutor.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final long WAIT_FOR_NEXT_RETRY_INTERVAL = 10000L;
    protected static final String RESERVED_BY_ATTR = "reservedBy";
    protected static final String OPERATIONAL_STATE_ATTR = "operationalState";
    protected static final Integer ENABLED = new Integer(1);
    private long retryInterval = 10000L;

    public WaitForCellsToBeEnabledStateExecutor(RbsConfigurationMao inRbsConfigurationMao) {
        super(THIS_CLASS.getName(), inRbsConfigurationMao, true, 120);
    }

    public void execute() {
        logger.traceEnter(THIS_CLASS, "execute()");
        this.updateProgressReportInformation(2550, 3, "Waiting for sectors and cells to be operational", true);
        String modeStr = (String)this.rbsConfigurationMao.retrievePersistently("modeForExecution");
        if (modeStr.equals("TMR")) {
            String progressMessage = "Entering TMR mode, sectors and cells are not required";
            this.updateProgressReportInformation(2550, 5, "Entering TMR mode, sectors and cells are not required", true);
            RbsConfigurationReportLoggerImpl rbsConfigurationReportLoggerImpl = RbsConfigurationReportLoggerImpl.getInstance();
            rbsConfigurationReportLoggerImpl.logInformation("Service State", "Sectors and Cells not required!");
        } else if (modeStr.equals("XMU")) {
            this.waitForSectorsWithoutCellsToBeEnabled();
        } else if (modeStr.equals("GEOCHECKERROR")) {
            String progressMessage = "Cells are not unlocked because of Geo Location Check fault!";
            this.updateProgressReportInformation(2550, 2, "Cells are not unlocked because of Geo Location Check fault!", true);
            RbsConfigurationReportLoggerImpl rbsConfigurationReportLoggerImpl = RbsConfigurationReportLoggerImpl.getInstance();
            rbsConfigurationReportLoggerImpl.logInformation("Service State", "Cells are not unlocked because of Geo Location Check fault!");
        } else {
            this.waitForSectorsAndTheirCellsToBeEnabled();
        }
        this.stateHolder = new StateHolder(true, 130);
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForSectorsAndTheirCellsToBeEnabled() {
        logger.traceEnter(THIS_CLASS, "waitForSectorsAndTheirCellsToBeEnabled()");
        boolean allSectorAndCellsEnabled = false;
        while (!allSectorAndCellsEnabled) {
            try {
                String progressMessage;
                SectorEquipmentFunctionMoHolder[] sectorEquipmentFunctionMos = this.getSectorEquipmentFunctionMos();
                allSectorAndCellsEnabled = this.checkIfAllSectorsAndCellsAreEnabled(sectorEquipmentFunctionMos);
                if (allSectorAndCellsEnabled) {
                    progressMessage = "All sectors and cells are up and available";
                    this.updateProgressReportInformation(2600, 5, "All sectors and cells are up and available", true);
                    RbsConfigurationReportLoggerImpl rbsConfigurationReportLoggerImpl = RbsConfigurationReportLoggerImpl.getInstance();
                    rbsConfigurationReportLoggerImpl.logInformation("Service State", "Cells are ready to carry traffic");
                    continue;
                }
                progressMessage = this.getProgressMessage(sectorEquipmentFunctionMos);
                logger.traceEnter(THIS_CLASS, "Trace from HR89617");
                this.updateProgressReportInformation(2600, 4, progressMessage, true);
            }
            catch (Exception e) {
                String errorMessage = "Failed to determine whether all sector and cells are up and running or not due to: " + ExceptionHelper.getExceptionMessage((Throwable)e) + "\nWill retry...";
                this.updateProgressReportInformation(2600, 4, errorMessage, true);
                logger.traceAbnormal(THIS_CLASS, errorMessage);
            }
            finally {
                if (allSectorAndCellsEnabled) continue;
                try {
                    Thread.sleep(this.retryInterval);
                }
                catch (Exception ignore) {
                    logger.traceAbnormal(THIS_CLASS, "Wait thread killed");
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "waitForSectorsAndTheirCellsToBeEnabled()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForSectorsWithoutCellsToBeEnabled() {
        logger.traceEnter(THIS_CLASS, "waitForSectorsWithoutCellsToBeEnabled()");
        boolean allSectorsWithoutCellsEnabled = false;
        while (!allSectorsWithoutCellsEnabled) {
            try {
                String progressMessage;
                SectorEquipmentFunctionMoHolder[] sectorEquipmentFunctionMos = this.getSectorEquipmentFunctionMos();
                allSectorsWithoutCellsEnabled = this.checkIfAllSectorsWihtoutCellsAreEnabled(sectorEquipmentFunctionMos);
                if (allSectorsWithoutCellsEnabled) {
                    progressMessage = "All sectors without cells are up and available";
                    this.updateProgressReportInformation(2550, 5, "All sectors without cells are up and available", true);
                    RbsConfigurationReportLoggerImpl rbsConfigurationReportLoggerImpl = RbsConfigurationReportLoggerImpl.getInstance();
                    rbsConfigurationReportLoggerImpl.logInformation("Service State", "Sectors are ready without cells");
                    continue;
                }
                progressMessage = this.getProgressMessage(sectorEquipmentFunctionMos);
                this.updateProgressReportInformation(2550, 4, progressMessage, true);
            }
            catch (MoAccessException e) {
                String errorMessage = "Failed to determine whether all sectors are up and running or not due to: " + ExceptionHelper.getExceptionMessage((Throwable)e) + "\nWill retry...";
                this.updateProgressReportInformation(2550, 4, errorMessage, true);
                logger.traceAbnormal(THIS_CLASS, errorMessage);
            }
            finally {
                if (allSectorsWithoutCellsEnabled) continue;
                try {
                    Thread.sleep(this.retryInterval);
                }
                catch (Exception ignore) {
                    logger.traceAbnormal(THIS_CLASS, "Wait thread killed");
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "waitForSectorsWithoutCellsToBeEnabled()");
    }

    private boolean checkIfAllSectorsWihtoutCellsAreEnabled(SectorEquipmentFunctionMoHolder[] sectorEquipmentFunctionMos) {
        logger.traceEnter(THIS_CLASS, "checkIfAllSectorsWihtoutCellsAreEnabled()");
        boolean allSectorsEnabled = sectorEquipmentFunctionMos.length > 0;
        for (int i = 0; i < sectorEquipmentFunctionMos.length; ++i) {
            boolean bl = allSectorsEnabled = allSectorsEnabled && sectorEquipmentFunctionMos[i].enabled;
            if (!allSectorsEnabled) break;
        }
        logger.traceReturn(THIS_CLASS, "checkIfAllSectorsWihtoutCellsAreEnabled()");
        return allSectorsEnabled;
    }

    protected void setRetryInterval(long inputRetryInterval) {
        this.retryInterval = inputRetryInterval;
    }

    protected boolean checkIfAllSectorsAndCellsAreEnabled(SectorEquipmentFunctionMoHolder[] sectorEquipmentFunctionMos) {
        logger.traceEnter(THIS_CLASS, "checkIfAllSectorsAndCellsAreEnabled()");
        boolean allSectorsEnabled = sectorEquipmentFunctionMos.length > 0;
        block0: for (int i = 0; i < sectorEquipmentFunctionMos.length; ++i) {
            boolean bl = allSectorsEnabled = allSectorsEnabled && sectorEquipmentFunctionMos[i].enabled;
            if (!allSectorsEnabled) break;
            for (int j = 0; j < sectorEquipmentFunctionMos[i].eUtranCells.length; ++j) {
                boolean bl2 = allSectorsEnabled = allSectorsEnabled && sectorEquipmentFunctionMos[i].eUtranCells[j].enabled;
                if (!allSectorsEnabled) continue block0;
            }
        }
        logger.traceReturn(THIS_CLASS, "checkIfAllSectorsAndCellsAreEnabled()");
        return allSectorsEnabled;
    }

    protected String getProgressMessage(SectorEquipmentFunctionMoHolder[] sectorEquipmentFunctionMos) throws MoAccessException {
        StringBuffer progressMessage = new StringBuffer(1500);
        for (int i = 0; i < sectorEquipmentFunctionMos.length; ++i) {
            progressMessage.append("Sector: ");
            progressMessage.append(sectorEquipmentFunctionMos[i].managedObject.getLocalDistinguishedName());
            progressMessage.append(": ");
            progressMessage.append(sectorEquipmentFunctionMos[i].enabled ? ENABLED_STR : DISABLED_STR);
            if (sectorEquipmentFunctionMos[i].eUtranCells.length > 0 && sectorEquipmentFunctionMos[i].eUtranCells != null) {
                for (int j = 0; j < sectorEquipmentFunctionMos[i].eUtranCells.length; ++j) {
                    progressMessage.append("\n\tCell: ");
                    progressMessage.append(sectorEquipmentFunctionMos[i].eUtranCells[j].managedObject.getLocalDistinguishedName());
                    progressMessage.append(": ");
                    progressMessage.append(sectorEquipmentFunctionMos[i].eUtranCells[j].enabled ? ENABLED_STR : DISABLED_STR);
                }
            }
            if (i >= sectorEquipmentFunctionMos.length - 1) continue;
            progressMessage.append('\n');
        }
        return progressMessage.toString();
    }

    protected SectorEquipmentFunctionMoHolder[] getSectorEquipmentFunctionMos() throws MoAccessException {
        MoIterator moIterator = this.rbsConfigurationContext.getMoRepositoryWrapper().lookupType("SectorEquipmentFunction");
        ArrayList<SectorEquipmentFunctionMoHolder> sectorsList = new ArrayList<SectorEquipmentFunctionMoHolder>();
        while (moIterator != null && moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            Object operationalStateObject = managedObject.getAttribute(OPERATIONAL_STATE_ATTR, null);
            boolean operationalStatedEnabled = false;
            if (operationalStateObject != null && operationalStateObject instanceof Integer) {
                Integer operationalState = (Integer)operationalStateObject;
                operationalStatedEnabled = operationalState.intValue() == ENABLED.intValue();
            }
            EUtranCellMoHolder[] eUtranCellMoHolders = this.getEUtranCellMos(managedObject);
            sectorsList.add(new SectorEquipmentFunctionMoHolder(managedObject, eUtranCellMoHolders, operationalStatedEnabled));
        }
        SectorEquipmentFunctionMoHolder[] sectorEquipmentFunctionMoHolders = new SectorEquipmentFunctionMoHolder[sectorsList.size()];
        sectorsList.toArray(sectorEquipmentFunctionMoHolders);
        return sectorEquipmentFunctionMoHolders;
    }

    private EUtranCellMoHolder[] getEUtranCellMos(ManagedObject sectorEquipmentFunction) throws MoAccessException {
        ArrayList<EUtranCellMoHolder> cellsList = new ArrayList<EUtranCellMoHolder>();
        Object reservedByObject = sectorEquipmentFunction.getAttribute(RESERVED_BY_ATTR, null);
        if (reservedByObject != null && reservedByObject instanceof ManagedObject[]) {
            ManagedObject[] managedObjects = (ManagedObject[])reservedByObject;
            for (int j = 0; j < managedObjects.length; ++j) {
                Object operationalStateObject = managedObjects[j].getAttribute(OPERATIONAL_STATE_ATTR, null);
                boolean operationalStatedEnabled = false;
                if (operationalStateObject != null && operationalStateObject instanceof Integer) {
                    Integer operationalState = (Integer)operationalStateObject;
                    operationalStatedEnabled = operationalState.intValue() == ENABLED.intValue();
                }
                cellsList.add(new EUtranCellMoHolder(managedObjects[j], operationalStatedEnabled));
            }
        }
        EUtranCellMoHolder[] eUtranCellMoHolders = new EUtranCellMoHolder[cellsList.size()];
        cellsList.toArray(eUtranCellMoHolders);
        return eUtranCellMoHolders;
    }

    protected static class EUtranCellMoHolder {
        public final ManagedObject managedObject;
        public final boolean enabled;

        public EUtranCellMoHolder(ManagedObject inputManagedObject, boolean inputEnabled) {
            this.managedObject = inputManagedObject;
            this.enabled = inputEnabled;
        }
    }

    protected static class SectorEquipmentFunctionMoHolder {
        public final ManagedObject managedObject;
        public final EUtranCellMoHolder[] eUtranCells;
        public final boolean enabled;

        public SectorEquipmentFunctionMoHolder(ManagedObject inputSectorEquipmentFunction, EUtranCellMoHolder[] inputEUtranCells, boolean inputEnabled) {
            this.managedObject = inputSectorEquipmentFunction;
            this.eUtranCells = inputEUtranCells;
            this.enabled = inputEnabled;
        }
    }
}

