/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state;

import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.geolocationcheck.GeoLocationCheckHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.geolocationcheck.GeoLocationCheckHandlerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationMmeHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.AbstractStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.StateHolder;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class WaitForGeoLocationCheckStateExecutor
extends AbstractStateExecutor {
    private final int GEO_CHECK_NOT_STARTED = 0;
    private static final Class THIS_CLASS = WaitForGeoLocationCheckStateExecutor.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected GeoLocationCheckHandler geoLocationCheckHandler = null;

    public WaitForGeoLocationCheckStateExecutor(RbsConfigurationMao inRbsConfigurationMao) {
        super(THIS_CLASS.getName(), inRbsConfigurationMao, true, 115);
    }

    public void execute() {
        logger.traceEnter(THIS_CLASS, "execute()");
        RbsConfigurationMmeHelper mmeHelper = (RbsConfigurationMmeHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationMmeHelper.class);
        Integer waitForGeoCheck = mmeHelper.waitForGeoCheck();
        if (RbsConfigurationDefinitions.RBS_CL_GPS_CHECK_POSITION.equals(waitForGeoCheck)) {
            Integer geoCheckResult;
            this.updateProgressReportInformation(2540, 3, "Performing Geographic Location Check", true);
            Integer nextConfigLevel = geoCheckResult = this.waitForGeoCheckResult();
            if (geoCheckResult == RbsConfigurationDefinitions.RBS_CL_GPS_MISMATCH_ERROR || geoCheckResult == RbsConfigurationDefinitions.RBS_CL_GPS_UNAVAILABLE) {
                String warningMessage = "No current position could be retrieved.";
                if (geoCheckResult == RbsConfigurationDefinitions.RBS_CL_GPS_MISMATCH_ERROR) {
                    warningMessage = "The current position was not sucessfully matched to wanted position.";
                }
                try {
                    this.rbsConfigurationMao.storePersistently("modeForExecution", "GEOCHECKERROR");
                    this.updateProgressReportInformation(2540, 6, warningMessage, true);
                }
                catch (MoAccessException e) {
                    String errorMessage = "Failed while waiting for Geographic Location Check due to: " + ExceptionHelper.getExceptionMessage((Throwable)e) + "\nExiting...";
                    this.updateProgressReportInformation(2540, 0, errorMessage, true);
                    logger.traceAbnormal(THIS_CLASS, errorMessage);
                }
            } else if (geoCheckResult == RbsConfigurationDefinitions.RBS_CL_GPS_SUCCESSFULLY_MATCHED) {
                String logMessage = "Geographic Location Check was successful";
                logger.traceGeneral(THIS_CLASS, "Geographic Location Check was successful");
                this.updateProgressReportInformation(2540, 5, "Geographic Location Check was successful", true);
            } else if (geoCheckResult == RbsConfigurationDefinitions.RBS_CL_GPS_WANTED_POSITION_NOT_SET) {
                String logMessage = "WantedPosition not set, skipping Geographic Location Check";
                logger.traceGeneral(THIS_CLASS, "WantedPosition not set, skipping Geographic Location Check");
                this.updateProgressReportInformation(2540, 2, "WantedPosition not set, skipping Geographic Location Check", true);
            } else {
                nextConfigLevel = RbsConfigurationDefinitions.RBS_CL_GPS_WANTED_POSITION_NOT_SET;
                String errorMessage = "Geographic Location Check not performed";
                this.updateProgressReportInformation(2540, 0, "Geographic Location Check not performed", true);
                logger.traceAbnormal(THIS_CLASS, "Geographic Location Check not performed");
            }
            this.helper.setRbsConfigLevel(nextConfigLevel);
        } else {
            this.updateProgressReportInformation(2540, 2, "OSS does not support Geographic Location Check, skipping.", true);
        }
        this.stateHolder = new StateHolder(true, 120);
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    private Integer waitForGeoCheckResult() {
        logger.traceEnter(THIS_CLASS, "waitForGeoCheckResult()");
        this.geoLocationCheckHandler = GeoLocationCheckHandlerFactory.getInstance().getGeoLocationCheckHandler();
        if (this.geoLocationCheckHandler == null) {
            logger.traceAbnormal(THIS_CLASS, "geoLocationCheckHandler == null in waitForGeoCheckResult");
            return new Integer(0);
        }
        while (!this.geoLocationCheckHandler.resultReady()) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                logger.traceDebug(THIS_CLASS, "Thread interrupted in unexpected state!");
            }
        }
        logger.traceReturn(THIS_CLASS, "waitForGeoCheckResult()");
        return this.geoLocationCheckHandler.geoLocationCheckResult();
    }
}

