/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state;

import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.security.AbstractIpSecThread;
import se.ericsson.crbs.cat.mao.rbsconfiguration.security.IpSecThreadFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.AbstractStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.StateHolder;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class WaitForIpSecurityThreadStateExecutor
extends AbstractStateExecutor {
    private static final Class THIS_CLASS = WaitForIpSecurityThreadStateExecutor.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private AbstractIpSecThread ipSecConfigThread;

    public WaitForIpSecurityThreadStateExecutor(RbsConfigurationMao inRbsConfigurationMao, AbstractIpSecThread inIpSecConfigThread) {
        super(THIS_CLASS.getName(), inRbsConfigurationMao, true, 70);
        this.ipSecConfigThread = inIpSecConfigThread;
    }

    public void execute() {
        logger.traceEnter(THIS_CLASS, "execute()");
        if (this.ipSecConfigThread == null && this.stateHandler.checkOkToStartIpSecThread()) {
            logger.traceDebug(THIS_CLASS, "IP Security config thread was null meaning the JVM restarted...");
            this.ipSecConfigThread = IpSecThreadFactory.getInstance().getIpSecThread(this.rbsConfigurationMao);
            logger.traceDebug(THIS_CLASS, "NEW IP Security config thread is " + this.ipSecConfigThread);
            this.ipSecConfigThread.start();
        }
        if (this.ipSecConfigThread == null) {
            logger.traceDebug(THIS_CLASS, "ipSecConfigThread is somehow still null");
        } else {
            this.waitForIpSecThread();
        }
        this.stateHolder = new StateHolder(true, 72);
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    private void waitForIpSecThread() {
        logger.traceEnter(THIS_CLASS, "waitForIpSecThread()");
        while (this.ipSecConfigThread.isAlive()) {
            try {
                logger.traceGeneral(THIS_CLASS, "Waiting for IP Sec. preparation thread to terminate...");
                this.ipSecConfigThread.join(2500L);
            }
            catch (InterruptedException e1) {
                logger.traceAbnormal(THIS_CLASS, "Main thread interrupted.  " + e1.getStackTrace() + "\n Resuming waiting.");
            }
        }
        logger.traceGeneral(THIS_CLASS, "IpSec thread terminated");
        logger.traceReturn(THIS_CLASS, "waitForIpSecThread()");
    }
}

