/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state;

import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationMmeHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.AbstractStateExecutor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.StateHolder;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class WaitForS1StateExecutor
extends AbstractStateExecutor {
    private static final Class THIS_CLASS = WaitForS1StateExecutor.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public WaitForS1StateExecutor(RbsConfigurationMao inRbsConfigurationMao) {
        super(THIS_CLASS.getName(), inRbsConfigurationMao, true, 100);
    }

    public void execute() {
        logger.traceEnter(THIS_CLASS, "execute()");
        RbsConfigurationMmeHelper mmeHelper = (RbsConfigurationMmeHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationMmeHelper.class);
        try {
            mmeHelper.waitForS1();
        }
        catch (MoAccessException e) {
            String errorMessage = "Failed while waiting for S1 due to: " + ExceptionHelper.getExceptionMessage((Throwable)e) + "\nExiting...";
            this.updateProgressReportInformation(2500, 0, errorMessage, true);
            logger.traceAbnormal(THIS_CLASS, errorMessage);
        }
        String modeStr = (String)this.rbsConfigurationMao.retrievePersistently("modeForExecution");
        if (modeStr.equals("STANDARD")) {
            this.stateHolder = new StateHolder(true, 115);
        } else {
            this.updateProgressReportInformation(2540, 2, "Geographic Location Check skipped since node is in TMR or XMU mode.", true);
            this.stateHolder = new StateHolder(true, 120);
        }
        logger.traceReturn(THIS_CLASS, "execute()");
    }
}

