/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state.fetchsiteinstallation;

import java.io.IOException;
import se.ericsson.cello.iptransport.AccessControlListMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.accesscontrol.AccessControl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.FileParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.IpParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.AclEntriesData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.StructImpl;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;

public class AddOrModifySshSmrsEntryInAccessControlListTp
implements TransactionPackage,
AccessControl {
    private static final Class THIS_CLASS = AddOrModifySshSmrsEntryInAccessControlListTp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final RbsConfigurationMao rbsConfigurationMao;
    private final GenericMaoContext genericMaoContext;
    private final String oldIpAddress;

    public AddOrModifySshSmrsEntryInAccessControlListTp(RbsConfigurationMao rbsConfigurationMaoIn, GenericMaoContext genericMaoContextIn, String oldIpAddressIn) {
        this.rbsConfigurationMao = rbsConfigurationMaoIn;
        this.genericMaoContext = genericMaoContextIn;
        this.oldIpAddress = oldIpAddressIn;
    }

    public void execute(Coordinator coordinator) throws MoAccessException, InactiveTransactionException {
        logger.traceEnter(THIS_CLASS, "AddOrModifySshSmrsEntryInAccessControlList.execute()");
        AccessControlListMo initAclMo = (AccessControlListMo)this.genericMaoContext.getMoRepositoryWrapper().lookup("ManagedElement=1,IpSystem=1,AccessControlList=initAcl");
        if (initAclMo != null && !this.updateSshAclEntryIfExists(initAclMo, coordinator)) {
            this.addSshAclEntry(initAclMo, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "AddOrModifySshSmrsEntryInAccessControlList.execute()");
    }

    private boolean updateSshAclEntryIfExists(AccessControlListMo initAclMo, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "AddOrModifySshSmrsEntryInAccessControlList.updateSshAclEntryIfExists()");
        boolean updated = false;
        Struct[] aclEntries = initAclMo.getAclEntries(coordinator);
        if (aclEntries != null && aclEntries.length > 0) {
            Struct[] updatedAlcEntries = new Struct[aclEntries.length];
            for (int listIndex = 0; listIndex < aclEntries.length; ++listIndex) {
                if (!updated) {
                    Integer remotePort = (Integer)aclEntries[listIndex].getValue("remotePort");
                    if (!PORT_SSH_VALUE.equals(remotePort)) continue;
                    String locIpAddr = (String)aclEntries[listIndex].getValue("localIpAddress");
                    String remIpAddr = (String)aclEntries[listIndex].getValue("remoteIpAddress");
                    if (!this.oldIpAddress.equals(locIpAddr) || "0.0.0.0".equals(remIpAddr)) continue;
                    StructImpl updatedSshEntry = new StructImpl(aclEntries[listIndex].getNames(), aclEntries[listIndex].getValues());
                    updatedSshEntry.setValue("localIpAddress", (Object)IpParameters.instance(this.rbsConfigurationMao).getIpAddress());
                    updatedSshEntry.setValue("remoteIpAddress", (Object)FileParameters.instance(this.rbsConfigurationMao).getSmrsAddress());
                    updatedAlcEntries[listIndex] = updatedSshEntry;
                    updated = true;
                    continue;
                }
                updatedAlcEntries[listIndex] = aclEntries[listIndex];
            }
            if (updated) {
                initAclMo.setAclEntries(updatedAlcEntries, coordinator);
            }
        }
        logger.traceReturn(THIS_CLASS, "AddOrModifySshSmrsEntryInAccessControlList.execute() " + updated);
        return updated;
    }

    private void addSshAclEntry(AccessControlListMo initAclMo, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "AddOrModifySshSmrsEntryInAccessControlList.addSshAclEntry()");
        Struct[] aclEntries = initAclMo.getAclEntries(coordinator);
        Struct[] updatedAlcEntries = new Struct[aclEntries == null ? 1 : aclEntries.length + 1];
        try {
            AclEntriesData newSshEntry = new AclEntriesData("BYPASS", "256", Integer.toString(0), IpParameters.instance(this.rbsConfigurationMao).getIpAddress(), "32", "0", PORT_FILTERING_FALSE, "TCP", FileParameters.instance(this.rbsConfigurationMao).getSmrsAddress(), "32", "22", PORT_FILTERING_TRUE);
            updatedAlcEntries[0] = newSshEntry.getAclEntry();
            for (int listIndex = 0; listIndex < aclEntries.length; ++listIndex) {
                updatedAlcEntries[listIndex + 1] = aclEntries[listIndex];
            }
            initAclMo.setAclEntries(updatedAlcEntries, coordinator);
        }
        catch (IOException ioe) {
            throw new RbsConfigurationFailedException("Access Control", "Failed to add entry into access control list", ioe);
        }
        logger.traceReturn(THIS_CLASS, "AddOrModifySshSmrsEntryInAccessControlList.addSshAclEntry()");
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("Transaction exception", "Failed to modify access control list", exception);
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("MO action failed", "Failed to modify access control list", exception);
    }
}

