/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state.fetchsiteinstallation;

import se.ericsson.cello.ipoam.IpRoutingTableMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.LoopableTransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class DeleteDefaultStaticRouteTp
implements LoopableTransactionPackage {
    private static final Class THIS_CLASS = DeleteDefaultStaticRouteTp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final int DELAY_BETWEEN_RETRIES = 1000;
    private static final int NBR_OF_RETRIES = 20;
    private final MoRepositoryWrapper aMoRepository;
    private final String nextHop;
    private static int delayBetweenRetries = 1000;
    private boolean successful;
    private Exception exception;

    public DeleteDefaultStaticRouteTp(GenericMaoContext aGenericMaoContext, String inNextHop) {
        this.aMoRepository = aGenericMaoContext.getMoRepositoryWrapper();
        this.nextHop = inNextHop;
    }

    public static void setDelayBetweenRetriesForBT(int delayBetweenRetriesIn) {
        delayBetweenRetries = delayBetweenRetriesIn;
    }

    public static void resetDelayBetweenRetriesForBT() {
        delayBetweenRetries = 1000;
    }

    public void execute(Coordinator coordinator) throws MoAccessException, InactiveTransactionException {
        logger.traceEnter(THIS_CLASS, "execute()");
        IpRoutingTableMo ipRoutingTableMo = (IpRoutingTableMo)this.aMoRepository.lookup("ManagedElement=1,IpOam=1,Ip=1,IpRoutingTable=1");
        int nrRoutingTableEntries = ipRoutingTableMo.actionNumberOfRoutes(coordinator);
        for (int i = 0; i < nrRoutingTableEntries; ++i) {
            Struct routingTableEntry = ipRoutingTableMo.actionGetRoutingTableEntry(i, coordinator);
            if (!routingTableEntry.getValue("nextHopIpAddr").equals(this.nextHop)) continue;
            this.traceRoute(routingTableEntry);
            ipRoutingTableMo.actionDeleteStaticRoute(routingTableEntry, coordinator);
            this.successful = true;
            logger.traceDebug(THIS_CLASS, "Removed static route to " + this.nextHop);
            break;
        }
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    private void traceRoute(Struct route) throws NotHandledAttributeTypeException, MoNotFoundException {
        StringBuffer sb = new StringBuffer();
        String[] names = route.getNames();
        Object[] values = route.getValues();
        for (int n = 0; n < names.length; ++n) {
            sb.append((n > 0 ? ", " : "") + names[n] + "=" + values[n]);
        }
        logger.traceDebug(THIS_CLASS, sb.toString());
    }

    public void handleExecutionException(Exception exceptionIn) throws RbsConfigurationFailedException {
        this.exception = exceptionIn;
        RbsConfigurationReportLoggerFactory.getLogger().logInformation("IpRoutingTable", "Unable to remove route. nextHopIpAddr: " + this.nextHop);
    }

    public void handleTransactionException(Exception exceptionIn) throws RbsConfigurationFailedException {
        this.handleExecutionException(exceptionIn);
    }

    public boolean loop(int noOfLoops) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "loop() " + noOfLoops);
        if (!this.successful) {
            if (noOfLoops >= 20) {
                String msg = "Failed to remove static route to " + this.nextHop + ", reason: " + this.exception + " after " + noOfLoops + " attempts";
                logger.traceDebug(THIS_CLASS, msg);
                if (this.exception instanceof RbsConfigurationFailedException) {
                    throw (RbsConfigurationFailedException)((Object)this.exception);
                }
                throw new RbsConfigurationFailedException("Static route", "Failed to remove static route", this.exception);
            }
            try {
                Thread.sleep(delayBetweenRetries);
            }
            catch (InterruptedException willNotHappen) {
                logger.traceDebug(THIS_CLASS, "execute() Interrupted will sleeping before next attempt");
            }
            logger.traceDebug(THIS_CLASS, "loop() " + (noOfLoops + 1) * 1000 / 1000 + " seconds");
        }
        logger.traceReturn(THIS_CLASS, "loop() noOfLoops: " + noOfLoops + ", successfull: " + this.successful);
        return !this.successful;
    }
}

