/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state.fetchsiteinstallation;

import java.net.MalformedURLException;
import java.net.URL;
import se.ericsson.cello.cns.TransferClientException;
import se.ericsson.cello.cns.TransferClientMgr;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.IpParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.LoopableTransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class FetchSiteInstallationTp
implements LoopableTransactionPackage {
    private static final Class THIS_CLASS = FetchSiteInstallationTp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String SLOGAN = "Fetch SiteInstallation";
    private static final int DELAY_BETWEEN_RETRIES = 1000;
    private static final int NBR_OF_RETRIES = 20;
    private static int delayBetweenRetries = 1000;
    private String webServerAddress;
    final RbsConfigurationMao rbsConfigurationMao;
    private String siteInstallationXml;
    private boolean successfull;
    private Exception exception;

    public FetchSiteInstallationTp(String webServerAddressIn, RbsConfigurationMao rbsConfigurationMaoIn) {
        this.webServerAddress = webServerAddressIn;
        this.rbsConfigurationMao = rbsConfigurationMaoIn;
    }

    public void execute(Coordinator coordinator) throws MoAccessException, InactiveTransactionException {
        logger.traceEnter(THIS_CLASS, "execute()");
        URL siURL = this.getRemoteFilePathUrl();
        try {
            this.siteInstallationXml = TransferClientMgr.getHttpsTransferClient().fetchFile(siURL);
        }
        catch (TransferClientException tce) {
            throw new RbsConfigurationFailedException(SLOGAN, "Failed to fetch SiteInstallation file from " + siURL.toExternalForm(), (Exception)((Object)tce));
        }
        this.successfull = true;
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    public String getSiteInstallationXml() {
        return this.siteInstallationXml;
    }

    public static void setDelayBetweenRetriesForBT(int delayBetweenRetriesIn) {
        delayBetweenRetries = delayBetweenRetriesIn;
    }

    public static void resetDelayBetweenRetriesForBT() {
        delayBetweenRetries = 1000;
    }

    private URL getRemoteFilePathUrl() throws RbsConfigurationFailedException {
        URL result2;
        logger.traceEnter(THIS_CLASS, "getRemoteFilePathUrl()");
        IpParameters ip = IpParameters.instance(this.rbsConfigurationMao);
        String aiwsDn = ip.getDomainName() == null || ip.getDomainName().trim().length() == 0 ? "aiws.ai.ericsson" : "aiws.ai.ericsson." + ip.getDomainName();
        String hostName = this.webServerAddress == null || this.webServerAddress.trim().length() == 0 ? aiwsDn : this.webServerAddress;
        try {
            result2 = new URL("https", hostName, 2497, "/autobind/");
        }
        catch (MalformedURLException mfe) {
            throw new RbsConfigurationFailedException(SLOGAN, "Failed to build SiteInstallation URL", mfe);
        }
        logger.traceReturn(THIS_CLASS, "getRemoteFilePath() " + result2.toExternalForm());
        return result2;
    }

    public void handleExecutionException(Exception exceptionIn) throws RbsConfigurationFailedException {
        this.exception = exceptionIn;
        String msg = "Failed to fetch and parse SiteInstallation file from " + this.webServerAddress + ", reason: " + exceptionIn;
        logger.traceDebug(THIS_CLASS, msg);
    }

    public void handleTransactionException(Exception exceptionIn) throws RbsConfigurationFailedException {
        this.handleExecutionException(exceptionIn);
    }

    public boolean loop(int noOfLoops) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "loop() " + noOfLoops);
        if (!this.successfull) {
            if (noOfLoops >= 20) {
                String msg = "Failed to fetch and parse SiteInstallation file from " + this.webServerAddress + ", reason: " + this.exception + " after " + noOfLoops + " attempts";
                logger.traceDebug(THIS_CLASS, msg);
                if (this.exception instanceof RbsConfigurationFailedException) {
                    throw (RbsConfigurationFailedException)((Object)this.exception);
                }
                throw new RbsConfigurationFailedException(SLOGAN, "Failed to fetch SiteInstallation file", this.exception);
            }
            try {
                Thread.sleep(delayBetweenRetries);
            }
            catch (InterruptedException willNotHappen) {
                logger.traceDebug(THIS_CLASS, "execute() Interrupted will sleeping before next attempt");
            }
            logger.traceDebug(THIS_CLASS, "loop() " + (noOfLoops + 1) * 1000 / 1000 + " seconds");
        }
        logger.traceReturn(THIS_CLASS, "loop() noOfLoops: " + noOfLoops + ", successfull: " + this.successfull);
        return !this.successfull;
    }
}

