/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state.fetchsiteinstallation;

import se.ericsson.cello.ipoam.IpHostLinkMo;
import se.ericsson.cello.iptransport.IpInterfaceMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;

public class GetIpAddressAndDefaultRouter0Tp
implements TransactionPackage {
    private static final Class THIS_CLASS = GetIpAddressAndDefaultRouter0Tp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final GenericMaoContext genericMaoContext;
    private String ipAddress;
    private String defaultRouter0;

    public GetIpAddressAndDefaultRouter0Tp(GenericMaoContext genericMaoContextIn) {
        this.genericMaoContext = genericMaoContextIn;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getDefaultRouter0() {
        return this.defaultRouter0;
    }

    public void execute(Coordinator coordinator) throws MoAccessException, InactiveTransactionException {
        logger.traceEnter(THIS_CLASS, "GetIpAddressAndDefaultRouter0.execute()");
        IpHostLinkMo ipHostLink = (IpHostLinkMo)this.genericMaoContext.getMoRepositoryWrapper().lookup("ManagedElement=1,IpOam=1,Ip=1,IpHostLink=1");
        if (ipHostLink == null) {
            throw new MoNotFoundException("No IpHostLink MO found, ManagedElement=1,IpOam=1,Ip=1,IpHostLink=1");
        }
        IpInterfaceMo ipInterface = (IpInterfaceMo)ipHostLink.getIpInterfaceMoRef(coordinator);
        if (ipInterface == null) {
            throw new MoNotFoundException("Null ipInterfaceMoRef on " + ipHostLink.getLocalDistinguishedName());
        }
        this.ipAddress = ipHostLink.getIpAddress(coordinator);
        this.defaultRouter0 = ipInterface.getDefaultRouter0(coordinator);
        logger.traceReturn(THIS_CLASS, "GetIpAddressAndDefaultRouter0.execute()");
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("Transaction exception", "Caught a transaction exception", exception);
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("MO action failed", "Failed to get defaultRouter0 on Mo IpInterface", exception);
    }
}

