/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state.fetchsiteinstallation;

import se.ericsson.cello.ipoam.DhcpMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class ReleaseDhcpIfTp
implements TransactionPackage {
    private static final Class THIS_CLASS = ReleaseDhcpIfTp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final MoRepositoryWrapper moRepositoryWrapper;

    public ReleaseDhcpIfTp(GenericMaoContext genericMaoContextIn) {
        logger.traceEnter(THIS_CLASS, "ReleaseDhcpIfTp()");
        this.moRepositoryWrapper = genericMaoContextIn.getMoRepositoryWrapper();
        logger.traceReturn(THIS_CLASS, "ReleaseDhcpIfTp()");
    }

    public void execute(Coordinator coordinator) throws MoAccessException, InactiveTransactionException {
        logger.traceEnter(THIS_CLASS, "execute()");
        MoIterator dhcpIt = this.moRepositoryWrapper.lookupType("Dhcp");
        if (dhcpIt == null || !dhcpIt.hasMoreElements()) {
            String slogan = "MO not found";
            String faultMsg = "Could not find the Dhcp MO.";
            throw new RbsConfigurationFailedException("MO not found", "Could not find the Dhcp MO.");
        }
        DhcpMo dhcp = (DhcpMo)dhcpIt.nextMo();
        dhcp.actionReleaseDhcpIf("lh0", coordinator);
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        logger.traceAbnormal(THIS_CLASS, "Uanble to release DHCP interface, caught a transaction exception: " + exception);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        logger.traceAbnormal(THIS_CLASS, "Caught a transaction exception: " + exception);
    }
}

