/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state.fetchsiteinstallation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import se.ericsson.cello.equipment.SlotMo;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class SerialNumber {
    private static final Class THIS_CLASS = SerialNumber.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String PBOOT_SH_PARAM = "pboot sh param";
    private static final String SERIAL_NUMBER = "*serialnumber=";

    public String getSerialNumber(MoRepositoryWrapper moRepository, Coordinator coordinator) throws RbsConfigurationFailedException {
        String serialNumber = null;
        SlotMo slotMo = (SlotMo)moRepository.lookup("ManagedElement=1,Equipment=1,Subrack=1,Slot=1");
        if (slotMo == null) {
            serialNumber = this.getSerialNumberThroughPboot();
        } else {
            try {
                serialNumber = (String)slotMo.getProductData(coordinator).getValue("serialNumber");
            }
            catch (Exception e) {
                throw new RbsConfigurationFailedException("Serial Number", "Failed to read serial number in ManagedElement=1,Equipment=1,Subrack=1,Slot=1", e);
            }
        }
        return serialNumber;
    }

    private String getSerialNumberThroughPboot() throws RbsConfigurationFailedException {
        try {
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(PBOOT_SH_PARAM);
            ErrorGobbler errorGobbler = new ErrorGobbler(proc.getErrorStream());
            OutputGobbler outputGobbler = new OutputGobbler(proc.getInputStream(), SERIAL_NUMBER);
            errorGobbler.start();
            outputGobbler.start();
            int exitVal = proc.waitFor();
            if (exitVal != 0) {
                throw new RbsConfigurationFailedException("Serial Number", "Exit value " + exitVal + " from command " + PBOOT_SH_PARAM);
            }
            return this.extractSerialNumber(outputGobbler.getBuffer());
        }
        catch (RbsConfigurationFailedException rce) {
            throw rce;
        }
        catch (Exception e) {
            throw new RbsConfigurationFailedException("Serial Number", "Failed to read serial number with command pboot sh param", e);
        }
    }

    private String extractSerialNumber(String[] strs) throws RbsConfigurationFailedException {
        for (int i = 0; i < strs.length; ++i) {
            String serialNumber;
            int pos = strs[i].indexOf(SERIAL_NUMBER);
            if (pos <= -1 || (serialNumber = strs[i].substring(pos).trim()).length() <= 0) continue;
            return serialNumber;
        }
        throw new RbsConfigurationFailedException("Serial Number", "Failed to find a serial number in the output of command pboot sh param");
    }

    protected abstract class AbstractStreamGobbler
    extends Thread {
        private final InputStream is;
        protected final List buffer = new ArrayList();

        protected AbstractStreamGobbler(InputStream aIs) {
            this.is = aIs;
        }

        protected String[] getBuffer() {
            return this.buffer.toArray(new String[this.buffer.size()]);
        }

        protected abstract void add(String var1);

        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    this.add(line);
                }
            }
            catch (IOException ioe) {
                logger.traceDebug(THIS_CLASS, "Failed to read from inputStream");
                logger.traceDebugStackTrace(THIS_CLASS, (Throwable)ioe);
                this.buffer.add(ioe.toString());
            }
        }
    }

    protected class OutputGobbler
    extends AbstractStreamGobbler {
        private final String grepFor;

        protected OutputGobbler(InputStream aIs, String aGrepFor) {
            super(aIs);
            this.grepFor = aGrepFor;
        }

        protected void add(String line) {
            if (this.grepFor == null || line.indexOf(this.grepFor) > -1) {
                this.buffer.add(line);
            }
        }
    }

    protected class ErrorGobbler
    extends AbstractStreamGobbler {
        protected ErrorGobbler(InputStream aIs) {
            super(aIs);
        }

        protected void add(String line) {
            if (this.buffer.size() > 0) {
                this.buffer.set(0, this.buffer.get(0) + "\n" + line);
            } else {
                this.buffer.add(line);
            }
        }
    }
}

