/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state.fetchsiteinstallation;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationIpHelperImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.FileParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.InnerIpConfigurationData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.IpParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.NodeParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.OuterIpConfigurationData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.SecurityParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.fetchsiteinstallation.SiteInstallationXmlTags;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class SiteInstallationFileParser
extends DefaultHandler {
    private static final Class THIS_CLASS = SiteInstallationFileParser.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String EXCEPTION_SLOGAN = "SiteInstallation file parser";
    final RbsConfigurationMao rbsConfigurationMao;
    private final String fileToBeParsed;
    private RbsConfigurationFailedException rbsConfFailException;

    public SiteInstallationFileParser(String fileToBeParsedIn, RbsConfigurationMao rbsConfigurationMaoIn) {
        logger.traceEnter(THIS_CLASS, "SiteInstallationFileParser()");
        this.rbsConfigurationMao = rbsConfigurationMaoIn;
        this.fileToBeParsed = fileToBeParsedIn;
        logger.traceReturn(THIS_CLASS, "SiteInstallationFileParser()");
    }

    public void parse() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "parseFile()");
        boolean result2 = true;
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            saxParser.parse(new InputSource(new StringReader(this.fileToBeParsed)), (DefaultHandler)this);
        }
        catch (Exception e) {
            String emsg = e.getMessage() == null ? e.getClass().getName() : e.getMessage();
            logger.traceDebug(THIS_CLASS, "Failed to parse SI file() " + emsg);
            throw new RbsConfigurationFailedException(EXCEPTION_SLOGAN, "Failed to parse file " + this.fileToBeParsed + ", " + emsg, e);
        }
        if (this.rbsConfFailException != null) {
            String emsg = this.rbsConfFailException.getMessage() == null ? ((Object)((Object)this.rbsConfFailException)).getClass().getName() : this.rbsConfFailException.getMessage();
            logger.traceDebug(THIS_CLASS, "Failed to parse SI file() " + emsg);
            throw new RbsConfigurationFailedException(EXCEPTION_SLOGAN, "Failed to parse file " + this.fileToBeParsed + ", " + emsg, (Exception)((Object)this.rbsConfFailException));
        }
        logger.traceReturn(THIS_CLASS, "parseFile() parseSuccess = " + result2);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        logger.traceEnter(THIS_CLASS, "startElement()");
        try {
            if (!this.checkRevisionInfo(qName, attributes)) {
                logger.traceDebug(THIS_CLASS, "Unrecognized revision in site installation file: " + this.fileToBeParsed);
            }
            this.getInstallationData(qName, attributes);
            this.getOamConfgurationData(qName, attributes);
            this.getDnsServer(qName, attributes);
            this.getSmrsData(qName, attributes);
            this.getInnerIpConfigData(qName, attributes);
            this.getInnerDnsServer(qName, attributes);
            this.getOuterIpConfigData(qName, attributes);
            this.getOuterDnsServer(qName, attributes);
            this.getSecGW(qName, attributes);
        }
        catch (RbsConfigurationFailedException rcfe) {
            this.rbsConfFailException = rcfe;
        }
        logger.traceReturn(THIS_CLASS, "startElement()");
    }

    private void getSecGW(String qName, Attributes attributes) {
        logger.traceEnter(THIS_CLASS, "getSecGW()");
        if (qName.equals("SecGW")) {
            for (int index = 0; index < attributes.getLength(); ++index) {
                if (attributes.getQName(index).equals("ipAddress")) {
                    OuterIpConfigurationData.instance(this.rbsConfigurationMao).setInitialSecGwIpAdd(attributes.getValue(index));
                    continue;
                }
                if (!attributes.getQName(index).equals("FQDN")) continue;
                OuterIpConfigurationData.instance(this.rbsConfigurationMao).setInitialSecGwFqdn(attributes.getValue(index));
            }
        }
        logger.traceReturn(THIS_CLASS, "getSecGW()");
    }

    private void getOuterDnsServer(String qName, Attributes attributes) {
        logger.traceEnter(THIS_CLASS, "getOuterDnsServer()");
        if (qName.equals("OuterDnsServer")) {
            for (int index = 0; index < attributes.getLength(); ++index) {
                if (!attributes.getQName(index).equals("ipAddress")) continue;
                OuterIpConfigurationData.instance(this.rbsConfigurationMao).setOuterDnsServer(attributes.getValue(index));
                break;
            }
        }
        logger.traceReturn(THIS_CLASS, "getOuterDnsServer()");
    }

    private void getOuterIpConfigData(String qName, Attributes attributes) {
        logger.traceEnter(THIS_CLASS, "getOuterIpConfigData()");
        if (qName.equals("OuterIpConfigurationData")) {
            OuterIpConfigurationData od = OuterIpConfigurationData.instance(this.rbsConfigurationMao);
            for (int index = 0; index < attributes.getLength(); ++index) {
                if (attributes.getQName(index).equals("ipAddress")) {
                    od.setOuterIpAddress(attributes.getValue(index));
                    continue;
                }
                if (attributes.getQName(index).equals("subnetMask")) {
                    od.setOuterSubnetMask(attributes.getValue(index));
                    continue;
                }
                if (!attributes.getQName(index).equals("defaultRouter0")) continue;
                od.setOuterDefaultRouterZero(attributes.getValue(index));
            }
        }
        logger.traceReturn(THIS_CLASS, "getOuterIpConfigData()");
    }

    private void getInnerDnsServer(String qName, Attributes attributes) {
        logger.traceEnter(THIS_CLASS, "getInnerDnsServer()");
        if (qName.equals("InnerDnsServer")) {
            for (int index = 0; index < attributes.getLength(); ++index) {
                if (!attributes.getQName(index).equals("ipAddress")) continue;
                InnerIpConfigurationData.instance(this.rbsConfigurationMao).setInnerDnsServer(attributes.getValue(index));
                break;
            }
        }
        logger.traceReturn(THIS_CLASS, "getInnerDnsServer()");
    }

    private void getInnerIpConfigData(String qName, Attributes attributes) {
        logger.traceEnter(THIS_CLASS, "getInnerIpConfigData()");
        if (qName.equals("InnerIpConfigurationData")) {
            for (int index = 0; index < attributes.getLength(); ++index) {
                if (!attributes.getQName(index).equals("ipAddress")) continue;
                InnerIpConfigurationData.instance(this.rbsConfigurationMao).setInnerIpAddress(attributes.getValue(index));
                break;
            }
        }
        logger.traceReturn(THIS_CLASS, "getInnerIpConfigData()");
    }

    private void getSmrsData(String qName, Attributes attributes) {
        logger.traceEnter(THIS_CLASS, "getSmrsData()");
        if (qName.equals("SmrsData")) {
            FileParameters fp = FileParameters.instance(this.rbsConfigurationMao);
            for (int index = 0; index < attributes.getLength(); ++index) {
                if (attributes.getQName(index).equals("userName")) {
                    fp.setSmrsUserName(attributes.getValue(index));
                    continue;
                }
                if (attributes.getQName(index).equals("password")) {
                    fp.setSmrsPassword(attributes.getValue(index));
                    continue;
                }
                if (attributes.getQName(index).equals("address")) {
                    fp.setSmrsAddress(attributes.getValue(index));
                    continue;
                }
                if (!attributes.getQName(index).equals("summaryFilePath")) continue;
                fp.setSmrsSummaryFilePath(attributes.getValue(index));
            }
        }
        logger.traceReturn(THIS_CLASS, "getSmrsData()");
    }

    private void getDnsServer(String qName, Attributes attributes) {
        logger.traceEnter(THIS_CLASS, "getDnsServer()");
        if (qName.equals("DnsServer")) {
            for (int index = 0; index < attributes.getLength(); ++index) {
                if (!attributes.getQName(index).equals("ipAddress")) continue;
                IpParameters.instance(this.rbsConfigurationMao).setDnsServerAddress(attributes.getValue(index));
                break;
            }
        }
        logger.traceReturn(THIS_CLASS, "getDnsServer()");
    }

    private void getOamConfgurationData(String qName, Attributes attributes) {
        logger.traceEnter(THIS_CLASS, "getOamConfgurationData()");
        if (qName.equals("OamIpConfigurationData")) {
            IpParameters ip = IpParameters.instance(this.rbsConfigurationMao);
            for (int index = 0; index < attributes.getLength(); ++index) {
                if (attributes.getQName(index).equals("ipAddress")) {
                    ip.setIpAddress(attributes.getValue(index));
                    continue;
                }
                if (attributes.getQName(index).equals("defDomainName")) {
                    ip.setDefaultDomainName(attributes.getValue(index));
                    continue;
                }
                if (attributes.getQName(index).equals("defaultGateway")) {
                    ip.setDefaultRouter(attributes.getValue(index));
                    continue;
                }
                if (attributes.getQName(index).equals("defaultRouter0")) {
                    ip.setDefaultRouter(attributes.getValue(index));
                    continue;
                }
                if (attributes.getQName(index).equals("subnetMask")) {
                    ip.setSubnetMask(attributes.getValue(index));
                    try {
                        ip.setNetworkPrefixLength(RbsConfigurationIpHelperImpl.calculateNetworkPrefixLength(ip.getSubnetMask()).toString());
                    }
                    catch (IOException ioe) {
                        logger.traceDebug(THIS_CLASS, "Failed to convert subNetMask + " + ip.getSubnetMask() + " to netWorkPrefixLength");
                    }
                    continue;
                }
                if (!attributes.getQName(index).equals("networkPrefixLength")) continue;
                ip.setNetworkPrefixLength(Integer.valueOf(attributes.getValue(index)).toString());
            }
        }
        logger.traceReturn(THIS_CLASS, "getOamConfgurationData()");
    }

    private void getInstallationData(String qName, Attributes attributes) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "getInstallationData()");
        if (qName.equals("InstallationData")) {
            for (int index = 0; index < attributes.getLength(); ++index) {
                if (attributes.getQName(index).equals("vlanId")) {
                    IpParameters.instance(this.rbsConfigurationMao).setVlanId(this.getVlanId(attributes.getValue(index)));
                    continue;
                }
                if (attributes.getQName(index).equals("logicalName")) {
                    NodeParameters.instance(this.rbsConfigurationMao).setLogicalName(attributes.getValue(index));
                    continue;
                }
                if (!attributes.getQName(index).equals("rbsIntegrationCode")) continue;
                SecurityParameters.instance(this.rbsConfigurationMao).setIntegrationCode(attributes.getValue(index));
            }
        }
        logger.traceReturn(THIS_CLASS, "getInstallationData()");
    }

    private int getVlanId(String attrValue) throws RbsConfigurationFailedException {
        try {
            return Integer.parseInt(attrValue);
        }
        catch (NumberFormatException nfe) {
            throw new RbsConfigurationFailedException("Specified VLAN id is not an integer. Value is: " + attrValue);
        }
    }

    private boolean checkRevisionInfo(String qName, Attributes attributes) {
        logger.traceEnter(THIS_CLASS, "checkRevisionInfo()");
        boolean knownRevision = false;
        if (qName.equals("Format")) {
            block0: for (int index = 0; index < attributes.getLength(); ++index) {
                if (!"revision".equals(attributes.getQName(index))) continue;
                String revision = attributes.getValue(index);
                for (int revIndex = 0; revIndex < SiteInstallationXmlTags.KNOWN_REVISIONS.length; ++revIndex) {
                    if (!SiteInstallationXmlTags.KNOWN_REVISIONS[revIndex].equals(revision)) continue;
                    knownRevision = true;
                    continue block0;
                }
            }
        } else {
            knownRevision = true;
        }
        logger.traceReturn(THIS_CLASS, "checkRevisionInfo()");
        return knownRevision;
    }
}

