/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state.initialcv;

import se.ericsson.cello.configurationversion.main.exception.ConfigurationVersionException;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.su.mom.ConfigurationVersion;
import se.ericsson.cello.swmanagement.ConfigurationVersionMo;
import se.ericsson.crbs.cat.common.StringHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.aicv.AbstractAiCv;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.StateMachineParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ProgressReportHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.initialcv.InitialAiCv;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class InitialAiCvImpl
extends AbstractAiCv
implements InitialAiCv {
    private static final Class THIS_CLASS = InitialAiCvImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String cvCreationFaultReason = "CV creation failure";
    private static final String cvRemoveFaultReason = "CV remove failure";
    private static final String cvHandlingFaultReason = "CV handling failure";

    protected InitialAiCvImpl(RbsConfigurationMao rbsConfigurationMaoIn) {
        super(rbsConfigurationMaoIn);
    }

    public String createInitialCv(String initialCvName, boolean woLaptop, String comment, String faultMsg) {
        logger.traceEnter(THIS_CLASS, "createInitialCv() initialCvName:" + initialCvName + ", woLaptop: " + woLaptop + ", comment:" + comment);
        String result2 = null;
        int cvIntegrationStep = 50;
        ConfigurationVersionMo cvMo = this.getCvMo();
        if (cvMo != null && initialCvName != null) {
            try {
                if (woLaptop) {
                    StateMachineParameters.instance(this.rbsConfigurationMao).setWoLaptopCancelledByUser(Boolean.TRUE.toString());
                }
                result2 = this.handleCreateCv(initialCvName, woLaptop, comment, faultMsg, 50, (ConfigurationVersion)cvMo);
                if (woLaptop) {
                    StateMachineParameters.instance(this.rbsConfigurationMao).setWoLaptopCancelledByUser(Boolean.FALSE.toString());
                }
                logger.traceGeneral(THIS_CLASS, "A new CV " + initialCvName + "has been created");
                ProgressReportHandler.getInstance().updateProgressReportInformation(50, 5, "Successfully created initial CV: " + StringHelper.doubleQuote((String)initialCvName), true);
                ProgressReportHandler.getInstance().setIntegrationCanBeCancelled(Boolean.TRUE);
            }
            catch (ConfigurationVersionException cve) {
                String errorMsg = faultMsg + " " + (Object)((Object)cve);
                ProgressReportHandler.getInstance().updateProgressReportInformation(50, 0, errorMsg, true);
                logger.traceGeneral(THIS_CLASS, "Unable to create the new CV " + initialCvName + ".");
                logger.traceError(THIS_CLASS, "Unable to create the new CV " + initialCvName + ".", (Throwable)cve);
                ProgressReportHandler.getInstance().setIntegrationCanBeCancelled(Boolean.TRUE);
                this.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, cvCreationFaultReason, errorMsg);
            }
            catch (MoAccessException mae) {
                String errorMsg = faultMsg + " " + RbsConfigurationFailedException.convertVariablesMessage(mae.getVariablesAsString());
                ProgressReportHandler.getInstance().updateProgressReportInformation(50, 0, errorMsg, true);
                logger.traceGeneral(THIS_CLASS, "Unable to create the new CV " + initialCvName + ".");
                logger.traceError(THIS_CLASS, "Unable to create the new CV " + initialCvName + ".", (Throwable)mae);
                ProgressReportHandler.getInstance().setIntegrationCanBeCancelled(Boolean.TRUE);
                this.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, cvCreationFaultReason, errorMsg);
            }
        }
        logger.traceReturn(THIS_CLASS, "createInitialCv() success: " + result2);
        return result2;
    }

    public void deleteInitialCv(String initialCvName, String faultMsg) {
        logger.traceEnter(THIS_CLASS, "deleteInitialCv()");
        int cvIntegrationStep = -1;
        ConfigurationVersionMo cvMo = this.getCvMo();
        if (cvMo != null && initialCvName != null) {
            try {
                RbsConfigurationReportLoggerFactory.getLogger().logAction("ConfigurationVersion", "Deleting CV", "name", initialCvName);
                this.removeCvFromRollbackListAndDeleteCv(initialCvName, faultMsg, -1, (ConfigurationVersion)cvMo);
            }
            catch (MoAccessException mae) {
                String errorMsg = faultMsg + " " + RbsConfigurationFailedException.convertVariablesMessage(mae.getVariablesAsString());
                logger.traceGeneral(THIS_CLASS, "Unable to remove the CV " + initialCvName + ".");
                this.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, cvRemoveFaultReason, errorMsg);
            }
        }
        logger.traceReturn(THIS_CLASS, "deleteInitialCv()");
    }

    public boolean restoreCv() {
        logger.traceEnter(THIS_CLASS, "restoreCv()");
        boolean result2 = false;
        String msg = "Could not set the startable configuration version.";
        int cvIntegrationStep = -1;
        ConfigurationVersionMo cvMo = this.getCvMo();
        if (cvMo != null) {
            try {
                String cvName = StateMachineParameters.instance(this.rbsConfigurationMao).getCvName();
                if (cvName == null || cvName.equalsIgnoreCase("")) {
                    msg = "Could not find any stored CV name in the RbsConfiguration MO";
                    this.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, cvHandlingFaultReason, msg);
                    logger.traceDebug(THIS_CLASS, msg);
                } else {
                    String startableCv = cvMo.getStartableConfigurationVersion(null);
                    if (!InitialAiCvImpl.existsAndNotEmpty(startableCv) || !cvName.equals(startableCv)) {
                        this.doActionSetStartable(cvName, msg, -1, (ConfigurationVersion)cvMo);
                    }
                    result2 = true;
                }
            }
            catch (MoAccessException mae) {
                this.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, cvHandlingFaultReason, msg);
                logger.traceError(THIS_CLASS, "restoreCv():" + msg, (Throwable)mae);
            }
        }
        logger.traceReturn(THIS_CLASS, "restoreCv() " + result2);
        return result2;
    }

    public String saveExecutingCvName() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "saveExecutingCvName()");
        String cvName = this.getExecutingCvName();
        this.saveCvName(cvName);
        logger.traceReturn(THIS_CLASS, "saveExecutingCvName()");
        return cvName;
    }

    public void saveCvName(String cvName) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "saveCvName() " + cvName);
        StateMachineParameters.instance(this.rbsConfigurationMao).setCvName(cvName);
        logger.traceReturn(THIS_CLASS, "saveCvName()");
    }

    private String getExecutingCvName() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "getExecutingCvName()");
        ConfigurationVersionMo cvMo = this.getCvMo();
        if (cvMo == null) {
            String msg = "Could not find the Configuration Version Mo, exiting.";
            this.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, cvHandlingFaultReason, "Could not find the Configuration Version Mo, exiting.");
            logger.traceError(THIS_CLASS, "getExecutingCvName():Could not find the Configuration Version Mo, exiting.");
            throw new RbsConfigurationFailedException("Could not find the Configuration Version Mo, exiting.");
        }
        try {
            return cvMo.getExecutingCv(null);
        }
        catch (MoAccessException mae) {
            String msg = "Could not get the name of the current executing CV.";
            this.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, cvHandlingFaultReason, "Could not get the name of the current executing CV.");
            logger.traceError(THIS_CLASS, "getExecutingCvName():Could not get the name of the current executing CV.", (Throwable)mae);
            throw new RbsConfigurationFailedException("Could not get the name of the current executing CV.");
        }
    }
}

