/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state.initialipconfiguration;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.IpParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.AddStaticRouteTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.CheckGigabitMoOperationalStateTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.CleanIpConfigurationTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.ConfigureIpMoTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.CreateAccessControlListMoTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.CreateGigabitMoTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.CreateIpHostLinkMoIpv6Tp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.CreateIpHostLinkMoTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.CreateIpInterfaceMoTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.CreateIpv6InterfaceMoTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.CreateIpv6MoTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.SetNodeInterfaceNameTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.SetVlanOnIpInterfaceMoTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.SetVlanOnIpv6InterfaceMoTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.UnlockGigabitMoTp;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;

public class ConfiguratorHelper {
    private static final Class THIS_CLASS = ConfiguratorHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    public static int RETRY_SLEEP_TIME = 5000;

    public static void applyTemporaryIpConfiguration(GenericMaoContext genericMaoContext, RbsConfigurationMao rbsConfigurationMao) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "applyTemporaryIpConfiguration");
        TransactionHandler.run(new CreateIpInterfaceMoTp(genericMaoContext, "10.10.10.10", "255.255.240.0"));
        TransactionHandler.run(new CreateIpHostLinkMoTp(genericMaoContext, "0.0.0.0"));
        TransactionHandler.run(new SetVlanOnIpInterfaceMoTp(genericMaoContext, IpParameters.instance(rbsConfigurationMao).getVlanId()));
        logger.traceReturn(THIS_CLASS, "applyTemporaryIpConfiguration");
    }

    public static boolean applyTrustedNetworkConfiguration(GenericMaoContext genericMaoContext, RbsConfigurationMao rbsConfigurationMao, boolean doSetNodeInterfaceName) throws UnknownHostException, RbsConfigurationFailedException {
        boolean successfulConfiguration;
        logger.traceEnter(THIS_CLASS, "applyTrustedNetworkConfiguration");
        InetAddress validIpAddress = InetAddress.getByName(IpParameters.instance(rbsConfigurationMao).getIpAddress());
        if (validIpAddress instanceof Inet6Address) {
            ConfiguratorHelper.applyIpv6Configuration(genericMaoContext, rbsConfigurationMao, doSetNodeInterfaceName);
            successfulConfiguration = true;
        } else {
            ConfiguratorHelper.applyIpv4Configuration(genericMaoContext, rbsConfigurationMao, doSetNodeInterfaceName);
            successfulConfiguration = true;
        }
        logger.traceReturn(THIS_CLASS, "applyTrustedNetworkConfiguration");
        return successfulConfiguration;
    }

    private static void applyIpv4Configuration(GenericMaoContext genericMaoContext, RbsConfigurationMao rbsConfigurationMao, boolean doSetNodeInterfaceName) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "applyIpv4Configuration()");
        IpParameters ip = IpParameters.instance(rbsConfigurationMao);
        TransactionHandler.run(new CreateIpInterfaceMoTp(genericMaoContext, ip.getDefaultRouter(), ip.getSubnetMask()));
        TransactionHandler.run(new CreateIpHostLinkMoTp(genericMaoContext, ip.getIpAddress()));
        TransactionHandler.run(new SetVlanOnIpInterfaceMoTp(genericMaoContext, ip.getVlanId()));
        TransactionHandler.run(new AddStaticRouteTp(rbsConfigurationMao, genericMaoContext, "0.0.0.0", "0.0.0.0", ip.getDefaultRouter(), 16, false));
        TransactionHandler.run(new CreateAccessControlListMoTp(genericMaoContext, ip.getIpAddress(), rbsConfigurationMao));
        TransactionHandler.run(new ConfigureIpMoTp(genericMaoContext, ip.getDnsServerAddress(), ip.getDefaultDomainName(), 0));
        if (doSetNodeInterfaceName) {
            TransactionHandler.run(new SetNodeInterfaceNameTp(rbsConfigurationMao, genericMaoContext, "1", null, true));
        }
        logger.traceReturn(THIS_CLASS, "applyIpv4Configuration()");
    }

    private static void applyIpv6Configuration(GenericMaoContext genericMaoContext, RbsConfigurationMao rbsConfigurationMao, boolean doSetNodeInterfaceName) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "applyIpv6Configuration()");
        IpParameters ip = IpParameters.instance(rbsConfigurationMao);
        TransactionHandler.run(new CreateIpv6MoTp(genericMaoContext));
        TransactionHandler.run(new CreateIpv6InterfaceMoTp(genericMaoContext));
        TransactionHandler.run(new CreateIpHostLinkMoIpv6Tp(genericMaoContext, ip.getIpAddress(), ip.getNetworkPrefixLength()));
        TransactionHandler.run(new SetVlanOnIpv6InterfaceMoTp(genericMaoContext, ip.getVlanId()));
        TransactionHandler.run(new AddStaticRouteTp(rbsConfigurationMao, genericMaoContext, "::", "0", ip.getDefaultRouter(), 16, false));
        TransactionHandler.run(new ConfigureIpMoTp(genericMaoContext, ip.getDnsServerAddress(), ip.getDefaultDomainName(), 0));
        if (doSetNodeInterfaceName) {
            TransactionHandler.run(new SetNodeInterfaceNameTp(rbsConfigurationMao, genericMaoContext, "1", null, false));
        }
        logger.traceReturn(THIS_CLASS, "applyIpv6Configuration()");
    }

    public static void createGigabitEthernetMo(GenericMaoContext genericMaoContext, long retrySleepTime, RbsConfigurationHelper helper) {
        logger.traceEnter(THIS_CLASS, "createGigabitEthernet()");
        int attemptNo = 0;
        boolean autoNegotiation = true;
        boolean finished = false;
        helper.setRbsProgressInformation(RbsConfigurationDefinitions.RBS_PI_DETECTING_GIGABIT_LINK);
        while (true) {
            for (int tryNo = 0; tryNo <= 1; ++tryNo) {
                autoNegotiation = tryNo == 0;
                int portNo = attemptNo % 2 + 1;
                logger.traceDebug(THIS_CLASS, "Attempting to create GigaBitEthernet with portNo: " + portNo + " attempt: " + attemptNo);
                try {
                    TransactionHandler.run(new CreateGigabitMoTp(genericMaoContext, portNo, autoNegotiation));
                    TransactionHandler.run(new UnlockGigabitMoTp(genericMaoContext));
                    try {
                        Thread.sleep(retrySleepTime);
                    }
                    catch (InterruptedException ie) {
                        logger.traceDebug(THIS_CLASS, "Interupted while sleeping: " + ie.getMessage());
                    }
                    TransactionHandler.run(new CheckGigabitMoOperationalStateTp(genericMaoContext));
                    logger.traceDebug(THIS_CLASS, "Successfully created GigaBitEthernet with portNo: " + portNo + " attempt: " + attemptNo);
                    RbsConfigurationReportLoggerFactory.getLogger().logAction("GigaBitEthernet", "create", new String[]{"linkType", "portNo", "protectiveMode"}, new String[]{"0", Integer.toString(portNo), "false"});
                    helper.setRbsConfigLevel(RbsConfigurationDefinitions.RBS_CL_GIGABIT_LINK_DETECTED);
                    finished = true;
                    break;
                }
                catch (RbsConfigurationFailedException rcfe) {
                    try {
                        TransactionHandler.run(new CleanIpConfigurationTp(genericMaoContext, true));
                        logger.traceDebug(THIS_CLASS, "Link not active, sleeping.. Attempt: " + (attemptNo + 1) + " " + rcfe.getMessage());
                    }
                    catch (RbsConfigurationFailedException rcfe2) {
                        logger.traceDebug(THIS_CLASS, "Unable to delete GigaBitEthernet: " + rcfe2.getMessage());
                    }
                    continue;
                }
            }
            if (finished) break;
            ++attemptNo;
        }
        logger.traceReturn(THIS_CLASS, "createGigabitEthernet()");
    }
}

