/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state.initialipconfiguration;

import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.IpParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.NodeParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.initialipconfiguration.ConfiguratorHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.initialipconfiguration.IpConfigurator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.FetchDhcpDataTp;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class DhcpConfigurator
extends IpConfigurator {
    private static final Class THIS_CLASS = DhcpConfigurator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private int[] dhcpOptionsWithWebServerAndSecGw = new int[]{1, 3, 6, 15, 62, 72, 241};
    private int[] dhcpOptionsWithSmrsServer = new int[]{1, 3, 6, 66, 67};

    public DhcpConfigurator(RbsConfigurationMao inRbsConfigurationMao) {
        super(inRbsConfigurationMao);
        logger.traceGeneral(THIS_CLASS, "constructor()");
    }

    public boolean applyConfiguration() throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "applyConfiguration()");
        boolean successfulConfiguration = false;
        ConfiguratorHelper.applyTemporaryIpConfiguration(this.genericMaoContext, this.rbsConfigurationMao);
        if (!RbsConfigurationHelper.existsAndNotEmpty(NodeParameters.instance(this.rbsConfigurationMao).getDhcpClientIdentifier())) {
            this.updateProgressReportInformation(100, 3, "Fetching basic IP configuration via DHCP in without laptop case", true);
            TransactionHandler.run(new FetchDhcpDataTp(this.genericMaoContext, this.rbsConfigurationMao, this.dhcpOptionsWithWebServerAndSecGw));
        } else {
            this.updateProgressReportInformation(100, 3, "Legacy: Fetching basic IP configuration via DHCP", true);
            boolean dhcpFetchSuccessful = false;
            while (!dhcpFetchSuccessful) {
                try {
                    TransactionHandler.runWithLoop(new FetchDhcpDataTp(this.genericMaoContext, this.rbsConfigurationMao, this.dhcpOptionsWithSmrsServer));
                    dhcpFetchSuccessful = true;
                }
                catch (RbsConfigurationFailedException rcfe) {
                    logger.traceGeneral(THIS_CLASS, "Received exception when configuring DHCP with Client Identifier (Legacy): " + NodeParameters.instance(this.rbsConfigurationMao).getDhcpClientIdentifier());
                    logger.traceError(THIS_CLASS, rcfe.getLocalizedMessage());
                    IpParameters.instance(this.rbsConfigurationMao).delete();
                    this.updateProgressReportInformation(100, 4, "Legacy: Fetching basic IP configuration via DHCP", true);
                    this.helper.waitForRetry("DHCP configuration not available");
                }
            }
        }
        if (this.validateIpDataReceivedFromDhcp()) {
            successfulConfiguration = true;
            this.updateProgressReportInformation(100, 5, "Finished fetching basic IP configuration via DHCP", false);
        }
        logger.traceReturn(THIS_CLASS, "applyConfiguration()");
        return successfulConfiguration;
    }

    private boolean validateIpDataReceivedFromDhcp() {
        IpParameters ip = IpParameters.instance(this.rbsConfigurationMao);
        return RbsConfigurationHelper.existsAndNotEmpty(ip.getIpAddress()) && RbsConfigurationHelper.existsAndNotEmpty(ip.getSubnetMask()) && RbsConfigurationHelper.existsAndNotEmpty(ip.getDefaultRouter());
    }
}

