/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state.initialipconfiguration.fetchegisresponse;

import java.util.List;
import se.ericsson.cello.ipoam.IpHostLinkMo;
import se.ericsson.cello.managedelement.NtpServerMo;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.FqdnIpAddressPair;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.FqdnOrIpAddress;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.FileParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.IpParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.SecGwAddresses;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.WebServerAddresses;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ProgressReportHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.RbsConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.fetchsiteinstallation.ReleaseDhcpIfTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.initialipconfiguration.ConfiguratorHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.initialipconfiguration.fetchegisresponse.EgisResponseParser;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.initialipconfiguration.fetchegisresponse.EgisStateMonitor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.initialipconfiguration.fetchegisresponse.FetchEgisResponseTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.CleanIpConfigurationTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.FetchDhcpDataTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.SetDefaultNtpServerTp;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class EgisConfigurator {
    private static final Class THIS_CLASS = EgisConfigurator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private List aiws = null;
    private List secGws = null;
    private final RbsConfigurationMao rbsConfigurationMao;
    private final GenericMaoContext genericMaoContext;
    private final RbsConfigurationHelper helper;
    private final MoRepositoryWrapper moRepositoryWrapper;
    public static final int EGIS_OK_RESPONSE = 0;
    public static final int EGIS_INVALID_RESPONSE = 1;
    public static final int EGIS_NO_RESPONSE = 2;
    public static final String EGIS_OK_RESPONSE_NAME = "EGIS_OK_RESPONSE";
    public static final String EGIS_INVALID_RESPONSE_NAME = "EGIS_INVALID_RESPONSE";
    public static final String EGIS_NO_RESPONSE_NAME = "EGIS_NO_RESPONSE";
    public static final int DELAY = 3000;

    public EgisConfigurator(RbsConfigurationMao rbsConfigurationMaoIn, RbsConfigurationHelper helperIn, MoRepositoryWrapper moRepositoryWrapperIn) {
        this.rbsConfigurationMao = rbsConfigurationMaoIn;
        this.genericMaoContext = rbsConfigurationMaoIn.getRbsConfigurationContext().getGenericMaoContext();
        this.helper = helperIn;
        this.moRepositoryWrapper = moRepositoryWrapperIn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void applyConfiguration() {
        block19: {
            logger.traceEnter(THIS_CLASS, "applyConfiguration()");
            int responseOk = 0;
            String responseName = EGIS_OK_RESPONSE_NAME;
            this.updateProgressReportInformation(95, 3, "Fetching data from the EGIS server", true);
            TransactionHandler.run(new CleanIpConfigurationTp(this.genericMaoContext, false, true));
            MoIterator moIter = this.moRepositoryWrapper.lookupType("GigaBitEthernet");
            if (moIter == null) {
                ConfiguratorHelper.createGigabitEthernetMo(this.genericMaoContext, ConfiguratorHelper.RETRY_SLEEP_TIME, this.helper);
            }
            ConfiguratorHelper.applyTemporaryIpConfiguration(this.genericMaoContext, this.rbsConfigurationMao);
            IpHostLinkMo ipHostLinkMo = (IpHostLinkMo)this.moRepositoryWrapper.lookup("ManagedElement=1,IpOam=1,Ip=1,IpHostLink=1");
            int i = 0;
            int IP_HOST_LINK_TRY_COUNT = 10;
            while (ipHostLinkMo.getOperationalState(null) == 0 && i < 10) {
                try {
                    Thread.sleep(250L);
                    logger.traceDebug(THIS_CLASS, "Waiting for IpHostLink to become available");
                    ++i;
                }
                catch (InterruptedException e) {}
            }
            int[] dhcpOptions = new int[]{1, 3, 6, 42};
            TransactionHandler.run(new FetchDhcpDataTp(this.genericMaoContext, this.rbsConfigurationMao, dhcpOptions, false));
            TransactionHandler.run(new CleanIpConfigurationTp(this.genericMaoContext, false, false));
            ConfiguratorHelper.applyTrustedNetworkConfiguration(this.genericMaoContext, this.rbsConfigurationMao, true);
            logger.traceDebug(THIS_CLASS, "NTP status, set NtpServerMo to pool.ntp.org");
            try {
                TransactionHandler.run(new SetDefaultNtpServerTp(this.genericMaoContext, "pool.ntp.org", IpParameters.instance(this.rbsConfigurationMao).getNtpServerAddress()));
                int MAX_NTP_TRIES = 100;
                NtpServerMo ntpServerMo = (NtpServerMo)this.genericMaoContext.getMoRepositoryWrapper().lookup("ManagedElement=1,SystemFunctions=1,TimeSetting=1,NtpServer=1");
                for (int ntp_try_count = 0; ntp_try_count < 100 && ntpServerMo.getServiceStatus(null) != 6; ++ntp_try_count) {
                    Thread.sleep(3000L);
                    logger.traceDebug(THIS_CLASS, "Attempt " + ntp_try_count + ", not yet synchronized");
                }
                logger.traceDebug(THIS_CLASS, "NTP status, NtpServerMo service status = " + ntpServerMo.getServiceStatus(null));
            }
            catch (Exception e) {
                logger.traceDebug(THIS_CLASS, "Unable to find NTP Service. " + e.getMessage());
            }
            responseOk = this.fetchAndParseEgisResponse();
            if (responseOk == 1) {
                responseName = EGIS_INVALID_RESPONSE_NAME;
            } else if (responseOk == 2) {
                responseName = EGIS_NO_RESPONSE_NAME;
            } else {
                EgisStateMonitor.getInstance().setIsEgisResponseFetched(true);
            }
            RbsConfigurationReportLoggerFactory.getLogger().logInformation("EGIS response received", responseName);
            Object var12_14 = null;
            this.updateProgressReportInformation(95, 5, "Finished fetching data from the EGIS server", true);
            try {
                TransactionHandler.run(new ReleaseDhcpIfTp(this.genericMaoContext));
                TransactionHandler.run(new CleanIpConfigurationTp(this.genericMaoContext, true, true));
                String initialSecGwIpAddress = IpParameters.instance(this.rbsConfigurationMao).getOuterIpConfigurationData().getInitialSecGwIpAdd();
                String initialSecGwIpFqdn = IpParameters.instance(this.rbsConfigurationMao).getOuterIpConfigurationData().getInitialSecGwFqdn();
                IpParameters.instance(this.rbsConfigurationMao).delete();
                IpParameters.instance(this.rbsConfigurationMao).getOuterIpConfigurationData().setInitialSecGwIpAdd(initialSecGwIpAddress);
                IpParameters.instance(this.rbsConfigurationMao).getOuterIpConfigurationData().setInitialSecGwFqdn(initialSecGwIpFqdn);
                FileParameters.instance(this.rbsConfigurationMao).delete(false);
            }
            catch (RbsConfigurationFailedException e2) {
                logger.traceDebug(THIS_CLASS, "Failure in EGIS step cleanup: " + e2.getMessage());
            }
            break block19;
            {
                catch (Exception e) {
                    logger.traceDebug(THIS_CLASS, e.toString());
                    RbsConfigurationReportLoggerFactory.getLogger().logInformation("Failure during fetching EGIS response", e.getMessage());
                    Object var12_15 = null;
                    this.updateProgressReportInformation(95, 5, "Finished fetching data from the EGIS server", true);
                    try {
                        TransactionHandler.run(new ReleaseDhcpIfTp(this.genericMaoContext));
                        TransactionHandler.run(new CleanIpConfigurationTp(this.genericMaoContext, true, true));
                        String initialSecGwIpAddress = IpParameters.instance(this.rbsConfigurationMao).getOuterIpConfigurationData().getInitialSecGwIpAdd();
                        String initialSecGwIpFqdn = IpParameters.instance(this.rbsConfigurationMao).getOuterIpConfigurationData().getInitialSecGwFqdn();
                        IpParameters.instance(this.rbsConfigurationMao).delete();
                        IpParameters.instance(this.rbsConfigurationMao).getOuterIpConfigurationData().setInitialSecGwIpAdd(initialSecGwIpAddress);
                        IpParameters.instance(this.rbsConfigurationMao).getOuterIpConfigurationData().setInitialSecGwFqdn(initialSecGwIpFqdn);
                        FileParameters.instance(this.rbsConfigurationMao).delete(false);
                    }
                    catch (RbsConfigurationFailedException e2) {
                        logger.traceDebug(THIS_CLASS, "Failure in EGIS step cleanup: " + e2.getMessage());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                this.updateProgressReportInformation(95, 5, "Finished fetching data from the EGIS server", true);
                try {
                    TransactionHandler.run(new ReleaseDhcpIfTp(this.genericMaoContext));
                    TransactionHandler.run(new CleanIpConfigurationTp(this.genericMaoContext, true, true));
                    String initialSecGwIpAddress = IpParameters.instance(this.rbsConfigurationMao).getOuterIpConfigurationData().getInitialSecGwIpAdd();
                    String initialSecGwIpFqdn = IpParameters.instance(this.rbsConfigurationMao).getOuterIpConfigurationData().getInitialSecGwFqdn();
                    IpParameters.instance(this.rbsConfigurationMao).delete();
                    IpParameters.instance(this.rbsConfigurationMao).getOuterIpConfigurationData().setInitialSecGwIpAdd(initialSecGwIpAddress);
                    IpParameters.instance(this.rbsConfigurationMao).getOuterIpConfigurationData().setInitialSecGwFqdn(initialSecGwIpFqdn);
                    FileParameters.instance(this.rbsConfigurationMao).delete(false);
                }
                catch (RbsConfigurationFailedException e2) {
                    logger.traceDebug(THIS_CLASS, "Failure in EGIS step cleanup: " + e2.getMessage());
                }
                throw throwable;
            }
        }
        logger.traceReturn(THIS_CLASS, "applyConfiguration()");
    }

    private int fetchAndParseEgisResponse() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "fetchAndParseEgisResponse()");
        int responseOk = 2;
        FetchEgisResponseTp fetchEgisResponseTp = new FetchEgisResponseTp();
        TransactionHandler.runWithLoop(fetchEgisResponseTp);
        String egisResponse = fetchEgisResponseTp.getEgisResponse();
        if (egisResponse != null) {
            responseOk = 1;
            IpParameters.instance().getOuterIpConfigurationData().setInitialSecGwFqdn("");
            IpParameters.instance().getOuterIpConfigurationData().setInitialSecGwIpAdd("");
            SecGwAddresses secGwAddresses = SecGwAddresses.instance(this.rbsConfigurationMao);
            secGwAddresses.setSecGwAddresses((FqdnIpAddressPair[])null);
            WebServerAddresses webServerAddresses = WebServerAddresses.instance(this.rbsConfigurationMao);
            webServerAddresses.setWebServerAddresses((FqdnOrIpAddress[])null);
            EgisResponseParser parser = new EgisResponseParser(egisResponse);
            parser.parse();
            this.aiws = parser.getAiWebServers();
            this.secGws = parser.getSecurityGateWays();
            if (this.secGws.isEmpty() && this.aiws.isEmpty()) {
                logger.traceDebug(THIS_CLASS, "Empty response received from EGIS");
            } else if (this.secGws.isEmpty()) {
                logger.traceDebug(THIS_CLASS, "No security gateways in response from EGIS");
            } else if (this.aiws.isEmpty()) {
                logger.traceDebug(THIS_CLASS, "No AIWS in response from EGIS");
            } else {
                secGwAddresses.setSecGwAddresses(this.secGws.toArray(new FqdnIpAddressPair[this.secGws.size()]));
                secGwAddresses.setNextSecGwAddress(0);
                webServerAddresses.setWebServerAddresses(this.aiws.toArray(new FqdnOrIpAddress[this.aiws.size()]));
                responseOk = 0;
            }
        }
        logger.traceReturn(THIS_CLASS, "fetchAndParseEgisResponse()");
        return responseOk;
    }

    protected void updateProgressReportInformation(int integrationStepNumber, int status, String detailedInformation, boolean updateProgressReport) {
        ProgressReportHandler.getInstance().updateProgressReportInformation(integrationStepNumber, status, detailedInformation, updateProgressReport);
    }
}

